<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useHrefIcon="true" >
<style type="text/css">
	img.ICON { max-width:100px; max-height:100px; }
</style>
</og:head>
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6260"
	title	= "アップロード"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- 注意 upload タグで、multipart/form-data から値を取り出しているため、
	 このタグより前では、{@xxxx} は、使用できません。
	 {@USER.xxxx} は、別途登録しているので、使用できます。   -->
<og:upload
	fileURL		= "{@USER.ID}"
	columns		= "FILE,FILE_ORG,FILE_NEW,FILE_PFX,FILE_SFX,BIKO,submitter,writable,SEQNO,SYSTEM_ID,PATH,THUMB_PATH"
	useBackup	= "rename"
/>
<br />
<og:message lbl="MSG0003" comment="ファイルの登録が完了しました。" />

<og:entry command="ALLACTION">
	<og:columnSet command="ALLACTION" columnId="SYSTEM_ID" action="SET"    value="{@SYS.SYSTEM_ID}" />
	<og:columnSet command="ALLACTION" columnId="PATH"      action="SET"    value="{@SYS.FILE_URL}{@USER.ID}" />
</og:entry>

<og:tableFilter classId="THUMBNAIL" keys="PATH_CLM,FILE_CLM,THUMB_CLM" vals="PATH,FILE,THUMB_PATH" />

<og:columnEditor column="FILE" renderer="ICON" />

<!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
<og:viewMarker command="{@command}">
	<og:columnMarker column="FILE"  onMark="[THUMB_PATH]" markList="[THUMB_PATH]">
		<img src="{@SYS.CONTEXT_URL}[THUMB_PATH]" alt="THUMB_PATH" />
	</og:columnMarker>
</og:viewMarker>

<og:viewLink command="{@command}">
	<og:link column="FILE_ORG" href="{@SYS.CONTEXT_URL}[PATH]/[FILE_ORG]"  useHrefEncode="true" target="_blunk" useGamenId="false" />
</og:viewLink>

<p>
	<og:link href="{@SYS.CONTEXT_URL}{@SYS.FILE_URL}{@USER.ID}/{@FILE_01}" target="_blunk" useGamenId="false" useHrefEncode="true" /><br />
	<og:link href="{@SYS.CONTEXT_URL}{@SYS.FILE_URL}{@USER.ID}/{@FILE_02}" target="_blunk" useGamenId="false" useHrefEncode="true" /><br />
	<og:link href="{@SYS.CONTEXT_URL}{@SYS.FILE_URL}{@USER.ID}/{@FILE_03}" target="_blunk" useGamenId="false" useHrefEncode="true" /><br />
</p>
	<og:view
		command      = "NEW"
		viewFormType = "HTMLTable" 
		writable     = "{@writable}"
		useScrollBar = "false"
	/>

	<table>
	  <tr><og:input name="submitter" value="{@submitter}" /></tr>
	  <tr><og:input name="writable"  value="{@writable}"  /></tr>
	  <tr><og:input name="directory" value="{@directory}" /></tr>
	  <tr><og:input name="FILE_01"     value="{@FILE_01}"     /></tr>
	  <tr><og:input name="FILE_01_NEW" value="{@FILE_01_NEW}" /></tr>
	  <tr><og:input name="FILE_01_ORG" value="{@FILE_01_ORG}" /></tr>
	  <tr><og:input name="FILE_02"     value="{@FILE_02}"     /></tr>
	  <tr><og:input name="FILE_02_NEW" value="{@FILE_02_NEW}" /></tr>
	  <tr><og:input name="FILE_02_ORG" value="{@FILE_02_ORG}" /></tr>
	  <tr><og:input name="FILE_03"     value="{@FILE_03}"     /></tr>
	  <tr><og:input name="FILE_03_NEW" value="{@FILE_03_NEW}" /></tr>
	  <tr><og:input name="FILE_03_ORG" value="{@FILE_03_ORG}" /></tr>
	  <tr><og:input name="FILE_04"     value="{@FILE_04}"     /></tr>
	  <tr><og:input name="FILE_04_NEW" value="{@FILE_04_NEW}" /></tr>
	  <tr><og:input name="FILE_04_PFX" value="{@FILE_04_PFX}" /></tr>
	  <tr><og:input name="FILE_04_SFX" value="{@FILE_04_SFX}" /></tr>
	  <tr><og:input name="FILE_04_ORG" value="{@FILE_04_ORG}" /></tr>
	  <tr><og:input name="FILE_05"     value="{@FILE_05}"     /></tr>
	  <tr><og:input name="FILE_05_NEW" value="{@FILE_05_NEW}" /></tr>
	  <tr><og:input name="FILE_05_PFX" value="{@FILE_05_PFX}" /></tr>
	  <tr><og:input name="FILE_05_SFX" value="{@FILE_05_SFX}" /></tr>
	  <tr><og:input name="FILE_05_ORG" value="{@FILE_05_ORG}" /></tr>
	</table>

	<!-- ファイルアップロードで、アップロードされたファイルは、UPLOAD_FILES リクエスト変数にカンマ区切りで保存しています。 -->
	<og:text>{@UPLOAD_FILES}</og:text>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
