/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.db;

/**
 * データのコード情報を取り扱うSelectionクラスの、NULL時オブジェクトです。
 *
 * 以前は、Selection オブジェクトが null の場合に、NullPointerException で
 * いきなりエラーで停止していましたが、この、NULLセレクションを作成することで、
 * 取りあえず、どういう状況なのか、判るようにします。
 *
 * @og.rev 5.7.3.0 (2014/02/07) 新規追加
 * @og.rev 5.7.7.1 (2014/06/13) Selectionオブジェクトの基本実装とします。
 * @og.group 選択データ制御
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
// public class Selection_NULL extends Selection_KEYVAL {
public class Selection_NULL implements Selection {
	private final String	initMsg ;

	/**
	 * デフォルトコンストラクター
	 * 継承元のクラスから、呼び出させるように、作成しておきます。
	 *
	 * @og.rev 5.7.7.1 (2014/06/13) 新規追加
	 */
	public Selection_NULL() { initMsg = null; }

	/**
	 * 引数に初期メッセージを指定して作成する、コンストラクター
	 *
	 * @og.rev 5.7.3.0 (2014/02/07) 新規追加
	 *
	 * @param	strCode	初期メッセージ文字列
	 */
	public Selection_NULL( final String strCode ) {
//		super( null );
		initMsg = strCode ;
	}

	/**
	 * 初期値が選択済みの 選択肢(オプション)を返します。
	 * このオプションは、引数の値を初期値とするオプションタグを返します。
	 * このメソッドでは、ラベル(短)が設定されている場合でも、これを使用せずに必ずラベル(長)を使用します。
	 *
	 * @og.rev 5.7.7.1 (2014/06/13) 新規追加
	 *
	 * @param   selectValue  選択されている値
	 * @param   seqFlag  シーケンスアクセス機能 [true:ON/false:OFF]
	 *
	 * @return  オプションタグ
	 * @og.rtnNotNull
	 * @see     #getOption( String, boolean, boolean )
	 */
	@Override
	public String getOption( final String selectValue,final boolean seqFlag ) {
		return getOption( selectValue, seqFlag, false );
	}

	/**
	 * 初期値が選択済みの 選択肢(オプション)を返します。
	 * 無条件で、初期メッセージを返します。
	 *
	 * @og.rev 5.7.3.0 (2014/02/07) 新規追加
	 *
	 * @param   selectValue  選択されている値
	 * @param   seqFlag  シーケンスアクセス機能 [true:ON/false:OFF]
	 * @param   useShortLabel ラベル(短)をベースとしたオプション表示を行うかどうか(常にfalse)。
	 *
	 * @return  オプションタグ
	 * @og.rtnNotNull
	 * @og.rtnNotNull
	 * @see     #getOption( String, boolean )
	 */
	@Override
	public String getOption( final String selectValue,final boolean seqFlag, final boolean useShortLabel ) {
		return initMsg + " value=[" + selectValue + "]";
	}

	/**
	 * 初期値が選択済みの 選択肢(オプション)を返します。
	 * このオプションは、引数の値を初期値とするオプションタグを返します。
	 * ※ このクラスでは実装されていません。→ 実装を入れます。
	 *
	 * @og.rev 6.0.4.0 (2014/11/28) 実装を入れます。
	 *
	 * @param   name         ラジオの name
	 * @param   selectValue  選択されている値
	 * @param   useLabel     ラベル表示の有無 [true:有/false:無]
	 *
	 * @return  オプションタグ
	 * @og.rtnNotNull
	 */
	@Override
	public String getRadio( final String name,final String selectValue,final boolean useLabel ) {
//	final String errMsg = "このクラスでは実装されていません。";
//		throw new UnsupportedOperationException( errMsg );
		return initMsg + " name=[" + name + "] value=[" + selectValue + "]";
	}

	/**
	 * 初期値が選択済みの 選択肢(オプション)を返します。
	 * このオプションは、引数の値を初期値とするオプションタグを返します。
	 * ※ このクラスでは実装されていません。→ 実装を入れます。
	 *
	 * @og.rev 6.0.4.0 (2014/11/28) 実装を入れます。
	 *
	 * @param   selectValue  選択されている値
	 *
	 * @return  オプションタグ
	 */
	@Override
	public String getRadioLabel( final String selectValue ) {
//	final String errMsg = "このクラスでは実装されていません。";
//		throw new UnsupportedOperationException( errMsg );
		return getValueLabel( selectValue,false );
	}

	/**
	 * 選択肢(value)に対するラベルを返します。
	 * 選択肢(value)が、存在しなかった場合は、選択肢そのものを返します。
	 * getValueLabel( XX ) は、getValueLabel( XX,false ) と同じです。
	 *
	 * @param   selectValue 選択肢の値
	 *
	 * @return  選択肢のラベル
	 * @see     #getValueLabel( String,boolean )
	 */
	@Override
	public String getValueLabel( final String selectValue ) {
		return getValueLabel( selectValue,false );
	}

	/**
	 * 選択肢(value)に対するラベルを返します。
	 * 無条件で、初期メッセージを返します。
	 *
	 * @og.rev 5.7.3.0 (2014/02/07) 新規追加
	 *
	 * @param	selectValue	選択肢の値
	 * @param	flag	短縮ラベルを [true:使用する/false:しない](常に false)
	 *
	 * @return  選択肢のラベル
	 * @og.rtnNotNull
	 * @see     #getValueLabel( String )
	 */
	@Override
	public String getValueLabel( final String selectValue,final boolean flag ) {
		return initMsg + " value=[" + selectValue + "]";
	}

//	/**
//	 * マルチ・キーセレクトを使用するかどうかを返します。
//	 * true：使用する。false:使用しない です。
//	 * ただし、実際に使用するかどうかは、HTML出力時に決めることが出来ます。
//	 * ここでは、USE_MULTI_KEY_SELECT が true で、USE_SIZE(=20)以上の場合に
//	 * true を返します。
//	 *
//	 * ※ ここでは、常に false を返します。
//	 *
//	 * @og.rev 6.0.4.0 (2014/11/28) Column 側に移動。
//	 *
//	 * @return  選択リストで、マルチ・キーセレクトを使用するかどうか(常に false)
//	 */
//	@Override
//	public boolean useMultiSelect() {
//		return false;
//	}

	/**
	 * オブジェクトのキャッシュが時間切れかどうかを返します。
	 * キャッシュが時間切れ(無効)であれば、true を、有効であれば、
	 * false を返します。
	 *
	 * ※ ここでは、常に false を返します。
	 *
	 * @return  キャッシュが時間切れなら true
	 */
	@Override
	public boolean isTimeOver() {
		return false;
	}
}
