/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.resource.GUIAccessCount;
import org.opengion.hayabusa.resource.GUIData;
import org.opengion.hayabusa.resource.LabelData;
import org.opengion.hayabusa.resource.RoleMode;

public final class GUIInfo
implements Comparable<GUIInfo> {
    private static final String YOYAKU = "|KEY|ADDRESS|REALADDRESS|SEQUENCE|GROUPS|CLASSIFY|LEVEL|LABEL|NAME|SNAME|LNAME|ROLES|MODE|TARGET|PARAM|KBLINK|DESCRIPTION|DYUPD|IMAGEKEY|";
    private final GUIData guiData;
    private final LabelData labelData;
    private final String[] groupKeys;
    private final boolean menuFlag;
    private final boolean writeFlag;
    private final byte bitMode;
    private final boolean pulldownFlag;
    private final GUIAccessCount accessCount;
    private int level;
    private final Set<String> nextGui = new LinkedHashSet<String>();

    public GUIInfo(GUIData gUIData, LabelData labelData, byte by) {
        this.guiData = gUIData;
        this.labelData = labelData;
        this.groupKeys = StringUtil.csv2Array((String)gUIData.getGroups());
        this.menuFlag = RoleMode.isMenu(by);
        this.writeFlag = RoleMode.isWrite(by);
        this.pulldownFlag = RoleMode.isPulldown(by);
        this.accessCount = new GUIAccessCount(gUIData.getGuiKey());
        this.bitMode = by;
        this.level = gUIData.getGuiLevel();
    }

    public String getKey() {
        return this.guiData.getGuiKey();
    }

    public String getAddress() {
        return this.guiData.getAddress();
    }

    public String getRealAddress() {
        return this.guiData.getRealAddress();
    }

    public String getRealAddress(String string) {
        return this.guiData.getRealAddress(string);
    }

    public int getSequence() {
        return this.guiData.getSeqno();
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevelUp() {
        if (this.level == 4) {
            this.level = 3;
        }
    }

    public String getGroups() {
        return this.guiData.getGroups();
    }

    public boolean isGroupIn(String string) {
        if (this.groupKeys.length == 0 || string == null || string.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.groupKeys.length; ++i) {
            if (!string.equals(this.groupKeys[i])) continue;
            return true;
        }
        return false;
    }

    public String getClassify() {
        return this.guiData.getClassify();
    }

    public String getLabel() {
        return this.labelData.getLabel();
    }

    public String getName() {
        return this.labelData.getShortLabel();
    }

    public String getLongName() {
        return this.labelData.getLongLabel();
    }

    public String getRoles() {
        return this.guiData.getRoles();
    }

    public String getMode() {
        return this.guiData.getMode();
    }

    public String getTarget() {
        return this.guiData.getTarget();
    }

    public String getParam() {
        return this.guiData.getParam();
    }

    public String getKblink() {
        return this.guiData.getKblink();
    }

    public String getDescription() {
        return this.labelData.getDescription();
    }

    public String getDyupd() {
        return this.guiData.getDyupd();
    }

    public String getImageKey() {
        return this.guiData.getImageKey();
    }

    public RoleMode getRoleMode() {
        return this.guiData.getRoleMode();
    }

    public boolean isRead() {
        return this.menuFlag;
    }

    public boolean isWrite() {
        return this.writeFlag;
    }

    public boolean isPulldown() {
        return this.pulldownFlag;
    }

    public byte getBitMode() {
        return this.bitMode;
    }

    public boolean isFaq() {
        return this.guiData.isFaq();
    }

    public String getAttribute(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("KEY")) {
            string2 = this.getKey();
        } else if (string.equalsIgnoreCase("GUICLM")) {
            string2 = this.labelData.getKey();
        } else if (string.equalsIgnoreCase("ADDRESS")) {
            string2 = this.getAddress();
        } else if (string.equalsIgnoreCase("REALADDRESS")) {
            string2 = this.getRealAddress();
        } else if (string.equalsIgnoreCase("SEQUENCE")) {
            string2 = String.valueOf(this.getSequence());
        } else if (string.equalsIgnoreCase("GROUPS")) {
            string2 = this.getGroups();
        } else if (string.equalsIgnoreCase("CLASSIFY")) {
            string2 = this.getClassify();
        } else if (string.equalsIgnoreCase("LEVEL")) {
            string2 = String.valueOf(this.getLevel());
        } else if (string.equalsIgnoreCase("LABEL")) {
            string2 = this.getLabel();
        } else if (string.equalsIgnoreCase("NAME")) {
            string2 = this.getName();
        } else if (string.equalsIgnoreCase("SNAME")) {
            string2 = this.getName();
        } else if (string.equalsIgnoreCase("LNAME")) {
            string2 = this.getLongName();
        } else if (string.equalsIgnoreCase("ROLE")) {
            string2 = this.getRoles();
        } else if (string.equalsIgnoreCase("ROLES")) {
            string2 = this.getRoles();
        } else if (string.equalsIgnoreCase("MODE")) {
            string2 = this.getMode();
        } else if (string.equalsIgnoreCase("TARGET")) {
            string2 = this.getTarget();
        } else if (string.equalsIgnoreCase("PARAM")) {
            string2 = this.getParam();
        } else if (string.equalsIgnoreCase("KBLINK")) {
            string2 = this.getKblink();
        } else if (string.equalsIgnoreCase("DESCRIPTION")) {
            string2 = this.getDescription();
        } else if (string.equalsIgnoreCase("IMAGEKEY")) {
            string2 = this.getImageKey();
        } else if (string.equalsIgnoreCase("DYUPD")) {
            string2 = this.getDyupd();
        } else if (string.equalsIgnoreCase("ISREAD")) {
            string2 = String.valueOf(this.isRead());
        } else if (string.equalsIgnoreCase("ISWRITE")) {
            string2 = String.valueOf(this.isWrite());
        } else if (string.equalsIgnoreCase("FAQ")) {
            string2 = String.valueOf(this.isFaq());
        } else {
            String string3 = "\u5c5e\u6027\u6587\u5b57\u5217\u30ad\u30fc\u304c\u4e0d\u6b63\u3067\u3059\u3002 key=[" + string + "]" + HybsConst.CR + "\u4e88\u7d04\u8a9e(" + YOYAKU + ") \u4ee5\u5916\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002";
            throw new HybsSystemException(string3);
        }
        return string2;
    }

    public HybsEntry[] getEntrys() {
        ArrayList<HybsEntry> arrayList = new ArrayList<HybsEntry>();
        arrayList.add(new HybsEntry("GUI.KEY", this.getAttribute("KEY"), "\u753b\u9762ID"));
        arrayList.add(new HybsEntry("GUI.GUICLM", this.getAttribute("GUICLM"), "\u753b\u9762\u30ab\u30e9\u30e0ID"));
        arrayList.add(new HybsEntry("GUI.ADDRESS", this.getAttribute("ADDRESS"), "\u5b9f\u884c\u30a2\u30c9\u30ec\u30b9"));
        arrayList.add(new HybsEntry("GUI.REALADDRESS", this.getAttribute("REALADDRESS"), "\u5b9f\u884c\u5b9f\u30a2\u30c9\u30ec\u30b9"));
        arrayList.add(new HybsEntry("GUI.SEQUENCE", this.getAttribute("SEQUENCE"), "\u8868\u793a\u9806"));
        arrayList.add(new HybsEntry("GUI.GROUPS", this.getAttribute("GROUPS"), "\u30e1\u30cb\u30e5\u30b0\u30eb\u30fc\u30d7"));
        arrayList.add(new HybsEntry("GUI.CLASSIFY", this.getAttribute("CLASSIFY"), "\u30e1\u30cb\u30e5\u5206\u985e"));
        arrayList.add(new HybsEntry("GUI.LEVEL", this.getAttribute("LEVEL"), "\u30e1\u30cb\u30e5\u968e\u5c64\u756a\u53f7"));
        arrayList.add(new HybsEntry("GUI.LABEL", this.getAttribute("LABEL"), "\u753b\u9762\u540d\u79f0"));
        arrayList.add(new HybsEntry("GUI.NAME", this.getAttribute("NAME"), "\u753b\u9762\u540d\u79f0(=SNAME)"));
        arrayList.add(new HybsEntry("GUI.SNAME", this.getAttribute("SNAME"), "\u753b\u9762\u540d\u79f0(short)"));
        arrayList.add(new HybsEntry("GUI.LNAME", this.getAttribute("LNAME"), "\u753b\u9762\u540d\u79f0(long)"));
        arrayList.add(new HybsEntry("GUI.ROLES", this.getAttribute("ROLES"), "\u30ed\u30fc\u30eb"));
        arrayList.add(new HybsEntry("GUI.MODE", this.getAttribute("MODE"), "\u30a2\u30af\u30bb\u30b9\u30e2\u30fc\u30c9\u5217(mr,mw,-r,-w \u306e\u7f85\u5217)"));
        arrayList.add(new HybsEntry("GUI.TARGET", this.getAttribute("TARGET"), "\u30bf\u30fc\u30b2\u30c3\u30c8"));
        arrayList.add(new HybsEntry("GUI.PARAM", this.getAttribute("PARAM"), "\u30d1\u30e9\u30e1\u30fc\u30bf"));
        arrayList.add(new HybsEntry("GUI.KBLINK", this.getAttribute("KBLINK"), "\u30ea\u30f3\u30af\u533a\u5206"));
        arrayList.add(new HybsEntry("GUI.DESCRIPTION", this.getAttribute("DESCRIPTION"), "\u6982\u8981\u8aac\u660e"));
        arrayList.add(new HybsEntry("GUI.IMAGEKEY", this.getAttribute("IMAGEKEY"), "\u30a4\u30e1\u30fc\u30b8\u30ad\u30fc"));
        arrayList.add(new HybsEntry("GUI.DYUPD", this.getAttribute("DYUPD"), "\u66f4\u65b0\u65e5\u6642"));
        arrayList.add(new HybsEntry("GUI.ISREAD", this.getAttribute("ISREAD"), "\u8aad\u53d6\u308a\u8a31\u53ef[true/false]"));
        arrayList.add(new HybsEntry("GUI.ISWRITE", this.getAttribute("ISWRITE"), "\u66f8\u8fbc\u307f\u8a31\u53ef[true/false]"));
        return arrayList.toArray(new HybsEntry[arrayList.size()]);
    }

    public void addReadCount(int n, long l, String string) {
        this.accessCount.addReadCount(n, l, string);
    }

    public void addWriteCount(int n, long l, String string) {
        this.accessCount.addWriteCount(n, l, string);
    }

    public void addAccessCount() {
        if (this.level == 4) {
            this.level = 3;
        }
        this.accessCount.addAccessCount();
    }

    public void addErrorCount() {
        this.accessCount.addErrorCount();
    }

    public GUIAccessCount getGUIAccessCount() {
        return this.accessCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextGuiKey(String string) {
        if (string != null && !string.equals(this.getKey())) {
            Set<String> set = this.nextGui;
            synchronized (set) {
                if (!this.nextGui.contains(string)) {
                    this.nextGui.add(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextGuiKeys() {
        StringBuilder stringBuilder = new StringBuilder(200);
        Set<String> set = this.nextGui;
        synchronized (set) {
            for (String string : this.nextGui) {
                stringBuilder.append(string).append(',');
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNextGuiArray() {
        String[] stringArray;
        Set<String> set = this.nextGui;
        synchronized (set) {
            stringArray = this.nextGui.toArray(new String[this.nextGui.size()]);
        }
        return stringArray;
    }

    @Override
    public int compareTo(GUIInfo gUIInfo) {
        if (gUIInfo == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u304c\u3001null \u3067\u3059\u3002");
        }
        return this.getSequence() - gUIInfo.getSequence();
    }

    public boolean equals(Object object) {
        if (object instanceof GUIInfo) {
            return this.getKey().equals(((GUIInfo)object).getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200).append("key        :").append(this.getKey()).append(HybsConst.CR).append("lvlclm     :").append(this.labelData.getKey()).append(HybsConst.CR).append("address    :").append(this.getAddress()).append(HybsConst.CR).append("sequence   :").append(this.getSequence()).append(HybsConst.CR).append("groups     :").append(this.getGroups()).append(HybsConst.CR).append("classify   :").append(this.getClassify()).append(HybsConst.CR).append("level      :").append(this.getLevel()).append(HybsConst.CR).append("name       :").append(this.getName()).append(HybsConst.CR).append("longName   :").append(this.getLongName()).append(HybsConst.CR).append("roles      :").append(this.getRoles()).append(HybsConst.CR).append("mode       :").append(this.getMode()).append(HybsConst.CR).append("target     :").append(this.getTarget()).append(HybsConst.CR).append("kblink     :").append(this.getKblink()).append(HybsConst.CR).append("description:").append(this.getDescription()).append(HybsConst.CR).append("imageKey   :").append(this.getImageKey()).append(HybsConst.CR).append("dyupd      :").append(this.getDyupd()).append(HybsConst.CR);
        return stringBuilder.toString();
    }
}

