/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import org.opengion.fukurou.util.ImageUtil;
import org.opengion.fukurou.util.LogWriter;

public class ImageResizer {
    private final BufferedImage inputImage;
    private final int inSizeX;
    private final int inSizeY;

    public ImageResizer(String string) {
        this.inputImage = ImageUtil.readFile(string);
        this.inSizeX = this.inputImage.getWidth();
        this.inSizeY = this.inputImage.getHeight();
    }

    public void resizeByPixel(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        if (this.inSizeX > this.inSizeY) {
            n2 = n;
            n3 = this.inSizeY * n / this.inSizeX;
        } else {
            n2 = this.inSizeX * n / this.inSizeY;
            n3 = n;
        }
        this.convert(this.inputImage, string, n2, n3);
    }

    public void resizeByPixel(String string, int n, int n2) {
        this.convert(this.inputImage, string, n, n2);
    }

    public void resizeByRatio(String string, double d) {
        int n = (int)((double)this.inSizeX * d);
        int n2 = (int)((double)this.inSizeY * d);
        this.convert(this.inputImage, string, n, n2);
    }

    private void convert(BufferedImage bufferedImage, String string, int n, int n2) {
        if (!ImageUtil.isWriterSuffix(string)) {
            String string2 = "\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u306f" + ImageUtil.WRITER_SUFFIXES + "\u306e\u3044\u305a\u308c\u304b\u306e\u5f62\u5f0f\u306e\u307f\u6307\u5b9a\u53ef\u80fd\u3067\u3059\u3002" + "File=[" + string + "]";
            throw new RuntimeException(string2);
        }
        int n3 = bufferedImage.getType();
        BufferedImage bufferedImage2 = null;
        bufferedImage2 = n3 == 0 ? new BufferedImage(n, n2, 7) : new BufferedImage(n, n2, bufferedImage.getType());
        AffineTransformOp affineTransformOp = null;
        affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance((double)n / (double)this.inSizeX, (double)n2 / (double)this.inSizeY), null);
        affineTransformOp.filter(bufferedImage, bufferedImage2);
        ImageUtil.saveFile(bufferedImage2, string);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            LogWriter.log("Usage: java org.opengion.fukurou.util.ImageResizer [Input Filename] [OutputFilename] [MaxResize]");
            return;
        }
        ImageResizer imageResizer = new ImageResizer(stringArray[0]);
        imageResizer.resizeByPixel(stringArray[1], Integer.parseInt(stringArray[2]));
    }
}

