<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7201"
	title	= "横棒／縦棒グラフ"
	date	= "2012/05/09"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<!-- パレート図は、同じデータを 使うので、useTableData = "true" のサンプルを提示 -->
<og:query command="{@command}">
		SELECT 	 VALUE				as CATEGORY
				, CEIL( ROW_ID * COL_ID * 10 * DBMS_RANDOM.VALUE ) 	as VAL
				, COLOR				as COLOR
		FROM GF46
		WHERE VALUE IS NOT NULL
	<og:where startKey="and">
		<og:and value=" DEPTNO = {@SOOUID}" />
	</og:where>
		ORDER BY VAL DESC
</og:query>
<og:view command="{@command}"/>
<og:chartCreate
	title		= "{@chartType}"
	width		= "500"
	height		= "500"
	plotOrientation	 = "{@plotOrientation}"
>
	<og:chartDataset
		chartType	= "{@chartType}"
		itemLabelVisible= "true"
		useTableData	= "true"
		useCategoryColor= "true"
	/>

	<og:equals val1="{@Pareto}" val2="true">
		<og:chartDataset
			chartType		= "HybsParetoLine"
			itemLabelVisible= "true"
			useTableData	= "true"
			useCategoryColor= "true"
			valueLabelsVisible = "true"
			tickSize		= "10"
			lowerBound		= "0"
			upperBound		= "109"
			baseLegend		= "false"
		/>
	</og:equals>
</og:chartCreate>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
