/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.AbstractEditor;
import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.fukurou.util.TagBuffer;

import org.opengion.fukurou.util.StringUtil;

/**
 * YMD エディターは、カラムのデータを日付(年/月/日)編集する場合に使用するクラスです。
 * YMD3はカレンダーのポップアップボタンが付属するタイプです。
 * YMD2と異なり、ポップアップをmodalDialogで立ち上げるのではなく、JavaScriptで作成します。（HTML5対応）
 *
 * このエディタはeventColumnに対応していません。
 *
 *  カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * @og.rev 5.8.9.0 (2015/08/08) 新規作成
 * @og.group データ編集
 *
 * @version  4.0
 * @author   Takahashi Masakazu
 * @since    JDK5.0,
 */
public class Editor_YMD3 extends AbstractEditor {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "5.8.9.0 (2015/08/08)" ;

	private static final String CAL1 = "<img src=\"../image/calendar.gif\" alt=\"Calendar\" class=\"calPic\" targetId=\"";
	private static final String CAL2 = "\" />";

	/**
	 * デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 *
	 */
	public Editor_YMD3() {
		// 4.3.4.4 (2009/01/01)
//		super();
	}

	/**
	 * コンストラクター。
	 *
	 * @param	clm	DBColumnオブジェクト
	 */
	private Editor_YMD3( final DBColumn clm ) {
		super( clm );
		tagBuffer.add( XHTMLTag.inputAttri( attributes ) );
	}

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellEditorオブジェクト
	 */
	public CellEditor newInstance( final DBColumn clm ) {
		return new Editor_YMD3( clm );
	}

	/**
	 * データの編集用文字列を返します。
	 *
	 * @param	value 入力値
	 *
	 * @return	データの編集用文字列
	 */
	@Override
	public String getValue( final String value ) {
		final String id = StringUtil.nval( attributes.get( "id" ) , name );

		final String tag = new TagBuffer( "input" )
						.add( "name"	, name )
//						.add( "id"		, name , isNull( attributes.get( "id" ) ) )
						.add( "id"		, id )
						.add( "value"	, value )
						.add( "size"	, size1 )
						.add( tagBuffer.makeTag() )
						.makeTag();

		return tag + CAL1 + id + CAL2 ;

//		String id;
//
//		TagBuffer tag = new TagBuffer( "input" );
//		tag.add( "name"    , name );
//		if( attributes.get( "id" ) == null || attributes.get( "id" ).length() == 0 ) { // 4.3.7.2 (2009/06/15)
//			id = name;
//			tag.add( "id"      , name );
//		}
//		else{
//			id = attributes.get( "id" );
//		}
//		tag.add( "value"   , value );
//		tag.add( "size"    , size1 );
//		tag.add( tagBuffer.makeTag() );
//		tag.add( optAttr );		// 3.5.5.8 (2004/05/20)
//
//		return tag.makeTag() + CAL1 + id + CAL2 ;
	}

	/**
	 * name属性を変えた、データ表示/編集用のHTML文字列を作成します。
	 * テーブル上の name に 行番号を付加して、名前_行番号 で登録するキーを作成し,
	 * リクエスト情報を１つ毎のフィールドで処理できます。
	 *
	 * @param	row   行番号
	 * @param	value 入力値
	 *
	 * @return	データ表示/編集用の文字列
	 */
	@Override
	public String getValue( final int row,final String value ) {
		final String name2 =  name + HybsSystem.JOINT_STRING + row ;

		// 6.1.1.0 (2015/01/17) TagBufferの連結記述
		final String tag = new TagBuffer( "input" )
						.add( "name"	, name2 )
//						.add( "id"		, name2 , isNull( attributes.get( "id" ) ) )
						.add( "id"		, name2 )
						.add( "value"	, value )
						.add( "size"	, size2 )
						.add( tagBuffer.makeTag() )
						.makeTag( row,value );

		return tag + CAL1 + name2 + CAL2 ;

//		TagBuffer tag = new TagBuffer( "input" );
//		String name2 =  name + HybsSystem.JOINT_STRING + row ;
//		tag.add( "name"    , name2);
//		if( attributes.get( "id" ) == null || attributes.get( "id" ).length() == 0 ) { // 4.3.7.2 (2009/06/15)
//			tag.add( "id"      , name2);
//		}
//		tag.add( "value"   , value );
//		tag.add( "size"    , size2 );
//		tag.add( tagBuffer.makeTag() );
//		tag.add( optAttr );		// 3.5.5.8 (2004/05/20)
//
//		return tag.makeTag( row,value ) + CAL1 + name2 + CAL2 ;
	}
}
