/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.io.TableWriter;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class WriteTableTag
extends CommonTagSupport {
    private static final String VERSION = "6.2.0.0 (2015/02/27)";
    private static final long serialVersionUID = 620020150227L;
    private final String BASE_URL = HybsSystem.sys("FILE_URL");
    private String separator = "\t";
    private String headerSequence;
    private String fileURL = this.BASE_URL;
    private String filename = HybsSystem.sys("FILE_FILENAME");
    private String sheetName = "Sheet1";
    private String refFileURL = this.BASE_URL;
    private String refFilename;
    private String refSheetName;
    private String fontName = HybsSystem.sys("TABLE_WRITER_DEFAULT_FONT_NAME");
    private String fontPoint = HybsSystem.sys("TABLE_WRITER_DEFAULT_FONT_POINTS");
    private String encode = HybsSystem.sys("FILE_ENCODE");
    private String writerClass;
    private boolean fileAppend;
    private boolean direct;
    private boolean zip;
    private String zipFilename;
    private String disposition = "attachment";
    private transient DBTableModel table;
    private String tableId = "h_tblmdl";
    private String directory;
    private transient List<HybsEntry> param;
    private boolean useNumber = true;
    private String columns;
    private String omitNames;
    private boolean useRenderer = HybsSystem.sysBool("USE_TABLE_WRITER_RENDERER");
    private boolean selectedAll = true;
    private boolean beforeDelete;
    private int skipRowCount;
    private boolean useCellStyle;
    private boolean useAutoCellSize;
    private boolean useActiveWorkbook;
    private String pageBreakColumn;
    private String fileBreakColumn;
    private String hyperLinkColumn;
    private String addTitleSheet;

    @Override
    public int doStartTag() {
        if (!this.useTag()) {
            return 0;
        }
        this.directory = HybsSystem.url2dir(this.fileURL);
        if (this.zip && this.zipFilename == null) {
            this.zipFilename = this.filename + ".zip";
        }
        if (this.beforeDelete && !this.fileAppend) {
            File file = null;
            file = this.zip ? new File(this.directory, this.zipFilename) : new File(this.directory, this.filename);
            if (file.exists() && !file.delete()) {
                String string = "\u4e8b\u524d\u306b\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3059\u308b\u306e\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002filename=[" + file + "]";
                System.err.println(string);
            }
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doEndTag() {
        this.debugPrint();
        if (!this.useTag()) {
            return 6;
        }
        this.table = (DBTableModel)this.getObject(this.tableId);
        if (!this.selectedAll) {
            this.table = this.getSelRowsTable(this.table);
        }
        if (this.table != null && this.table.getRowCount() > 0) {
            ByteArrayOutputStream byteArrayOutputStream;
            PrintWriter printWriter;
            block21: {
                File file = new File(this.directory);
                if (!file.exists() && !file.mkdirs()) {
                    String string = "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + this.directory + "]";
                    throw new HybsSystemException(string);
                }
                if (this.writerClass == null) {
                    this.writerClass = StringUtil.nval((String)this.sys("TABLE_WRITER_DEFAULT_CLASS"), (String)"Default");
                }
                printWriter = null;
                byteArrayOutputStream = null;
                try {
                    boolean bl;
                    if (this.direct) {
                        ZipArchiveOutputStream zipArchiveOutputStream;
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        printWriter = new PrintWriter(byteArrayOutputStream);
                        this.create(printWriter);
                        printWriter.flush();
                        ServletResponse servletResponse = this.pageContext.getResponse();
                        if (this.zip) {
                            ((HttpServletResponse)servletResponse).addHeader("Content-Encoding", "gzip");
                            zipArchiveOutputStream = new ZipArchiveOutputStream((OutputStream)byteArrayOutputStream);
                            zipArchiveOutputStream.finish();
                            servletResponse.setContentLength(byteArrayOutputStream.size());
                            zipArchiveOutputStream.closeArchiveEntry();
                            zipArchiveOutputStream.finish();
                            Closer.ioClose((Closeable)zipArchiveOutputStream);
                        } else {
                            servletResponse.setContentType("application/vnd.ms-excel; charset=" + this.encode);
                            ((HttpServletResponse)servletResponse).setHeader("Content-Disposition", this.disposition + "; filename=\"" + this.filename + "\"");
                        }
                        zipArchiveOutputStream = this.pageContext.getOut();
                        zipArchiveOutputStream.clear();
                        zipArchiveOutputStream.print((Object)byteArrayOutputStream);
                        zipArchiveOutputStream.flush();
                        break block21;
                    }
                    boolean bl2 = bl = this.writerClass.toUpperCase(Locale.JAPAN).startsWith("EXCEL") || this.writerClass.toUpperCase(Locale.JAPAN).startsWith("CALC");
                    if (this.zip) {
                        BufferedInputStream bufferedInputStream = null;
                        if (bl) {
                            this.create(null);
                        } else {
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            printWriter = this.getPrintWriter(byteArrayOutputStream);
                            this.create(printWriter);
                            printWriter.flush();
                        }
                        ZipArchiveOutputStream zipArchiveOutputStream = null;
                        try {
                            zipArchiveOutputStream = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(this.directory, this.zipFilename))));
                            zipArchiveOutputStream.setEncoding("Windows-31J");
                            zipArchiveOutputStream.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(this.filename));
                            if (bl) {
                                File file2 = new File(this.directory, this.filename);
                                bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                                IOUtils.copy((InputStream)bufferedInputStream, (OutputStream)zipArchiveOutputStream);
                                Closer.ioClose((Closeable)bufferedInputStream);
                                if (file2.exists() && !file2.delete()) {
                                    String string = "Excel\u3092Zip\u5316\u3059\u308b\u6642\u306eTemp\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3059\u308b\u306e\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002filename=[" + file2 + "]";
                                    System.err.println(string);
                                }
                            } else {
                                byteArrayOutputStream.writeTo((OutputStream)zipArchiveOutputStream);
                            }
                            zipArchiveOutputStream.closeArchiveEntry();
                            zipArchiveOutputStream.finish();
                        }
                        catch (Throwable throwable) {
                            Closer.ioClose(zipArchiveOutputStream);
                            Closer.ioClose(bufferedInputStream);
                            throw throwable;
                        }
                        Closer.ioClose((Closeable)zipArchiveOutputStream);
                        Closer.ioClose(bufferedInputStream);
                        break block21;
                    }
                    if (bl) {
                        this.create(null);
                        break block21;
                    }
                    printWriter = this.getPrintWriter();
                    this.create(printWriter);
                    printWriter.flush();
                }
                catch (IOException iOException) {
                    try {
                        String string = "\u30c6\u30fc\u30d6\u30eb\u51fa\u529b\u6642\u306b\u3001IO\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + this.toString();
                        throw new HybsSystemException(string, iOException);
                    }
                    catch (Throwable throwable) {
                        Closer.ioClose(printWriter);
                        Closer.ioClose((Closeable)byteArrayOutputStream);
                        throw throwable;
                    }
                }
            }
            Closer.ioClose((Closeable)printWriter);
            Closer.ioClose((Closeable)byteArrayOutputStream);
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.separator = "\t";
        this.headerSequence = null;
        this.fileURL = this.BASE_URL;
        this.filename = HybsSystem.sys("FILE_FILENAME");
        this.sheetName = "Sheet1";
        this.beforeDelete = false;
        this.refFileURL = this.BASE_URL;
        this.refFilename = null;
        this.refSheetName = null;
        this.fontName = HybsSystem.sys("TABLE_WRITER_DEFAULT_FONT_NAME");
        this.fontPoint = HybsSystem.sys("TABLE_WRITER_DEFAULT_FONT_POINTS");
        this.encode = HybsSystem.sys("FILE_ENCODE");
        this.writerClass = null;
        this.fileAppend = false;
        this.direct = false;
        this.zip = false;
        this.zipFilename = null;
        this.table = null;
        this.tableId = "h_tblmdl";
        this.disposition = "attachment";
        this.param = null;
        this.useNumber = true;
        this.skipRowCount = 0;
        this.directory = null;
        this.columns = null;
        this.omitNames = null;
        this.useRenderer = HybsSystem.sysBool("USE_TABLE_WRITER_RENDERER");
        this.selectedAll = true;
        this.useCellStyle = false;
        this.useAutoCellSize = false;
        this.useActiveWorkbook = false;
        this.pageBreakColumn = null;
        this.fileBreakColumn = null;
        this.hyperLinkColumn = null;
        this.addTitleSheet = null;
    }

    private void create(PrintWriter printWriter) {
        if ("ExcelRenderer".equalsIgnoreCase(this.writerClass)) {
            this.writerClass = "Excel";
            this.useRenderer = true;
        } else if ("Renderer".equalsIgnoreCase(this.writerClass)) {
            this.writerClass = "Default";
            this.useRenderer = true;
        }
        String string = HybsSystem.sys("TableWriter_" + this.writerClass);
        if (string == null) {
            String string2 = "TableWriter \u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002class=TableWriter_" + this.writerClass;
            throw new RuntimeException(string2);
        }
        TableWriter tableWriter = (TableWriter)HybsSystem.newInstance(string);
        tableWriter.setDBTableModel(this.table, this.getLanguage());
        tableWriter.setSeparator(this.separator);
        tableWriter.setHeaderSequence(this.headerSequence);
        tableWriter.setEncode(this.encode);
        tableWriter.setAppend(this.fileAppend);
        if (this.param != null) {
            tableWriter.setParam(this.param);
        }
        tableWriter.setUseNumber(this.useNumber);
        tableWriter.setColumns(this.columns);
        tableWriter.setOmitNames(this.omitNames);
        tableWriter.setUseRenderer(this.useRenderer);
        tableWriter.setDebug(this.isDebug());
        if (tableWriter.isExcel()) {
            tableWriter.setSheetName(this.sheetName);
            tableWriter.setFilename(this.directory, this.filename);
            if (this.refFileURL != null && this.refFilename != null) {
                tableWriter.setRefFilename(StringUtil.urlAppend((String)HybsSystem.url2dir(this.refFileURL), (String)this.refFilename, (String[])new String[0]));
            }
            if (this.refSheetName != null && this.refSheetName.length() > 0) {
                tableWriter.setRefSheetName(this.refSheetName);
            }
            tableWriter.setFontName(this.fontName);
            if (this.fontPoint != null && this.fontPoint.length() > 0) {
                tableWriter.setFontPoint(Short.parseShort(this.fontPoint));
            }
            tableWriter.setSkipRowCount(this.skipRowCount);
            tableWriter.setUseCellStyle(this.useCellStyle);
            tableWriter.setUseAutoCellSize(this.useAutoCellSize);
            tableWriter.setUseActiveWorkbook(this.useActiveWorkbook);
            tableWriter.setPageBreakColumn(this.pageBreakColumn);
            tableWriter.setFileBreakColumn(this.fileBreakColumn);
            tableWriter.setHyperLinkColumn(this.hyperLinkColumn);
            tableWriter.setAddTitleSheet(this.addTitleSheet);
            tableWriter.writeDBTable();
        } else {
            tableWriter.writeDBTable(printWriter);
        }
    }

    private PrintWriter getPrintWriter() {
        if (this.filename == null) {
            throw new HybsSystemException("\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u30bb\u30c3\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        PrintWriter printWriter = FileUtil.getPrintWriter((File)new File(this.directory, this.filename), (String)this.encode, (boolean)this.fileAppend);
        return printWriter;
    }

    private PrintWriter getPrintWriter(OutputStream outputStream) {
        PrintWriter printWriter = FileUtil.getPrintWriter((OutputStream)outputStream, (String)this.encode);
        return printWriter;
    }

    private DBTableModel getSelRowsTable(DBTableModel dBTableModel) {
        if (dBTableModel == null) {
            return null;
        }
        DBTableModel dBTableModel2 = dBTableModel.newModel();
        int[] nArray = this.getParameterRows();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            dBTableModel2.addValues((String[])dBTableModel.getValues(nArray[i]), i);
        }
        return dBTableModel2;
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setSeparator(String string) {
        this.separator = StringUtil.nval((String)this.getRequestParameter(string), (String)this.separator);
    }

    public void setHeaderSequence(String string) {
        String[] stringArray = this.getRequestParameterValues(string);
        if (stringArray != null) {
            StringBuilder stringBuilder = new StringBuilder(200);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                stringBuilder.append(stringArray[i]);
            }
            this.headerSequence = stringBuilder.toString();
        }
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            char c = string2.charAt(string2.length() - 1);
            if (c != '/' && c != '\\') {
                string2 = string2 + "/";
            }
            this.fileURL = StringUtil.urlAppend((String)this.fileURL, (String)string2, (String[])new String[0]);
        }
    }

    public void setFilename(String string) {
        this.filename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.filename);
    }

    public void setSheetName(String string) {
        this.sheetName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.sheetName);
    }

    public void setEncode(String string) {
        this.encode = StringUtil.nval((String)this.getRequestParameter(string), (String)this.encode);
    }

    public void setWriterClass(String string) {
        this.writerClass = StringUtil.nval((String)this.getRequestParameter(string), (String)this.writerClass);
    }

    public void setFileAppend(String string) {
        this.fileAppend = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.fileAppend);
    }

    @Deprecated
    public void setDirect(String string) {
        this.direct = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.direct);
    }

    public void setZip(String string) {
        this.zip = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.zip);
    }

    public void setZipFilename(String string) {
        this.zipFilename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.zipFilename);
    }

    public void setDisposition(String string) {
        this.disposition = StringUtil.nval((String)this.getRequestParameter(string), (String)this.disposition);
        if (!"inline".equals(this.disposition) && !"attachment".equals(this.disposition)) {
            String string2 = "disposition \u306b\u306f\u3001inline \u304b attachment \u4ee5\u5916\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002disposition=[" + this.disposition + "]";
            throw new HybsSystemException(string2);
        }
    }

    public void setRefFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            char c = string2.charAt(string2.length() - 1);
            if (c != '/' && c != '\\') {
                string2 = string2 + "/";
            }
            this.refFileURL = StringUtil.urlAppend((String)this.refFileURL, (String)string2, (String[])new String[0]);
        }
    }

    public void setRefFilename(String string) {
        this.refFilename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.refFilename);
    }

    public void setRefSheetName(String string) {
        this.refSheetName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.refSheetName);
    }

    public void setFontName(String string) {
        this.fontName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.fontName);
    }

    public void setFontPoint(String string) {
        this.fontPoint = StringUtil.nval((String)this.getRequestParameter(string), (String)this.fontPoint);
    }

    public void setUseNumber(String string) {
        this.useNumber = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useNumber);
    }

    public void setColumns(String string) {
        this.columns = StringUtil.nval((String)this.getRequestParameter(string), (String)this.columns);
    }

    public void setOmitNames(String string) {
        this.omitNames = StringUtil.nval((String)this.getRequestParameter(string), (String)this.omitNames);
    }

    public void setUseRenderer(String string) {
        this.useRenderer = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useRenderer);
    }

    public void setSkipRowCount(String string) {
        this.skipRowCount = StringUtil.nval((String)this.getRequestParameter(string), (int)this.skipRowCount);
    }

    public void setUseCellStyle(String string) {
        this.useCellStyle = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useCellStyle);
    }

    public void setUseAutoCellSize(String string) {
        this.useAutoCellSize = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useAutoCellSize);
    }

    public void setUseActiveWorkbook(String string) {
        this.useActiveWorkbook = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useActiveWorkbook);
    }

    public void setPageBreakColumn(String string) {
        this.pageBreakColumn = StringUtil.nval((String)this.getRequestParameter(string), (String)this.pageBreakColumn);
    }

    public void setFileBreakColumn(String string) {
        this.fileBreakColumn = StringUtil.nval((String)this.getRequestParameter(string), (String)this.fileBreakColumn);
    }

    public void setHyperLinkColumn(String string) {
        this.hyperLinkColumn = StringUtil.nval((String)this.getRequestParameter(string), (String)this.hyperLinkColumn);
    }

    public void setAddTitleSheet(String string) {
        this.addTitleSheet = StringUtil.nval((String)this.getRequestParameter(string), (String)this.addTitleSheet);
    }

    public void setSelectedAll(String string) {
        this.selectedAll = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.selectedAll);
    }

    public void setBeforeDelete(String string) {
        this.beforeDelete = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.beforeDelete);
    }

    protected void addParam(HybsEntry hybsEntry) {
        if (this.param == null) {
            this.param = new ArrayList<HybsEntry>();
        }
        this.param.add(hybsEntry);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("BASE_URL", (Object)this.BASE_URL).println("separator", (Object)this.separator).println("headerSequence", (Object)this.headerSequence).println("fileURL", (Object)this.fileURL).println("filename", (Object)this.filename).println("refFileURL", (Object)this.refFileURL).println("refFilename", (Object)this.refFilename).println("encode", (Object)this.encode).println("writerClass", (Object)this.writerClass).println("fileAppend", (Object)this.fileAppend).println("direct", (Object)this.direct).println("zip", (Object)this.zip).println("zipFilename", (Object)this.zipFilename).println("disposition", (Object)this.disposition).println("tableId", (Object)this.tableId).println("sheetName", (Object)this.sheetName).println("refSheetName", (Object)this.refSheetName).println("useNumber", (Object)this.useNumber).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

