<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2081"
	title	= "オブジェクト明細"
	date	= "2012/05/08"
	author	= "Kazuhiko.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,OBJ_NAME"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- テキスト索引の同期化 は、とりあえず毎回実行しておきます。(良い方法があれば、教えて) -->
<og:query command="NEW" queryType="JDBCUpdate" >
	{ call CTX_DDL.SYNC_INDEX( 'GF83_TXT_IDX' ) }
</og:query>

<og:query command="{@command}" maxRowCount="{@maxRowCount}" quotCheck="false" >
	select SYSTEM_ID,TBLSYU,OBJ_TYPE,OBJ_NAME,NOLINE,FGNG,UNIQ,FGJ
			<og:text caseNN  ="{@TEXT_DATA}">,CTX_DOC.SNIPPET('GF83_TXT_IDX',UNIQ,'{@TEXT_DATA}') AS SRC_TEXT</og:text>
			<og:text caseNull="{@TEXT_DATA}">,SRC_TEXT</og:text>
	from GF83
	<og:where>
		<og:and value = "SYSTEM_ID	=    '{@SYSTEM_ID}'"	/>
		<og:and value = "TBLSYU		=    '{@TBLSYU}'"		/>
		<og:and value = "OBJ_NAME	like '{@OBJ_NAME}'"		/>
		<og:and value = "OBJ_TYPE	=    '{@OBJ_TYPE}'"		/>
		<og:and value = "FGNG		=    '{@FGNG}'"			/>
		<og:and value = "upper(SRC_TEXT) like upper('{@SRC_TEXT}')"	/>
		<og:and value = "CONTAINS ( SRC_TEXT, '{@TEXT_DATA}' ,1) &gt; 0" />
	</og:where>
	order by SYSTEM_ID,TBLSYU,OBJ_TYPE,OBJ_NAME,NOLINE
</og:query>

<og:columnEditor column="SRC_TEXT" renderer="PRE" />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit  action="DELETE"  accesskey="Z" columnWritable="null" />
	<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "UNIQ,FGJ"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}"
/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
