<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9220"
	title	= "特殊(レイアウト指定)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select CLM,NAME_JA,LABEL_NAME,KBSAKU,SYSTEM_ID,LANG,FGJ,
				(CASE KBSAKU WHEN '0' THEN 0 ELSE 1 END) AS ONMARK
		from GF41
	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "FGJ         in  ('0','1')"         />
		<og:and value = "SYSTEM_ID  =  '{@SYSTEM_ID}'"  />
		<og:and value = "LANG        = '{@LANG}'"           />
		<og:and value = "CLM         like '{@CLM}'"        />
		<og:and value = "NAME_JA     like '{@NAME_JA}'"    />
		<og:and value = "LABEL_NAME  like '{@LABEL_NAME}'" />
		<og:and value = "KBSAKU      =    '{@KBSAKU}'"      />
	</og:where>
	<!-- ORDER BY句でAppearTagを使用すれば{@ORDER_BY}がNULLの場合、ORDER BY句は無視されます。 -->
	<!-- また、{@ORDER_BY}がNULLの場合に、defaultVal属性を指定すれば、その値でORDER BY表示されます。 -->
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,CLM,LANG" />
</og:query>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。 以下は、must属性を true にしています。 -->
<og:columnEditor column="SYSTEM_ID" must="true" />
<og:columnEditor column="LANG"      must="true" />
<og:columnEditor column="CLM"       must="true" />

<og:equals val1="{@IMAGE}" val2="true" >
	<og:columnEditor column="NAME_JA" label="IMAGE_VIEW" />
</og:equals>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="CLM" gamenId="GF9000" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,LANG,CLM,KBSAKU,IMAGE"
		vals="NEW,[SYSTEM_ID],[LANG],[CLM],[KBSAKU],{@IMAGE}" />
</og:viewLink>

<!-- EqualTagを使用すると、val1 と val2 の値を比較して、trueの場合のみ、BODY部を実行します。-->
<!-- nullCheck="true"で、val1 が NULL のとき trueになり、notEquals="true"で結果を反転します -->
<og:equals val1="{@IMAGE}" val2="true">
  <!-- ColumnEditorTagを使用すると、カラム属性を設定しなおすことが出来ます。-->
  <og:columnEditor column="NAME_JA" label="IMAGE_VIEW" />
  <!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
  <og:viewMarker command="{@command}">
    <!-- 子要素の ColumnMarkerTag のBODY部と表示（レンデラー）を置き換えます。 -->
    <!-- onMark="true" または ="1" のときのみ、置き換えを行います。onMark=[カラム名] が使用できます。 -->
		<og:columnMarker column="NAME_JA" onMark="[KBSAKU]" markList="0" >
			<img src="{@SYS.JSP}/GF9120/image/[CLM].gif" alt="[CLM]" />
		</og:columnMarker>
		<og:columnMarker column="NAME_JA" onMark="[KBSAKU]" markList="1" >
			<a href="{@SYS.JSP}/GF9120/image/[CLM].xv3" >
				<img src="{@SYS.JSP}/GF9120/image/[CLM].jpg" alt="[CLM]" />
			</a>
		</og:columnMarker>
		<og:columnMarker column="NAME_JA" onMark="[KBSAKU]" markList="2" >
			<img src="{@SYS.JSP}/GF9120/image/[CLM].jpg" alt="[CLM]" />
		</og:columnMarker>

	<og:columnMarker column="NAME_JA" onMark="[ONMARK]" >
		<img src="{@SYS.JSP}/customImage/[CLM].jpg" alt="[CLM]" />
	</og:columnMarker>
-->
  </og:viewMarker>
</og:equals>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  action="COPY"    noWritable="null" />
	<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,LANG,CLM"  />
	<og:submit  action="DELETE"  columnWritable="null" />
<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- rowspan="3"で、３段組みの、HTMLFormatTable を使用して表示画面を作成しています。-->
<og:view
	viewFormType = "HTMLFormatTable"
	command    = "{@command}"
	noDisplay  = "FGJ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
	selectedType = "radio"
	rowspan    = "3"
>
	<tr>
		<td>[SYSTEM_ID]</td>
		<td>[LANG]</td>
		<td>[KBSAKU]</td>
		<td rowspan="3">[NAME_JA]</td>
	</tr>
	<tr>
		<td colspan="3">[CLM]</td>
	</tr>
	<tr>
		<td colspan="3">[LABEL_NAME]</td>
	</tr>
</og:view>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
