/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.resource;

import static org.opengion.fukurou.util.HybsConst.CR ;				// 6.1.0.0 (2014/12/26)
import static org.opengion.fukurou.util.HybsConst.BUFFER_MIDDLE;	// 6.1.0.0 (2014/12/26) refactoring

/**
 * ユーザーアクセス画面オブジェクトの元となる ユーザーアクセス画面データを作成します。
 *
 * @og.rev 4.1.1.0 (2008/01/22) 新規作成
 * @og.group リソース管理
 *
 * @version  4.1.1.0
 * @author   Sen.Li
 * @since    JDK5.0,
 */
public final class FavoriteGUIData {

	private final String	guiKey 		;		// 画面ID
	private final int		seqno  		;		// 表示順
	private final String	name 		;		// 名称(漢字)
	private final String	classify 	;		// 分類

	/**
	 * 引数を元に、FavoriteGUIDataオブジェクトを構築します。
	 *
	 * @param	parmGuiKey  	お気に入り画面の画面ID
	 * @param	parmSeqno   	お気に入り画面の表示順
	 * @param	parmName    	お気に入り画面の名称(漢字)
	 * @param	parmClassify	お気に入り画面の分類
	 */
	FavoriteGUIData( final String parmGuiKey,final String parmSeqno,final String parmName,final String parmClassify ) {
		guiKey		= parmGuiKey;						// 画面ID
		seqno		= Integer.parseInt( parmSeqno );	// 表示順
		name		= parmName;							// 名称(漢字)
		classify	= parmClassify;						// 分類
	}

	/**
	 * ユーザーアクセス画面オブジェクトのキーを返します。
	 *
	 * @return ユーザーアクセス画面オブジェクトのキー
	 */
	public String getGuiKey() { return guiKey; }

	/**
	 * ユーザーアクセス画面オブジェクトの表示順を返します。
	 *
	 * @return ユーザーアクセス画面オブジェクトの表示順
	 */
	public int getSeqno() { return seqno; }

	/**
	 * ユーザーアクセス画面オブジェクトの名称(漢字)を返します。
	 *
	 * @return ユーザーアクセス画面オブジェクトの名称(漢字)
	 */
	public String getName() { return name; }

	/**
	 * ユーザーアクセス画面オブジェクトの分類を返します。
	 *
	 * @return ユーザーアクセス画面オブジェクトの分類
	 */
	public String getClassify() { return classify; }

	/**
	 * オブジェクトの識別子として，詳細なユーザーアクセス画面情報を返します。
	 *
	 * @return  詳細なユーザーアクセス画面情報
	 * @og.rtnNotNull
	 */
	@Override
	public String toString() {
		final StringBuilder rtn = new StringBuilder( BUFFER_MIDDLE )
			.append( "guiKey     :" ).append( guiKey      ).append( CR )
			.append( "seqno      :" ).append( seqno       ).append( CR )
			.append( "name       :" ).append( name        ).append( CR )
			.append( "classify   :" ).append( classify    ).append( CR );
		return rtn.toString();
	}
}
