/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.taglib;

import org.opengion.hayabusa.html.FormatterType;

/**
 * 検索結果に対してボディフォーマットを変更するタグです。
 *
 * viewタグで、viewFormType に、HTMLFormatTable や HTMLCustomTable を使用する場合、
 * ボディフォーマットを指定できます。
 * HTMLCustomTable では、ボディフォーマットを、複数指定することが可能です。
 *
 * 5.7.6.3 (2014/05/23) keyBreakClm 属性追加
 *
 * @og.formSample
 * ●形式：
 *      &lt;og:tbody
 *         rowspan       = &quot;表示データを作成する場合のフォーマットの行数(rowspan)をセットします(初期値:2)(必須)。&quot;
 *         noClass       = &quot;カラムのクラス名(VERCHAR2,NUMBER など)を使用するかどうか[true/false]を指定します(初期値:false)。&quot;
 *         usableKey     = &quot;フォーマットの使用可否を判断するキーとなるカラム名を指定します。&quot;
 *         usableList    = &quot;フォーマットの使用可否を判断する文字列リストを指定します(初期値:&quot;1&quot;)。&quot;
 *      &gt; ... Body ...
 *      &lt;/og:tbody&gt;
 * ●body：あり(EVAL_BODY_BUFFERED:BODYを評価し、{&#064;XXXX} を解析します)
 *
 * ●Tag定義：
 *   &lt;og:tbody
 *       rowspan          ○【TAG】表示データを作成する場合のフォーマットの行数(rowspan)をセットします(初期値:2)(必須)。
 *       noClass            【TAG】カラムのクラス名(VERCHAR2,NUMBER など)を使用するかどうか[true/false]を指定します(初期値:false)
 *       usableKey          【TAG】フォーマットの使用可否を判断するキーとなるカラム名を指定します
 *       usableList         【TAG】フォーマットの使用可否を判断する文字列リストを指定します(初期値:"1")
 *       keyBreakClm        【TAG】指定したカラムの値が、キーブレイクした場合、このタグを使用します(初期値:null)。
 *       useTrCut           【TAG】先頭trタグを削除するかどうか[true/false]を指定します(初期値:true)
 *       caseKey            【TAG】このタグ自体を利用するかどうかの条件キーを指定します(初期値:null)
 *       caseVal            【TAG】このタグ自体を利用するかどうかの条件値を指定します(初期値:null)
 *       caseNN             【TAG】指定の値が、null/ゼロ文字列 でない場合(Not Null=NN)は、このタグは使用されます(初期値:判定しない)
 *       caseNull           【TAG】指定の値が、null/ゼロ文字列 の場合は、このタグは使用されます(初期値:判定しない)
 *       caseIf             【TAG】指定の値が、true/TRUE文字列の場合は、このタグは使用されます(初期値:判定しない)
 *       debug              【TAG】デバッグ情報を出力するかどうか[true/false]を指定します(初期値:false)
 *   &gt;   ... Body ...
 *   &lt;/og:tbody&gt;
 *
 * ●使用例
 *      &lt;og:view
 *          viewFormType = &quot;HTMLCustomTable&quot;
 *          command      = &quot;{&#064;command}&quot;
 *          writable     = &quot;false&quot;
 *          startNo      = &quot;{&#064;startNo}&quot;
 *          pageSize     = &quot;{&#064;pageSize}&quot;
 *          rowspan      = &quot;1&quot;
 *          numberType   = &quot;delete&quot;
 *      &gt;
 *          &lt;og:thead rowspan=&quot;1&quot; &gt;
 *              &lt;tr&gt;&lt;td&gt;&amp;amp;nbsp;&lt;/td&gt;&lt;td&gt;[VALUENAME]&lt;/td&gt;&lt;td&gt;[DESCRIPTION]&lt;/td&gt;&lt;/tr&gt;
 *          &lt;/og:thead&gt;
 *
 *          &lt;og:tbody usableKey=&quot;SEQ&quot; usableList=&quot;1&quot; rowspan=&quot;1&quot;&gt;
 *              &lt;tr&gt;&lt;td colspan=&quot;2&quot;&gt;&amp;amp;lt;[TAGNAME2]&lt;/td&gt;&lt;td&gt;&lt;/td&gt;&lt;/tr&gt;
 *          &lt;/og:tbody&gt;
 *
 *          &lt;og:tbody usableKey=&quot;DATAKEY&quot; usableList=&quot;0&quot; rowspan=&quot;1&quot;&gt;
 *              &lt;tr&gt;&lt;td&gt;&amp;amp;nbsp;&amp;amp;nbsp;&lt;/td&gt;&lt;td&gt;[VALUENAME]&lt;/td&gt;
 *                  &lt;td&gt;= &quot;[DESCRIPTION]&quot;&lt;/td&gt;&lt;/tr&gt;
 *          &lt;/og:tbody&gt;
 *
 *          &lt;og:tbody usableKey=&quot;DATAKEY&quot; usableList=&quot;1&quot; rowspan=&quot;2&quot;&gt;
 *              &lt;tr&gt;&lt;td&gt;&amp;amp;gt;&lt;/td&gt;&lt;td&gt;... Body ...&lt;/td&gt;&lt;td&gt;&lt;/td&gt;&lt;td&gt;&lt;/td&gt;&lt;/tr&gt;
 *              &lt;tr&gt;&lt;td colspan=&quot;3&quot;&gt;&amp;amp;lt;/[TAGNAME2]&amp;amp;gt;&lt;/td&gt;&lt;td&gt;&lt;/td&gt;&lt;td&gt;&lt;/td&gt;&lt;/tr&gt;
 *          &lt;/og:tbody&gt;
 *
 *          &lt;og:tbody usableKey=&quot;DATAKEY&quot; usableList=&quot;2&quot; rowspan=&quot;1&quot;&gt;
 *              &lt;tr&gt;&lt;td&gt;/&amp;amp;gt;&lt;/td&gt;&lt;td&gt;&lt;/td&gt;&lt;td&gt;&lt;/td&gt;&lt;td&gt;&lt;/td&gt;&lt;/tr&gt;
 *          &lt;/og:tbody&gt;
 *      &lt;/og:view&gt;
 *
 * @og.rev 3.5.4.0 (2003/11/25) TFormatTag のサブクラスとして再定義。
 * @og.group 画面部品
 *
 * @version  4.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
// public class TbodyTag extends TFormatTag {
public class TbodyTag extends TFormatImpl {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0.0 (2005/08/31)" ;

	private static final long serialVersionUID = 400020050831L ;

	/**
	 * このフォーマットのタイプを返します。
	 *
	 * タイプは、"head/body/foot" の中から、指定します。
	 *
	 * @og.rev 3.5.4.0 (2003/11/25) 新規追加
	 *
	 * @return	このフォーマットのタイプを返します。
	 */
	@Override
	protected FormatterType getType() {
		return FormatterType.TYPE_BODY;
	}
}
