
/**
 * <pre>
 * このドキュメントは、プラグイン類を集めた『はやぶさplugin』の ＡＰＩ 仕様です。
 * 
 * plugin には、【calendar】、【column】、【daemon】、【develop】、【io】、【query】、【table】、【view】
 * があり、各カスタムタグの属性でキーワードを指定する事で、使用します。
 * 
 * plugin の導入メカニズムは特殊(※)で、クラス名が、インターフェース_キーワード.java
 * というクラスファイルを、plugIn というクラスパスから、起動時に読み込んで、
 * システム設定ファイル（GE12)にロードします。
 * 本体は、システム設定ファイルのキーと正式クラス名(パッケージ付きクラス名)から、
 * 実際のクラスを起動します。
 * 
 * よって、初期設定と同じキーワードでプラグインをオーバーロードする場合は、Tomcat等の
 * アプリケーションサーバーのオーバーロードメカニズムを利用して、読み込み優先順位を
 * あげる必要があります。
 * Tomcatでいうと、WEB-INF の lib と classes では、classes の方がクラスロードの
 * 優先順位が高いので、標準plugin を lib に、カスタムplugin を classes に配置する
 * ことで、プラグインをオーバーロードを実現してください。
 * 
 * ただし、起動後、システム設定ファイル（GE12) を書き換える事で、任意のクラスを
 * オーバーロードすることが可能ですので、先のクラスローダーでは解決できないケース
 * では、こちらの方式を使用してください。
 * 
 * ※ plugin の導入メカニズム
 * plugin の導入メカニズムでは、Eclipseの採用している 
 * <a href="http://www.osgi-ufj.org/">OSGi(Open Service Gataway Initiative)</a>
 * と、Tomcatの採用している
 * <a href="http://java.sun.com/j2se/1.5.0/ja/docs/ja/guide/jmx/index.html">
 * JMX(Java Management Extensions)</a>
 * が有名です。
 * 
 * 現バージョンでは、それぞれのプラグインは独立したプログラムではなく、あくまで
 * 内部再利用を行う為の機構の為、簡易的な方法で、実装しています。
 * 
 * </pre>
 */

package org.opengion.plugin;
