/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.develop;

import java.util.List;
import java.util.Map;

import org.opengion.hayabusa.develop.AbstractJspCreate;
import org.opengion.hayabusa.develop.JspConvertEntity;
import org.opengion.fukurou.xml.OGElement;
import org.opengion.fukurou.xml.OGAttributes;
import org.opengion.fukurou.util.HybsDateUtil;
import org.opengion.fukurou.util.StringUtil;			// 5.6.8.0 (2013/09/06)

/**
 * query.jspの&lt;og:comment&gt;タグを作成します。
 * comment タグは、既存の
 *
 * ●使用例
 *      &lt;og:comment
 *          system   = ENTITY.getNmSys() 
 *          pgid     = ENTITY.getPgid()  
 *          title    = ENTITY.getNmpg()  
 *          date     = HybsDateUtil.getDate( "yyyy/MM/dd" ) 
 *          author   = "Auto Create"     
 *          text     = ""                
 *          version  = "001"             
 *      /&gt;
 *
 * @og.rev 5.6.1.2 (2013/02/22) 文字列連結から、XML処理するように変更します。
 *
 * @author Administrator
 *
 */
public class JspCreate_COMMENT extends AbstractJspCreate {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "5.6.8.0 (2013/09/06)" ;

	private static final String DEF_DATE_FORMAT = "yyyy/MM/dd" ;		// 5.6.8.0 (2013/09/06)
	private static final String DEF_AUTHOR_NAME = "Auto Create" ;		// 5.6.8.0 (2013/09/06)

	private List<JspConvertEntity> COMMENT_ROWS ;
	private boolean IS_NULL ;

	/**
	 * 初期化メソッド
	 *
	 * 内部で使用する JspConvertEntity の リスト のマップを受け取り、初期化を行います。
	 * @og.rev 5.2.1.0 (2010/10/01) 名前空間を、og 決め打ちから、名前空間指定無しに変更します。
	 * @og.rev 5.6.1.2 (2013/02/22) 処理対象のファイル名を指定するように変更します。
	 *
	 * @param	master	JspConvertEntityのリストのマップ
	 */
	@Override
	protected void init( final Map<String,List<JspConvertEntity>> master ) {
		COMMENT_ROWS = master.get("COMMENT");
		IS_NULL = !isNotEmpty( COMMENT_ROWS );
		KEY  = ":comment";		// 5.2.1.0 (2010/10/01) 名前空間指定無し
		NAME = "query,result,update,entry";
	}

	/**
	 * JSPに出力するタグの内容を作成します。
	 * 引数より作成前のタグの属性内容を確認するする事が出来ます。
	 *
	 * @og.rev 5.2.1.0 (2010/10/01) メソッドの引数を、OGAttributes から OGElement に変更します。
	 * @og.rev 5.2.1.0 (2010/10/01) 名前空間を、og 決め打ちから、引数を使用するように変更します。
	 * @og.rev 5.6.1.2 (2013/02/22) XML処理するように変更します。
	 * @og.rev 5.6.8.0 (2013/09/06) 日付はフォーマット変換します。author と text は更新しません。
	 *
	 * @param ele OGElementエレメントオブジェクト
	 * @param	nameSpace	このドキュメントのnameSpace( og とか mis とか )
	 *
	 * @return	変換された文字列
	 * @og.rtnNotNull
	 * @throws Throwable 変換時のエラー
	 */
	@Override
	protected String execute( final OGElement ele , final String nameSpace )  throws Throwable {
		if( IS_NULL ) { return ""; }

		// この OGElement の階層の深さを探ります。
		// ele.getText( para ) とすることでXML全体を階層表示できる。
	//	int para = ele.getParentCount();

		final JspConvertEntity ENTITY = COMMENT_ROWS.get(0);

		final OGAttributes attri = ele.getOGAttributes();

		// 5.6.8.0 (2013/09/06) 日付はフォーマット変換します。author は、あれば元の値を使います。
		final String dtFmt  = StringUtil.nval( attri.getVal( "date"   ) , DEF_DATE_FORMAT );
		final String author = StringUtil.nval( attri.getVal( "author" ) , DEF_AUTHOR_NAME );

		attri.setUseCR( true );
		attri.setVal( "system"	, ENTITY.getNmSys()	);
		attri.setVal( "pgid"	, ENTITY.getPgid()	);
		attri.setVal( "title"	, ENTITY.getNmpg()	);
		attri.setVal( "date"	, HybsDateUtil.getDate( dtFmt ) );				// 5.6.8.0 (2013/09/06)
		attri.setVal( "author"	, author	);									// 5.6.8.0 (2013/09/06)
		attri.setVal( "version"	, "001"				);

		return ele.getText( 0 );
	}
}
