/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.util.HybsDateUtil;
import org.opengion.fukurou.util.LogWriter;

public final class LogSender {
    public static final int FATAL = 4;
    public static final int ERROR = 3;
    public static final int WARNING = 2;
    public static final int INFORMATION = 1;
    public static final int DEBUG = 0;
    private static final int LOG_LEVEL = 3;
    private final String userId;
    private final int logLevel;
    private String guiId;
    private String msgId;
    private StringBuilder buf;

    public LogSender() {
        this(null, 3);
    }

    public LogSender(String string) {
        this(string, 3);
    }

    public LogSender(String string, int n) {
        this.userId = string;
        this.logLevel = n;
        this.buf = new StringBuilder(200);
        if (this.logLevel < 0 || this.logLevel > 4) {
            String string2 = "\u30ed\u30b0\u30ec\u30d9\u30eb\u306e\u6307\u5b9a\u30ec\u30d9\u30eb\u304c\u3001\u9593\u9055\u3063\u3066\u3044\u307e\u3059\u3002\u6307\u5b9a\u30ec\u30d9\u30eb=[" + n + "]" + "  \u6307\u5b9a\u53ef\u80fd\u30ec\u30d9\u30eb=" + 0 + " \uff5e " + 4;
            throw new RuntimeException(string2);
        }
    }

    public void setGuiId(String string) {
        this.guiId = string;
    }

    public void setMsgId(String string) {
        this.msgId = string;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void debug(String string) {
        if (0 < this.logLevel) {
            return;
        }
        this.log("DEBUG", string);
    }

    public void info(String string) {
        if (1 < this.logLevel) {
            return;
        }
        this.log("INFO", string);
    }

    public void warn(String string) {
        if (2 < this.logLevel) {
            return;
        }
        this.log("WARNING", string);
    }

    public void error(String string) {
        if (3 < this.logLevel) {
            return;
        }
        this.log("ERROR", string);
    }

    public void fatal(String string) {
        if (4 < this.logLevel) {
            return;
        }
        this.log("FATAL", string);
    }

    private void log(String string, String string2) {
        this.buf.append('[');
        this.buf.append(string);
        this.buf.append(" : Time=").append(HybsDateUtil.getDate("yyyy/MM/dd HH:mm:ss.SSS"));
        this.buf.append(" , User=").append(this.userId);
        this.buf.append(" , Gui=").append(this.guiId);
        this.buf.append(" , Msg=").append(this.msgId);
        this.buf.append(']');
        this.buf.append(HybsConst.CR);
        this.buf.append(string2);
    }

    public void flush() {
        LogWriter.log(this.buf.toString());
    }

    public void close() {
        LogWriter.close();
    }
}

