/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.Options;
import org.opengion.fukurou.util.StringUtil;

public final class XHTMLTag {
    public static final String CR = System.getProperty("line.separator");
    public static final int BUFFER_SMALL = 50;
    public static final int BUFFER_MIDDLE = 200;
    public static final int BUFFER_LARGE = 500;
    private static final HybsCryptography HYBS_CRYPTOGRAPHY = new HybsCryptography();
    private static final String[] BUTTON_KEY = new String[]{"type", "name", "value", "onClick", "id", "class", "lang", "dir", "title", "style", "xml:lang", "disabled", "tabindex", "accesskey", "onBlur", "onFocus", "ondblClick", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver", "autofocus"};
    private static final String[] INPUT_KEY = new String[]{"type", "size", "maxlength", "checked", "src", "alt", "accept", "usemap", "ismap", "id", "class", "lang", "dir", "title", "style", "xml:lang", "readonly", "disabled", "tabindex", "accesskey", "onClick", "onChange", "onBlur", "onFocus", "ondblClick", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver", "onSelect", "onKeydown", "onKeypress", "onKeyup", "autocomplete", "autofocus", "pattern", "placeholder", "list", "min", "max", "step", "required"};
    private static final String[] TEXTAREA_KEY = new String[]{"name", "rows", "cols", "id", "class", "lang", "dir", "title", "style", "xml:lang", "readonly", "disabled", "tabindex", "accesskey", "onClick", "onBlur", "onFocus", "ondblClick", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver", "onSelect", "onKeydown", "onKeypress", "onKeyup", "autofocus", "placeholder"};
    private static final String[] LINK_KEY = new String[]{"type", "name", "hreflang", "rel", "rev", "charset", "target", "shape", "coords", "onClick", "id", "class", "lang", "dir", "title", "style", "xml:lang", "tabindex", "accesskey", "onBlur", "onFocus", "ondblClick", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver"};
    private static final String[] SELECT_KEY = new String[]{"size", "multiple", "id", "class", "lang", "dir", "title", "style", "xml:lang", "disabled", "tabindex", "onClick", "onChange", "onBlur", "onFocus", "ondblClick", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver", "onSelect", "onKeydown", "onKeypress", "onKeyup", "autofocus"};
    private static final String[] OPTION_KEY = new String[]{"value", "label", "selected", "id", "class", "lang", "dir", "title", "style", "xml:lang", "disabled"};
    private static final String[] FRAME_KEY = new String[]{"name", "longdesc", "marginwidth", "marginheight", "noresize", "scrolling", "frameborder", "id", "class", "title", "style"};
    private static final String[] IMAGE_KEY = new String[]{"src", "alt", "longdesc", "width", "height", "usemap", "ismap", "name", "onClick", "align", "border", "hspace", "vspace", "id", "class", "title", "style", "lang", "dir", "xml:lang", "onBlur", "onFocus", "ondblClick", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver"};
    private static final String[] FORM_KEY = new String[]{"action", "method", "enctype", "accept-charset", "accept", "name", "target", "id", "class", "title", "style", "lang", "dir", "xml:lang"};
    private static final String[] SPAN_KEY = new String[]{"id", "class", "title", "style", "lang", "dir", "xml:lang"};
    private static final String[] PRE_KEY = new String[]{"id", "class", "title", "style", "lang", "dir", "xml:lang"};

    private XHTMLTag() {
    }

    public static String button(Attributes attributes) {
        String string = "|submit|reset|button|";
        String string2 = attributes.get("type");
        if (string.indexOf("|" + string2 + "|") < 0) {
            String string3 = "button \u30bf\u30a4\u30d7\u8a2d\u5b9a\u30a8\u30e9\u30fc [" + string2 + "]";
            throw new RuntimeException(string3);
        }
        String string4 = attributes.getAttribute(BUTTON_KEY);
        String string5 = attributes.get("body");
        if (string5 == null) {
            string5 = "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<button ");
        stringBuilder.append(string4);
        stringBuilder.append(">");
        stringBuilder.append(string5);
        stringBuilder.append("</button>");
        return stringBuilder.toString();
    }

    public static String input(Attributes attributes) {
        String string = attributes.get("name");
        String string2 = attributes.get("value");
        String string3 = attributes.get("optionAttributes");
        return XHTMLTag.input(attributes, string, string2, string3);
    }

    public static String input(Attributes attributes, String string, String string2, String string3) {
        String string4 = attributes.getAttribute(INPUT_KEY);
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<input ");
        if (string != null) {
            stringBuilder.append("name=\"").append(string).append("\" ");
        }
        if (string2 != null) {
            stringBuilder.append("value=\"").append(string2).append("\" ");
        }
        stringBuilder.append(string4);
        if (string3 != null) {
            stringBuilder.append(" ");
            stringBuilder.append(string3);
        }
        stringBuilder.append(" />");
        return stringBuilder.toString();
    }

    public static String inputAttri(Attributes attributes) {
        return attributes.getAttribute(INPUT_KEY);
    }

    public static String textareaAttri(Attributes attributes) {
        return attributes.getAttribute(TEXTAREA_KEY);
    }

    public static String selectAttri(Attributes attributes) {
        return attributes.getAttribute(SELECT_KEY);
    }

    public static String hidden(String string, String string2) {
        return XHTMLTag.hidden(string, string2, string);
    }

    public static String hidden(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("<input type=\"hidden\" ");
        stringBuilder.append("name=\"").append(string);
        stringBuilder.append("\" value=\"").append(string2);
        stringBuilder.append("\" id=\"").append(string3);
        stringBuilder.append("\" />");
        return stringBuilder.toString();
    }

    public static String textarea(Attributes attributes) {
        String string = attributes.getAttribute(TEXTAREA_KEY);
        String string2 = attributes.get("body");
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<textarea ");
        stringBuilder.append(string);
        stringBuilder.append(">");
        stringBuilder.append(string2);
        stringBuilder.append("</textarea>");
        return stringBuilder.toString();
    }

    public static String link(Attributes attributes) {
        return XHTMLTag.link(attributes, "");
    }

    public static String link(Attributes attributes, String string) {
        String string2 = XHTMLTag.addUrlEncode(attributes.get("href"), string);
        String string3 = attributes.getAttribute(LINK_KEY);
        String string4 = attributes.get("body");
        if (string4 == null) {
            string4 = attributes.get("href");
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<a href=\"");
        stringBuilder.append(string2);
        stringBuilder.append("\" ");
        stringBuilder.append(string3);
        stringBuilder.append(">");
        stringBuilder.append(string4);
        stringBuilder.append("</a>");
        return stringBuilder.toString();
    }

    public static String xlink(Attributes attributes, String string) {
        String string2 = XHTMLTag.addUrlEncode(attributes.get("href"), string, "&amp;");
        String string3 = attributes.getAttribute(LINK_KEY);
        String string4 = attributes.get("body");
        if (string4 == null) {
            string4 = attributes.get("href");
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<a xlink:href=\"");
        stringBuilder.append(string2);
        stringBuilder.append("\" ");
        stringBuilder.append(string3);
        stringBuilder.append(">");
        stringBuilder.append(string4);
        stringBuilder.append("</a>");
        return stringBuilder.toString();
    }

    public static String select(Attributes attributes, Options options) {
        String string = attributes.get("name");
        String string2 = attributes.get("optionAttributes");
        return XHTMLTag.select(attributes, options, string, string2);
    }

    public static String select(Attributes attributes, Options options, String string, String string2) {
        String string3 = attributes.getAttribute(SELECT_KEY);
        String string4 = options.getOption();
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<select ");
        if (string != null) {
            stringBuilder.append("name=\"").append(string).append("\" ");
        }
        stringBuilder.append(string3);
        if (string2 != null) {
            stringBuilder.append(" ");
            stringBuilder.append(string2);
        }
        stringBuilder.append(">");
        stringBuilder.append(string4);
        stringBuilder.append("</select>");
        return stringBuilder.toString();
    }

    public static String option(Attributes attributes) {
        String string = attributes.getAttribute(OPTION_KEY);
        String string2 = attributes.get("body");
        if (string2 == null) {
            string2 = "No Label";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<option ");
        stringBuilder.append(string);
        stringBuilder.append(" >");
        stringBuilder.append(string2);
        stringBuilder.append("</option>");
        return stringBuilder.toString();
    }

    public static String frame(Attributes attributes) {
        return XHTMLTag.frame(attributes, "");
    }

    public static String frame(Attributes attributes, String string) {
        String string2 = XHTMLTag.addUrlEncode(attributes.get("src"), string);
        String string3 = attributes.getAttribute(FRAME_KEY);
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<frame src=\"");
        stringBuilder.append(string2);
        stringBuilder.append("\" ");
        stringBuilder.append(string3);
        stringBuilder.append(" />");
        return stringBuilder.toString();
    }

    public static String urlEncode(String string, String string2) {
        return XHTMLTag.urlEncode(string, string2, "&");
    }

    public static String urlEncode(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            return "";
        }
        String[] stringArray = StringUtil.csv2Array(string);
        String[] stringArray2 = StringUtil.csv2Array(string2);
        return XHTMLTag.urlEncode(stringArray, stringArray2, string3);
    }

    public static String urlEncode(String[] stringArray, String[] stringArray2) {
        return XHTMLTag.urlEncode(stringArray, stringArray2, "&");
    }

    public static String urlEncode(String[] stringArray, String[] stringArray2, String string) {
        if (stringArray == null || stringArray.length == 0 || stringArray2 == null || stringArray2.length == 0) {
            return "";
        }
        if (stringArray.length != stringArray2.length) {
            String string2 = "urlEncode \u306e\u30ad\u30fc\u3068\u30d0\u30ea\u30e5\u30fc\u306e\u500b\u6570\u304c\u7570\u306a\u308a\u307e\u3059\u3002" + CR + "key.length=[" + stringArray.length + "]  val.length=[" + stringArray2.length + "]";
            throw new RuntimeException(string2);
        }
        String[] stringArray3 = new String[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length() == 0) {
                return "";
            }
            stringArray3[i] = stringArray2[i] == null || stringArray2[i].length() == 0 ? "" : (stringArray2[i].charAt(0) == '[' ? stringArray2[i] : StringUtil.urlEncode(stringArray2[i]));
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(stringArray[0]).append("=").append(stringArray3[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(stringArray[i]).append("=").append(stringArray3[i]);
        }
        return stringBuilder.toString();
    }

    public static String addUrlEncode(String string, String string2) {
        return XHTMLTag.addUrlEncode(string, string2, "&");
    }

    public static String addUrlEncode(String string, String string2, String string3) {
        String string4;
        String string5 = string4 = string == null ? "" : string;
        if (string2 == null || string2.length() == 0) {
            return string4;
        }
        String string6 = string4.indexOf(63) < 0 ? (string2.startsWith(string3) ? string4 + "?" + string2.substring(string3.length()) : string4 + "?" + string2) : (string2.startsWith(string3) ? string4 + string2 : string4 + string3 + string2);
        return string6;
    }

    public static String img(Attributes attributes) {
        String string = attributes.getAttribute(IMAGE_KEY);
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<img ");
        stringBuilder.append(string);
        stringBuilder.append(" />");
        return stringBuilder.toString();
    }

    public static String form(Attributes attributes) {
        String string = attributes.getAttribute(FORM_KEY);
        String string2 = attributes.get("body");
        if (string2 == null) {
            string2 = "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<form ");
        stringBuilder.append(string);
        stringBuilder.append(">");
        stringBuilder.append(CR);
        stringBuilder.append(string2);
        stringBuilder.append(CR);
        stringBuilder.append("</form>");
        return stringBuilder.toString();
    }

    public static String span(Attributes attributes) {
        String string = attributes.getAttribute(SPAN_KEY);
        String string2 = attributes.get("optionAttributes");
        String string3 = attributes.get("body");
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<span ");
        stringBuilder.append(string);
        if (string2 != null) {
            stringBuilder.append(" ");
            stringBuilder.append(string2);
        }
        stringBuilder.append(">");
        stringBuilder.append(string3);
        stringBuilder.append("</span>");
        return stringBuilder.toString();
    }

    public static String pre(Attributes attributes) {
        String string = attributes.getAttribute(PRE_KEY);
        String string2 = attributes.get("optionAttributes");
        String string3 = attributes.get("body");
        if (string3 == null) {
            string3 = "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<pre ");
        stringBuilder.append(string);
        if (string2 != null) {
            stringBuilder.append(" ");
            stringBuilder.append(string2);
        }
        stringBuilder.append(">");
        stringBuilder.append(string3);
        stringBuilder.append("</pre>");
        return stringBuilder.toString();
    }

    public static String addURLCheckKey(String string, String string2, String string3, long l) {
        return XHTMLTag.addURLCheckKey(string, string2, string3, l, null);
    }

    public static String addURLCheckKey(String string, String string2, String string3, long l, HybsCryptography hybsCryptography) {
        String string4 = string;
        string4 = string4 + ",time=" + l + ",userid=" + string3;
        string4 = hybsCryptography == null ? HYBS_CRYPTOGRAPHY.encrypt(string4) : hybsCryptography.encrypt(string4);
        return XHTMLTag.addUrlEncode(string, string2 + "=" + string4);
    }

    public static String embedURLCheckKey(String string, String string2, String string3, long l) {
        return XHTMLTag.embedURLCheckKey(string, string2, string3, l, null);
    }

    public static String embedURLCheckKey(String string, String string2, String string3, long l, HybsCryptography hybsCryptography) {
        int n;
        String string4 = string;
        int n2 = string4.indexOf("href=\"");
        if (n2 >= 0 && (n = string4.indexOf("\"", n2 + 6)) >= 0) {
            String string5 = string4.substring(n2 + 6, n);
            string5 = XHTMLTag.addURLCheckKey(string5, string2, string3, l, hybsCryptography);
            string4 = string4.substring(0, n2) + "href=\"" + string5 + string4.substring(n);
        }
        return string4;
    }
}

