/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.report.AbstractCSVPrintPointService;

public class CSVPrintPointService_RFW
extends AbstractCSVPrintPointService {
    private static final String CR = System.getProperty("line.separator");
    private final StringBuilder strCSV = new StringBuilder();
    private static final String csvEncode = HybsSystem.sys((String)"REPORT_CSV_TEXT_ENCODE");
    private static final String RFW_CSV_OUTPUTDIR = HybsSystem.sys((String)"RFW_CSV_OUTPUTDIR");

    public boolean execute() {
        System.out.print("CSV create ... ");
        BufferedWriter bufferedWriter = null;
        boolean bl = false;
        try {
            this.makeheader();
            this.makebody();
            bufferedWriter = this.getWriter(RFW_CSV_OUTPUTDIR + File.separator + this.listid + "_" + this.ykno + ".csv", false, csvEncode);
            bufferedWriter.write(this.strCSV.toString());
            bufferedWriter.flush();
            bufferedWriter.close();
            bl = true;
        }
        catch (Throwable throwable) {
            this.errMsg.append("CSV Print Request Execution Error. ").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append("SYSTEM_ID=[").append(this.systemId).append("] , ");
            this.errMsg.append("YKNO=[").append(this.ykno).append("] , ");
            this.errMsg.append(throwable.toString());
            this.errMsg.append(CR);
            throw new RuntimeException(this.errMsg.toString(), throwable);
        }
        return bl;
    }

    private void makeheader() {
        int n;
        this.strCSV.append("<rdstart>").append(CR);
        this.strCSV.append("RDSetForm=\"").append(this.modelname).append("\"").append(CR);
        if ("I".equals(this.fgrun)) {
            this.strCSV.append("RDSetOutputMode=PDF").append(CR);
            this.strCSV.append("RDSetOutputFileName=\"").append(this.outdir).append("\"").append(CR);
        } else if ("H".equals(this.fgrun)) {
            this.strCSV.append("RDSetOutputMode=XLS").append(CR);
            this.strCSV.append("RDSetOutputFileName=\"").append(this.outdir).append("\"").append(CR);
        } else {
            this.strCSV.append("RDSetOutputMode=SPOOL").append(CR);
            this.strCSV.append("RDSetOutputPrinter=\"").append(this.prtName).append("\"").append(CR);
        }
        this.strCSV.append("<rdend>").append(CR);
        for (n = 0; n < this.table.getColumnCount(); ++n) {
            if (n > 0) {
                this.strCSV.append(",");
            }
            this.strCSV.append(this.table.getColumnName(n));
        }
        if (this.tableH != null) {
            for (n = 0; n < this.tableH.getColumnCount(); ++n) {
                this.strCSV.append(",");
                this.strCSV.append("H_").append(this.tableH.getColumnName(n));
            }
        }
        if (this.tableF != null) {
            for (n = 0; n < this.tableF.getColumnCount(); ++n) {
                this.strCSV.append(",");
                this.strCSV.append("F_").append(this.tableF.getColumnName(n));
            }
        }
        this.strCSV.append(CR);
    }

    private void makebody() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            int n;
            int n2;
            for (n2 = 0; n2 < this.table.getColumnCount(); ++n2) {
                if (n2 > 0) {
                    this.strCSV.append(",");
                }
                this.strCSV.append("\"").append(StringUtil.replace((String)StringUtil.getReplaceEscape((String)((String)this.table.getValue(i, n2))), (String)"\"", (String)"\"\"")).append("\"");
            }
            if (this.tableH != null) {
                n2 = 0;
                for (n = 0; n < this.tableH.getColumnCount(); ++n) {
                    this.strCSV.append(",");
                    this.strCSV.append("\"").append(StringUtil.replace((String)StringUtil.getReplaceEscape((String)((String)this.tableH.getValue(n2, n))), (String)"\"", (String)"\"\"")).append("\"");
                }
            }
            if (this.tableF != null) {
                n2 = 0;
                for (n = 0; n < this.tableF.getColumnCount(); ++n) {
                    this.strCSV.append(",");
                    this.strCSV.append("\"").append(StringUtil.replace((String)StringUtil.getReplaceEscape((String)((String)this.table.getValue(n2, n))), (String)"\"", (String)"\"\"")).append("\"");
                }
            }
            this.strCSV.append(CR);
        }
    }

    private BufferedWriter getWriter(String string, boolean bl, String string2) {
        BufferedWriter bufferedWriter;
        File file = new File(string);
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, bl), string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.errMsg.append("[ERROR] Input File is written by Unsupported Encoding");
            throw new HybsSystemException((Throwable)unsupportedEncodingException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errMsg.append("[ERROR] File not Found");
            throw new HybsSystemException((Throwable)fileNotFoundException);
        }
        return bufferedWriter;
    }
}

