/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;

class DatabaseExecute {
    private static final String DBID = null;
    private Connection conn;
    private PreparedStatement pstmt;
    private String tempSql;
    private ApplicationInfo appInfo;

    DatabaseExecute() {
    }

    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.appInfo = applicationInfo;
    }

    public void setStatement(String string) {
        boolean bl = true;
        this.tempSql = string;
        try {
            if (this.conn == null) {
                this.conn = ConnectionFactory.connection((String)DBID, (ApplicationInfo)this.appInfo);
            }
            Closer.stmtClose((Statement)this.pstmt);
            this.pstmt = this.conn.prepareStatement(string);
            bl = false;
        }
        catch (SQLException sQLException) {
            String string2 = "Statement \u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsConst.CR + "SQL=[" + string + "]" + sQLException.getMessage() + ":" + sQLException.getSQLState();
            throw new HybsSystemException(string2, sQLException);
        }
        finally {
            if (bl) {
                this.errorFinally();
            }
        }
    }

    public void commit() {
        boolean bl = true;
        try {
            this.conn.commit();
            bl = false;
        }
        catch (SQLException sQLException) {
            Closer.rollback((Connection)this.conn);
            String string = "Connection \u3092\u30b3\u30df\u30c3\u30c8\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsConst.CR + sQLException.getMessage() + ":" + sQLException.getSQLState();
            throw new HybsSystemException(string, sQLException);
        }
        finally {
            Closer.stmtClose((Statement)this.pstmt);
            if (bl) {
                ConnectionFactory.remove((Connection)this.conn, (String)DBID);
            } else {
                ConnectionFactory.close((Connection)this.conn, (String)DBID);
            }
            this.conn = null;
        }
    }

    public void dbExecute(String ... stringArray) {
        boolean bl = true;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                this.pstmt.setString(i + 1, stringArray[i]);
            }
            this.pstmt.execute();
            bl = false;
        }
        catch (SQLException sQLException) {
            String string = "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u51e6\u7406\u3092\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsConst.CR + "ARGS=[" + StringUtil.array2csv((String[])stringArray) + "]" + HybsConst.CR + "SQL=[" + this.tempSql + "]" + sQLException.getMessage() + ":" + sQLException.getSQLState();
            throw new HybsSystemException(string, sQLException);
        }
        finally {
            if (bl) {
                this.errorFinally();
            }
        }
    }

    private void errorFinally() {
        Closer.stmtClose((Statement)this.pstmt);
        this.pstmt = null;
        Closer.rollback((Connection)this.conn);
        ConnectionFactory.remove((Connection)this.conn, (String)DBID);
        this.conn = null;
    }
}

