/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import java.io.File;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ZipArchive;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.report.CSVPrintRequest;
import org.opengion.hayabusa.report.ExcelInsert;
import org.opengion.hayabusa.report.ProgramRun;
import org.opengion.hayabusa.report.RFIDPrintRequest;
import org.opengion.hayabusa.report2.DocConverter_OOO;
import org.opengion.hayabusa.report2.ExecQueue;
import org.opengion.hayabusa.report2.OdsContentParser;

public class ExecProcess {
    private final ExecQueue queue;
    private final String type;
    private final long start = System.currentTimeMillis();
    private final boolean debug;

    public ExecProcess(ExecQueue execQueue, boolean bl) {
        this.queue = execQueue;
        this.type = execQueue.getOutputType();
        this.debug = bl;
    }

    public void process() {
        this.addDebugMsg("[INFO]EXEC-TIME:START=" + this.start);
        this.queue.setEnd(true);
        if ("1".equals(this.type) || "3".equals(this.type) || "P".equals(this.type) || "E".equals(this.type) || "Q".equals(this.type) || "S".equals(this.type)) {
            this.parse();
        }
        if ("2".equals(this.type) || "3".equals(this.type)) {
            this.output("PRINT");
        } else if ("P".equals(this.type)) {
            this.output("PDF");
        } else if ("E".equals(this.type)) {
            this.output("EXCEL");
        } else if ("Q".equals(this.type)) {
            this.output("PRINT", "PDF");
        } else if ("S".equals(this.type)) {
            this.output("ODS");
        }
        if ("5".equals(this.type) || "7".equals(this.type)) {
            this.input();
        }
        if ("6".equals(this.type) || "7".equals(this.type)) {
            this.pgexec();
        }
        if ("A".equals(this.type) || "B".equals(this.type) || "C".equals(this.type) || "D".equals(this.type)) {
            this.rfid();
        }
        if ("G".equals(this.type) || "H".equals(this.type) || "I".equals(this.type)) {
            this.csv();
        }
        this.addDebugMsg("[INFO]EXEC-TIME:END=" + System.currentTimeMillis());
    }

    private void parse() {
        File file = new File(this.queue.getTemplateName() + ".ods");
        String string = HybsSystem.url2dir(StringUtil.nval((String)HybsSystem.sys("REPORT_FILE_URL"), (String)(HybsSystem.sys("FILE_URL") + "REPORT/"))) + this.queue.getSystemId() + File.separator + this.queue.getListId() + File.separator + this.queue.getYkno();
        String string2 = string + File.separator;
        File file2 = new File(string + File.separator);
        File file3 = new File(string + ".ods");
        FileUtil.deleteFiles((File)file2);
        ZipArchive.unCompress((File)file2, (File)file);
        this.addDebugMsg("[INFO]EXEC-TIME:UNCOMP=" + (System.currentTimeMillis() - this.start));
        this.queue.setData();
        this.addDebugMsg("[INFO]EXEC-TIME:DATA=" + (System.currentTimeMillis() - this.start));
        OdsContentParser odsContentParser = new OdsContentParser(this.queue, string2);
        odsContentParser.exec();
        this.addDebugMsg("[INFO]EXEC-TIME:PARSE=" + (System.currentTimeMillis() - this.start));
        ZipArchive.compress((File)file2, (File)file3);
        this.addDebugMsg("[INFO]EXEC-TIME:COMP=" + (System.currentTimeMillis() - this.start));
        FileUtil.deleteFiles((File)file2);
        this.addDebugMsg("[INFO]EXEC-TIME:DELETE=" + (System.currentTimeMillis() - this.start));
    }

    private void output(String ... stringArray) {
        String string = HybsSystem.url2dir(StringUtil.nval((String)HybsSystem.sys("REPORT_FILE_URL"), (String)(HybsSystem.sys("FILE_URL") + "REPORT/"))) + this.queue.getSystemId() + File.separator + this.queue.getListId() + File.separator + this.queue.getYkno() + ".ods";
        if (!new File(string).exists()) {
            this.queue.addMsg("\u4e2d\u9593\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" + string + HybsConst.CR);
            throw new HybsSystemException();
        }
        DocConverter_OOO docConverter_OOO = new DocConverter_OOO(string);
        try {
            docConverter_OOO.open();
            this.addDebugMsg("[INFO]EXEC-TIME:OPEN=" + (System.currentTimeMillis() - this.start));
            for (int i = 0; i < stringArray.length; ++i) {
                if ("PRINT".equals(stringArray[i])) {
                    if (this.queue.getPrinterName() == null || this.queue.getPrinterName().isEmpty()) {
                        this.queue.addMsg("\u51fa\u529b\u5148\u30de\u30b9\u30bf\u304c\u6b63\u3057\u304f\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002" + HybsConst.CR);
                        throw new Exception();
                    }
                    docConverter_OOO.print(this.queue.getPrinterName());
                } else if ("PDF".equals(stringArray[i])) {
                    docConverter_OOO.pdf(this.queue.getOutputName(), this.queue.getPdfPasswd());
                } else if ("EXCEL".equals(stringArray[i])) {
                    docConverter_OOO.xls(this.queue.getOutputName());
                } else if ("ODS".equals(stringArray[i])) {
                    docConverter_OOO.ods(this.queue.getOutputName());
                }
                this.addDebugMsg("[INFO]EXEC-TIME:EXEC[" + stringArray[i] + "]=" + (System.currentTimeMillis() - this.start));
            }
            docConverter_OOO.close();
            this.addDebugMsg("[INFO]EXEC-TIME:RELEASE=" + (System.currentTimeMillis() - this.start));
        }
        catch (Throwable throwable) {
            docConverter_OOO.close(true);
            this.queue.addMsg("[INFO]EXEC-TIME:ERROR=" + (System.currentTimeMillis() - this.start) + HybsConst.CR);
            throw new HybsSystemException(throwable);
        }
        FileUtil.deleteFiles((File)new File(string));
        this.addDebugMsg("[INFO]EXEC-TIME:DELETE=" + (System.currentTimeMillis() - this.start));
    }

    private void input() {
        boolean bl = false;
        String string = HybsSystem.url2dir(StringUtil.nval((String)HybsSystem.sys("EXCEL_IN_FILE_URL"), (String)(HybsSystem.sys("FILE_URL") + "EXCELIN/")));
        String string2 = string + this.queue.getSystemId() + HybsConst.FS + this.queue.getListId();
        ExcelInsert excelInsert = new ExcelInsert(this.queue.getSystemId(), this.queue.getYkno(), this.queue.getListId(), string2, false);
        bl = excelInsert.execute();
        if (!bl) {
            this.queue.addMsg(excelInsert.getErrMsg());
            this.queue.addMsg("\u53d6\u308a\u8fbc\u307f\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            throw new HybsSystemException();
        }
        this.addDebugMsg("[INFO]EXEC-TIME:INPUT=" + (System.currentTimeMillis() - this.start));
    }

    private void pgexec() {
        boolean bl = false;
        ProgramRun programRun = new ProgramRun(this.queue.getSystemId(), this.queue.getYkno(), this.queue.getListId(), false);
        bl = programRun.execute();
        if (!bl) {
            this.queue.addMsg("\u53d6\u308a\u8fbc\u307f\u5f8c\u306ePG\u8d77\u52d5\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.queue.addMsg(programRun.getErrMsg());
            throw new HybsSystemException();
        }
        this.addDebugMsg("[INFO]EXEC-TIME:PGEXEC=" + (System.currentTimeMillis() - this.start));
    }

    private void rfid() {
        boolean bl = false;
        RFIDPrintRequest rFIDPrintRequest = new RFIDPrintRequest(this.queue.getSystemId(), this.queue.getYkno(), this.queue.getListId(), this.queue.getLang(), this.type, this.queue.getPrtId(), this.queue.getPrgDir(), this.queue.getPrgFile(), this.queue.getOutputName(), this.queue.getTemplateName(), false);
        bl = rFIDPrintRequest.initialDataSet();
        if (bl) {
            bl = rFIDPrintRequest.execute();
        }
        if (!bl) {
            this.queue.addMsg("RFID\u51fa\u529b\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.queue.addMsg(rFIDPrintRequest.getErrMsg());
            throw new HybsSystemException();
        }
        this.addDebugMsg("[INFO]EXEC-TIME:RFID=" + (System.currentTimeMillis() - this.start));
    }

    private void csv() {
        boolean bl = false;
        CSVPrintRequest cSVPrintRequest = new CSVPrintRequest(this.queue.getSystemId(), this.queue.getYkno(), this.queue.getListId(), this.queue.getLang(), this.type, this.queue.getPrtId(), this.queue.getPrgDir(), this.queue.getPrgFile(), this.queue.getOutputName(), this.queue.getTemplateName(), this.queue.getGrpId(), this.queue.getDmnGrp(), this.debug);
        bl = cSVPrintRequest.initialDataSet();
        if (bl) {
            bl = cSVPrintRequest.execute();
        }
        if (!bl) {
            this.queue.addMsg("CSV\u51fa\u529b\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            this.queue.addMsg(cSVPrintRequest.getErrMsg());
            throw new HybsSystemException();
        }
        this.queue.setExecRowCnt(cSVPrintRequest.getBodyCount());
        this.addDebugMsg("[INFO]EXEC-TIME:CSV=" + (System.currentTimeMillis() - this.start));
    }

    private void addDebugMsg(String string) {
        if (this.debug) {
            this.queue.addMsg(string + HybsConst.CR);
        }
    }
}

