/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.TagBuffer;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBEditConfig;
import org.opengion.hayabusa.db.DBLastSql;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class EditConfigTag
extends CommonTagSupport {
    private static final String VERSION = "6.3.9.0 (2015/11/06)";
    private static final long serialVersionUID = 639020151106L;
    private static final String VIEW_PREFIX = "EDIT_VIEW_";
    private static final String SUM_PREFIX = "EDIT_SUM_";
    private static final String GROUP_PREFIX = "EDIT_GROUP_";
    private static final String SUBTOTAL_PREFIX = "EDIT_SUBTOTAL_";
    private static final String TOTAL_PREFIX = "EDIT_TOTAL_";
    private static final String ORDERBY_PREFIX = "EDIT_ORDERBY_";
    private static final String DESC_PREFIX = "EDIT_DESC_";
    private static final String GRANDTOTAL_PREFIX = "EDIT_GRANDTOTAL_";
    private static final String COMMON_PREFIX = "EDIT_COMMON_";
    private static final String FIRSTTOTAL_PREFIX = "EDIT_FIRSTTOTAL_";
    private String command;
    private String gamenId;
    private String editName;
    private transient DBTableModel table;
    private transient DBEditConfig config;
    private boolean orderOnly;

    @Override
    public int doEndTag() {
        DBEditConfig[] dBEditConfigArray;
        this.debugPrint();
        StringBuilder stringBuilder = new StringBuilder(200);
        if ("GET".equals(this.command)) {
            DBLastSql dBLastSql = (DBLastSql)this.getSessionAttribute("h_lastSql");
            if (dBLastSql != null) {
                if (dBLastSql.isViewEditable() && dBLastSql.isGuiMatch(this.gamenId)) {
                    this.setScope(dBLastSql.getScope());
                    this.table = (DBTableModel)this.getObject(dBLastSql.getTableId());
                    if (this.table != null) {
                        this.config = this.getUser().getEditConfig(this.gamenId, this.editName);
                        String string = null;
                        if (this.config == null) {
                            this.config = new DBEditConfig();
                            string = dBLastSql.getViewClmNames();
                        } else {
                            string = this.config.getViewClms(dBLastSql.getOrgClmNames());
                        }
                        stringBuilder.append(this.makeEditTable(string));
                    }
                } else {
                    String string = "<b style=\"font-color:red;\">" + this.getResource().getLabel("GEE0003") + "</b>";
                    this.jspPrint(string);
                }
            }
        } else if ("SET".equals(this.command)) {
            if (this.editName == null || this.editName.isEmpty()) {
                throw new HybsSystemException("\u7de8\u96c6\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
            this.saveEditConfig();
        } else if ("DELETE".equals(this.command)) {
            if (this.editName == null || this.editName.isEmpty()) {
                throw new HybsSystemException("\u7de8\u96c6\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
            this.deleteEditConfig();
        } else if ("LIST".equals(this.command) && (dBEditConfigArray = this.getUser().getEditConfigs(this.gamenId)).length > 0) {
            stringBuilder.append(this.getEditSelect(dBEditConfigArray)).append(CR);
        }
        this.jspPrint(stringBuilder.toString());
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.command = "GET";
        this.gamenId = null;
        this.editName = null;
        this.table = null;
        this.config = null;
        this.orderOnly = false;
    }

    private String makeEditTable(String string) {
        Object object;
        boolean bl = this.getUseSum(string);
        String[] stringArray = StringUtil.csv2Array((String)string, (char)'|');
        StringBuilder stringBuilder = new StringBuilder(200).append("<input type=\"hidden\" name=\"viewClms\" id=\"viewClms\" value=\"").append(string).append("\"/><div style=\"float:left;\">").append(this.makeLabelRow(bl)).append("</div><div id=\"clmLayer\" style=\"float:left; width:670px; overflow-x:scroll;\">");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(this.makeSeparateRow(bl));
            }
            stringBuilder.append("<table class=\"clmGroup\" style=\"float:left;\"><tr>");
            object = StringUtil.csv2Array((String)stringArray[i]);
            for (int j = 0; j < ((String[])object).length; ++j) {
                String string2;
                String string3 = string2 = object[j].startsWith("!") ? object[j].substring(1) : object[j];
                if ("rowCount".equals(string2)) continue;
                boolean bl2 = !object[j].startsWith("!");
                stringBuilder.append(this.makeColumnRow(string2, bl2, bl, this.config));
            }
            stringBuilder.append("</tr></table>");
        }
        stringBuilder.append("</div>");
        if (bl) {
            if (this.config == null) {
                throw new RuntimeException("DBEditConfig\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
            String string4 = "<b>" + this.getDBColumn("EDIT_GRANDTOTAL_LABEL").getLongLabel() + ":</b>";
            object = "<b>" + this.getDBColumn("EDIT_FIRSTTOTAL_LABEL").getLongLabel() + ":</b>";
            stringBuilder.append("<div style=\"clear:both;\"><table>").append(this.makeCheckbox(GRANDTOTAL_PREFIX, this.config.useGrandTotal(), "h", string4, this.orderOnly)).append(this.makeCheckbox(FIRSTTOTAL_PREFIX, this.config.useFirstTotal(), "h", (String)object, this.orderOnly)).append("</table></div>");
        }
        return stringBuilder.toString();
    }

    private String makeLabelRow(boolean bl) {
        String string = "<b>" + this.getDBColumn("EDIT_COMMON_LABEL").getLongLabel() + ":</b>";
        String string2 = HybsSystem.sys("EDIT_COMMON_ROLES");
        String string3 = "<b>" + this.getDBColumn("EDIT_GROUP_LABEL").getLongLabel() + "</b>" + "<img id=\"groupBtn\" src=\"" + HybsSystem.sys("JSP") + "/image/ball-green.gif\" />";
        StringBuilder stringBuilder = new StringBuilder(200).append("<table><tr>").append("<td style=\"margin:0px; padding:0px;\"><table>");
        if (this.getUser().isAccess(string2)) {
            if (this.config == null) {
                throw new RuntimeException("DBEditConfig\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
            stringBuilder.append(this.makeCheckbox(COMMON_PREFIX, this.config.isCommon(), "h", string, this.orderOnly));
        } else {
            stringBuilder.append(this.makeLabel(string));
        }
        String string4 = "<b>" + this.getDBColumn("EDIT_VIEW_LABEL").getLongLabel() + ":</b>";
        stringBuilder.append(this.makeCheckbox("VIEW_ALL_CHECK", true, "h", string4, this.orderOnly));
        if (bl) {
            stringBuilder.append(this.makeLabel("EDIT_SUM_LABEL"));
        }
        stringBuilder.append(this.makeCell(string3, "h")).append(this.makeLabel("EDIT_SUBTOTAL_LABEL")).append(this.makeLabel("EDIT_TOTAL_LABEL")).append(this.makeLabel("EDIT_ORDERBY_LABEL")).append(this.makeLabel("EDIT_DESC_LABEL")).append("</table></td></tr></table>");
        return stringBuilder.toString();
    }

    private String makeColumnRow(String string, boolean bl, boolean bl2, DBEditConfig dBEditConfig) {
        if (this.table == null) {
            throw new RuntimeException("DBTableModel\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        int n = this.table.getColumnNo(string, false);
        DBColumn dBColumn = n < 0 ? this.getDBColumn(string) : this.table.getDBColumn(n);
        StringBuilder stringBuilder = new StringBuilder(200).append("<td name=\"").append(string).append("\" class=\"sortItem\" style=\"margin:0px; padding:0px;\">").append("<table>").append(this.makeLabel(dBColumn.getLongLabel())).append(this.makeCheckbox(VIEW_PREFIX + string, bl, "0", "", this.orderOnly));
        if (bl2) {
            boolean bl3 = this.isNumberClm(string);
            stringBuilder.append(this.makeCheckbox(SUM_PREFIX + string, dBEditConfig.isSumClm(string), "1", "", this.orderOnly, bl3));
        }
        stringBuilder.append(this.makeCheckbox(GROUP_PREFIX + string, dBEditConfig.isGroupClm(string), "0", "", this.orderOnly)).append(this.makeCheckbox(SUBTOTAL_PREFIX + string, dBEditConfig.isSubTotalClm(string), "1", "", this.orderOnly)).append(this.makeCheckbox(TOTAL_PREFIX + string, dBEditConfig.isTotalClm(string), "0", "", this.orderOnly)).append(this.makeInput(ORDERBY_PREFIX + string, dBEditConfig.getOrder(string), "1", "")).append(this.makeCheckbox(DESC_PREFIX + string, dBEditConfig.isOrderByDesc(string), "0", "", false)).append("</table></td>");
        return stringBuilder.toString();
    }

    private String makeCheckbox(String string, boolean bl, String string2, String string3, boolean bl2) {
        return this.makeCheckbox(string, bl, string2, string3, bl2, true);
    }

    private String makeCheckbox(String string, boolean bl, String string2, String string3, boolean bl2, boolean bl3) {
        if (bl3) {
            String string4 = new TagBuffer("input").add("type", "checkbox").add("name", string).add("value", "1").add("checked", "checked", bl).add("disabled", "disabled", bl2).makeTag();
            String string5 = bl2 && bl ? string4 + new TagBuffer("input").add("type", "hidden").add("name", string).add("value", "1").makeTag() : string4;
            return this.makeCell(string3 + string5, string2);
        }
        return this.makeCell(string3 + "&nbsp;", string2);
    }

    private String makeInput(String string, String string2, String string3, String string4) {
        String string5 = new TagBuffer("input").add("type", "text").add("name", string).add("value", string2).add("style", "width:10px; font-size:10px;").add("maxlength", "2").add("class", "S9").makeTag();
        return this.makeCell(string4 + string5, string3);
    }

    private String makeSeparateRow(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(200).append("<table style=\"float:left;\"><tr>").append("<td style=\"margin:0px; padding:0px;\"><table>").append(this.makeCell("&nbsp", "h")).append(this.makeCell("&nbsp", "h"));
        if (bl) {
            stringBuilder.append(this.makeCell("&nbsp", "h"));
        }
        stringBuilder.append(this.makeCell("&nbsp", "h")).append(this.makeCell("&nbsp", "h")).append(this.makeCell("&nbsp", "h")).append(this.makeCell("&nbsp", "h")).append(this.makeCell("&nbsp", "h")).append("</table></td></tr></table>");
        return stringBuilder.toString();
    }

    private String makeLabel(String string) {
        return this.makeCell(this.getDBColumn(string).getLongLabel(), "h");
    }

    private String makeCell(String string, String string2) {
        return "<tr><td align=\"center\" style=\"height:22px;\" class=\"row_" + string2 + "\">" + string + "</td></tr>";
    }

    private boolean getUseSum(String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = StringUtil.csv2Array((String)string.replace('|', ','));
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            String string3 = string2 = stringArray[i].startsWith("!") ? stringArray[i].substring(1) : stringArray[i];
            if (!this.isNumberClm(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean isNumberClm(String string) {
        if (string == null) {
            return false;
        }
        if (this.table == null) {
            throw new RuntimeException("DBTableModel\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        int n = this.table.getColumnNo(string, false);
        if (n >= 0) {
            DBColumn dBColumn = this.table.getDBColumn(n);
            return dBColumn != null && "NUMBER".equals(dBColumn.getClassName());
        }
        return false;
    }

    private void saveEditConfig() {
        String string = this.getRequest().getParameter("viewClms");
        String string2 = this.getColumns(SUM_PREFIX);
        String string3 = this.getColumns(GROUP_PREFIX);
        String string4 = this.getColumns(SUBTOTAL_PREFIX);
        String string5 = this.getColumns(TOTAL_PREFIX);
        String string6 = this.getRequest().getParameter(GRANDTOTAL_PREFIX);
        String string7 = this.getRequest().getParameter(FIRSTTOTAL_PREFIX);
        String string8 = this.getOrderByColumns();
        String string9 = this.getRequest().getParameter(COMMON_PREFIX);
        DBEditConfig dBEditConfig = new DBEditConfig(this.editName, string, string2, string3, string4, string5, string6, string7, string8, string9);
        this.getUser().addEditConfig(this.gamenId, this.editName, dBEditConfig);
    }

    private void deleteEditConfig() {
        this.getUser().deleteEditConfig(this.gamenId, this.editName);
    }

    private String getColumns(String string) {
        StringBuilder stringBuilder = new StringBuilder(200);
        Enumeration<?> enumeration = this.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith(string) || !"1".equals(string2 = this.getRequest().getParameter(string3))) continue;
            String string4 = string3.substring(string.length());
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String getOrderByColumns() {
        String string;
        CharSequence charSequence;
        Enumeration<?> enumeration = this.getParameterNames();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        HashMap<Integer, void> hashMap = new HashMap<Integer, void>();
        while (enumeration.hasMoreElements()) {
            void object2;
            Object object;
            charSequence = (String)enumeration.nextElement();
            if (!((String)charSequence).startsWith(ORDERBY_PREFIX) || (object = this.getRequest().getParameter((String)charSequence)) == null || ((String)object).length() <= 0) continue;
            String string2 = ((String)charSequence).substring(ORDERBY_PREFIX.length());
            string = this.getRequest().getParameter(DESC_PREFIX + string2);
            if ("1".equals(string)) {
                String string3 = "!" + string2;
            }
            Integer n = null;
            try {
                n = Integer.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            String string4 = (String)hashMap.get(n);
            while (string4 != null) {
                n = n + 1;
                string4 = (String)hashMap.get(n);
            }
            hashMap.put(n, object2);
            arrayList.add(n);
        }
        Collections.sort(arrayList);
        charSequence = new StringBuilder(200);
        for (Integer n : arrayList) {
            if (((StringBuilder)charSequence).length() > 0) {
                ((StringBuilder)charSequence).append(',');
            }
            string = (String)hashMap.get(n);
            ((StringBuilder)charSequence).append(string);
        }
        return ((StringBuilder)charSequence).toString();
    }

    private String getEditSelect(DBEditConfig ... dBEditConfigArray) {
        DBColumn dBColumn = this.getDBColumn("editName");
        StringBuilder stringBuilder = new StringBuilder(200).append("<span class=\"label editName\">").append(dBColumn.getLongLabel()).append(":</span><span class=\"editName\">").append("<select name=\"editName\">").append("<option />");
        for (DBEditConfig dBEditConfig : dBEditConfigArray) {
            String string = dBEditConfig.getEditName();
            stringBuilder.append("<option value=\"").append(string).append('\"');
            if (dBEditConfig.isCommon()) {
                stringBuilder.append(" class=\"commonEdit\"");
            }
            stringBuilder.append("\">").append(string).append("</option>");
        }
        stringBuilder.append("</select></span>");
        return stringBuilder.toString();
    }

    public void setCommand(String string) {
        this.command = StringUtil.nval((String)this.getRequestParameter(string), (String)this.command);
    }

    public void setGamenId(String string) {
        this.gamenId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.gamenId);
    }

    public void setEditName(String string) {
        this.editName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.editName);
    }

    public void setOrderOnly(String string) {
        this.orderOnly = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.orderOnly);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("command", (Object)this.command).println("gamenId", (Object)this.gamenId).println("editName", (Object)this.editName).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

