/****************************************************************************/
/* GF80 ( DB定義書ﾏｽﾀ )                                                     */
/*                                                                          */
/* Created : 2015/11/16 16:20:03                                            */
/****************************************************************************/
CREATE TABLE GF80 (
   SYSTEM_ID    VARCHAR2 (   10 )                   NOT NULL            /*  10 ｼｽﾃﾑID       */
 , TBLSYU       VARCHAR2 (    1 )                   NOT NULL            /*  20 ﾃｰﾌﾞﾙ種別    */
 , TABLE_NAME   VARCHAR2 (   50 )                   NOT NULL            /*  30 ﾃｰﾌﾞﾙ名      */
 , NAME_JA      VARCHAR2 (  200 )                                       /*  40 名称         */
 , SEQNO        NUMBER   (    7 )       DEFAULT 0   NOT NULL            /*  50 表示順       */
 , CLM_NAME     VARCHAR2 (  120 )                                       /*  60 項目名(漢字) */
 , CLM          VARCHAR2 (   30 )                   NOT NULL            /*  70 項目         */
 , CLS_NAME     VARCHAR2 (   10 )                   NOT NULL            /*  80 DBｸﾗｽ        */
 , PHY_LENGTH   VARCHAR2 (   10 )                                       /*  90 物理桁数     */
 , USE_LENGTH   VARCHAR2 (    9 )                                       /* 100 使用桁数     */
 , UK           VARCHAR2 (    2 )                                       /* 110 ﾕﾆｰｸｷｰ       */
 , LUK          VARCHAR2 (    2 )                                       /* 110 論理ﾕﾆｰｸｷｰ   */
 , IXA          VARCHAR2 (    2 )                                       /* 120 ｲﾝﾃﾞｯｸｽA     */
 , IXB          VARCHAR2 (    2 )                                       /* 130 ｲﾝﾃﾞｯｸｽB     */
 , IXC          VARCHAR2 (    2 )                                       /* 140 ｲﾝﾃﾞｯｸｽC     */
 , IXH          VARCHAR2 (    2 )                                       /* 150 ｲﾝﾃﾞｯｸｽH     */
 , IXD          VARCHAR2 (    2 )                                       /* 150 ｲﾝﾃﾞｯｸｽD     */
 , IXI          VARCHAR2 (    2 )                                       /* 160 ｲﾝﾃﾞｯｸｽI     */
 , IXE          VARCHAR2 (    2 )                                       /* 160 ｲﾝﾃﾞｯｸｽE     */
 , IXF          VARCHAR2 (    2 )                                       /* 170 ｲﾝﾃﾞｯｸｽF     */
 , IXJ          VARCHAR2 (    2 )                                       /* 170 ｲﾝﾃﾞｯｸｽJ     */
 , IXK          VARCHAR2 (    2 )                                       /* 180 ｲﾝﾃﾞｯｸｽK     */
 , IXG          VARCHAR2 (    2 )                                       /* 180 ｲﾝﾃﾞｯｸｽG     */
 , NOT_NULL     VARCHAR2 (    1 )                                       /* 190 ﾉｯﾄﾇﾙ        */
 , C_KEY        VARCHAR2 (    1 )                                       /* 200 C_KEY        */
 , F_KEY        VARCHAR2 (    1 )                                       /* 210 ﾌｫｰﾘﾝｷｰ      */
 , RENDERER     VARCHAR2 (   10 )                                       /* 220 表示種別     */
 , EDITOR       VARCHAR2 (   10 )                                       /* 230 編集種別     */
 , DBTYPE       VARCHAR2 (   10 )                                       /* 240 文字種別     */
 , DATA_DEFAULT VARCHAR2 (  200 )                                       /* 250 初期値       */
 , KBCLM        VARCHAR2 (    1 )       DEFAULT '0' NOT NULL            /* 260 ｶﾗﾑ区分      */
 , BIKO         VARCHAR2 ( 2000 )                                       /* 270 備考         */
 , CDKH         VARCHAR2 (    1 )                                       /* 280 改廃ｺｰﾄﾞ     */
 , COMMENTS     VARCHAR2 (  500 )                                       /* 290 ｺﾒﾝﾄ         */
 , UNIQ         NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 800 ﾕﾆｰｸｷｰ       */
 , FGJ          VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 810 状態ﾌﾗｸﾞ     */
 , DYSET        VARCHAR2 (   14 )                                       /* 820 登録日時     */
 , PGSET        VARCHAR2 (   10 )                                       /* 830 作成PG       */
 , PGPSET       VARCHAR2 (   10 )                                       /* 840 作成親PG     */
 , USRSET       VARCHAR2 (   10 )                                       /* 850 作成社員     */
 , DYUPD        VARCHAR2 (   14 )                                       /* 860 更新日時     */
 , PGUPD        VARCHAR2 (   10 )                                       /* 870 更新PG       */
 , PGPUPD       VARCHAR2 (   10 )                                       /* 880 更新親PG     */
 , USRUPD       VARCHAR2 (   10 )                                       /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K );

CREATE SEQUENCE GF80S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF80T00 
  BEFORE INSERT ON GF80
  FOR EACH ROW 
  BEGIN 
    SELECT GF80S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
