/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.xml;

import java.util.ArrayList;
import java.util.List;
import org.opengion.fukurou.util.HybsConst;
import org.xml.sax.Attributes;

public class OGAttributes {
    public static final int CR_CNT = 4;
    public static final int CR_LEN = 80;
    private final List<OGAtts> attList = new ArrayList<OGAtts>();
    private boolean useCR;
    private int maxValLen;
    private String id;

    public OGAttributes() {
    }

    public OGAttributes(Attributes attributes) {
        int n = attributes == null ? 0 : attributes.getLength();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string = attributes.getQName(i);
            String string2 = attributes.getValue(i);
            OGAtts oGAtts = new OGAtts(string, string2);
            this.attList.add(oGAtts);
            n2 = oGAtts.maxKeyLen(n2);
            if (!"id".equals(string)) continue;
            this.id = string2;
        }
        this.maxValLen = n2;
    }

    public void setUseCR(boolean bl) {
        this.useCR = bl;
    }

    public int size() {
        return this.attList.size();
    }

    public String getKey(int n) {
        return this.attList.get(n).KEY;
    }

    public String getVal(int n) {
        return this.attList.get(n).VAL;
    }

    public String getVal(String string) {
        String string2 = null;
        if (string != null) {
            for (OGAtts oGAtts : this.attList) {
                if (!string.equals(oGAtts.KEY)) continue;
                string2 = oGAtts.VAL;
                break;
            }
        }
        return string2;
    }

    public int getAdrs(String string) {
        int n = -1;
        if (string != null) {
            for (int i = 0; i < this.attList.size(); ++i) {
                if (!string.equals(this.attList.get(i).KEY)) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public String getId() {
        return this.id;
    }

    public void setVal(int n, String string) {
        OGAtts oGAtts = this.attList.remove(n);
        this.attList.add(n, new OGAtts(oGAtts.KEY, string));
        if ("id".equals(oGAtts.KEY)) {
            this.id = string;
        }
    }

    public void setVal(String string, String string2) {
        int n = this.getAdrs(string);
        if (n < 0) {
            this.add(string, string2);
        } else {
            this.setVal(n, string2);
        }
    }

    public void add(String string, String string2) {
        OGAtts oGAtts = new OGAtts(string, string2);
        this.attList.add(oGAtts);
        this.maxValLen = oGAtts.maxKeyLen(this.maxValLen);
        if ("id".equals(string)) {
            this.id = string2;
        }
    }

    public void add(int n, String string, String string2) {
        OGAtts oGAtts = new OGAtts(string, string2);
        this.attList.add(n, oGAtts);
        this.maxValLen = oGAtts.maxKeyLen(this.maxValLen);
        if ("id".equals(string)) {
            this.id = string2;
        }
    }

    public void remove(int n) {
        OGAtts oGAtts = this.attList.remove(n);
        if ("id".equals(oGAtts.KEY)) {
            this.id = null;
        }
    }

    public String getText(String string) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder(200);
        String string3 = string2 = string.length() > 0 ? string : HybsConst.CR + "\t";
        if (this.useCR) {
            for (int i = 0; i < this.size(); ++i) {
                OGAtts oGAtts = this.attList.get(i);
                stringBuilder.append(string2);
                stringBuilder.append(oGAtts.getAlignKey(this.maxValLen)).append('=').append(oGAtts.QRT_VAL);
            }
            stringBuilder.append(HybsConst.CR);
        } else {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.size(); ++i) {
                OGAtts oGAtts = this.attList.get(i);
                if (i > 0 && (++n > 4 || (n2 += oGAtts.LEN) > 80)) {
                    stringBuilder.append(string2);
                    stringBuilder.append(oGAtts.KEY).append('=').append(oGAtts.QRT_VAL);
                    n = 0;
                    n2 = 0;
                    continue;
                }
                stringBuilder.append(' ').append(oGAtts.KEY).append('=').append(oGAtts.QRT_VAL);
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getText(" ");
    }

    private static final class OGAtts {
        private static final String SPACE = "                    ";
        private final String KEY;
        private final String VAL;
        private final int KLEN;
        private final int LEN;
        private final String QRT_VAL;

        OGAtts(String string, String string2) {
            this.KEY = string;
            this.VAL = string2 == null ? "" : this.htmlFilter(string2);
            this.KLEN = string.length();
            this.LEN = this.KLEN + this.VAL.length();
            this.QRT_VAL = this.VAL.indexOf(34) >= 0 ? "'" + this.VAL + "'" : "\"" + this.VAL + "\"";
        }

        int maxKeyLen(int n) {
            return n > this.KLEN ? n : this.KLEN;
        }

        String getAlignKey(int n) {
            return this.KEY + SPACE.substring(this.KLEN, n);
        }

        private String htmlFilter(String string) {
            if (string == null || string.isEmpty()) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder(200);
            block5: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '<': {
                        stringBuilder.append("&lt;");
                        continue block5;
                    }
                    case '>': {
                        stringBuilder.append("&gt;");
                        continue block5;
                    }
                    case '&': {
                        stringBuilder.append("&amp;");
                        continue block5;
                    }
                    default: {
                        stringBuilder.append(c);
                    }
                }
            }
            return stringBuilder.toString();
        }
    }
}

