/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.io;

import java.io.File;
import java.io.PrintWriter;
import org.opengion.fukurou.model.ExcelModel;
import org.opengion.fukurou.model.NativeType;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.plugin.io.TableWriter_Default;

public class TableWriter_Excel
extends TableWriter_Default {
    private static final String VERSION = "6.2.4.2 (2015/05/29)";
    private int nRowIndex;
    private String filename;
    private String directory;
    private String fileKey;
    private String sheetName = "Sheet";
    private String fontName;
    private short fontPoint = (short)-1;
    private String refFilename;
    private String refSheetName;
    private boolean useNumber = true;
    private int skipRowCount;
    private ExcelModel excel;
    private boolean useCellStyle;
    private boolean useAutoCellSize;
    private boolean useActiveWorkbook;
    private String fileBreakColumn;
    private String pageBreakColumn;
    private boolean noPageBreak;
    private String hLinkKeyColumn;
    private String hLinkValColumn;
    private String addTitleSheet;
    private int pageBreakClmNo = -1;
    private int fileBreakClmNo = -1;
    private int hLinkKeyClmNo = -1;
    private int hLinkValClmNo = -1;
    private int tblRow;
    private boolean[] nvar;
    private boolean[] isNums;

    @Override
    public void writeDBTable() {
        DBColumn dBColumn;
        if (!this.createDBColumn()) {
            return;
        }
        this.useNumber = this.isUseNumber();
        if (this.filename == null) {
            throw new HybsSystemException("\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (this.isAppend()) {
            if (this.refFilename != null && !this.filename.equalsIgnoreCase(this.refFilename)) {
                String string = "\u8ffd\u52a0(append\u30e2\u30fc\u30c9)\u306e\u6642\u3001\u96db\u5f62\u30d5\u30a1\u30a4\u30eb\u306e\u6307\u5b9a\u306f\u7121\u52b9\u3067\u3059\u3002" + CR + " filename=[" + this.filename + "] , refFilename=[" + this.refFilename + "]" + CR;
                throw new HybsSystemException(string);
            }
            this.refFilename = this.filename;
        }
        boolean bl = this.refFilename != null && this.refFilename.length() > 0;
        String string = bl ? this.refFilename : this.filename;
        this.initWriteData();
        boolean bl2 = this.isDebug();
        DBColumn dBColumn2 = this.fileBreakClmNo >= 0 && this.isUseRenderer() ? this.dbColumn[this.fileBreakClmNo] : null;
        DBColumn dBColumn3 = dBColumn = this.pageBreakClmNo >= 0 && this.isUseRenderer() ? this.dbColumn[this.pageBreakClmNo] : null;
        if (this.fileBreakClmNo >= 0) {
            this.fileKey = (String)this.table.getValue(this.tblRow, this.fileBreakClmNo);
        }
        while (this.fileKey != null) {
            String string2 = dBColumn2 == null ? this.fileKey : dBColumn2.getWriteValue(this.fileKey);
            this.excel = new ExcelModel(new File(string), bl);
            if (!bl) {
                this.excel.setFont(this.fontName, this.fontPoint);
            }
            if (this.useCellStyle) {
                this.excel.setCellStyle();
            }
            this.excel.useAutoCellSize(this.useAutoCellSize);
            this.excel.setAddTitleSheet(this.addTitleSheet);
            if (bl) {
                this.excel.setRefSheetName(this.refSheetName);
            }
            if (this.pageBreakClmNo >= 0) {
                this.sheetName = (String)this.table.getValue(this.tblRow, this.pageBreakClmNo);
            }
            this.noPageBreak = true;
            while (this.noPageBreak) {
                if (bl2) {
                    System.out.println(" file=" + this.fileKey + " , sheet=" + this.sheetName + " , row=" + this.tblRow);
                }
                String string3 = dBColumn == null ? this.sheetName : dBColumn.getWriteValue(this.sheetName);
                this.excel.createSheet(string3);
                this.nRowIndex = this.skipRowCount;
                super.writeDBTable(null);
                this.excel.removeRow(this.nRowIndex);
            }
            if (this.useActiveWorkbook) {
                this.excel.activeWorkbook(false);
            }
            this.excel.saveFile(new File(this.directory, string2));
        }
    }

    protected void writeLabel(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = 0;
        this.excel.createRow(this.nRowIndex++);
        if (this.useNumber) {
            int n2 = n;
            n = (short)(n + 1);
            this.headerCellValue("Label", n2);
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n3 = this.clmNo[i];
            if (n3 < 0) {
                n = (short)(n + 1);
                continue;
            }
            String string = StringUtil.tagCut((String)this.dbColumn[n3].getLabel());
            int n4 = n;
            n = (short)(n + 1);
            this.headerCellValue(string, n4);
            if (!this.isKeyLbl[i]) continue;
            int n5 = n;
            n = (short)(n + 1);
            this.headerCellValue("", n5);
        }
        this.excel.removeCell(n);
    }

    protected void writeName(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = 0;
        this.excel.createRow(this.nRowIndex++);
        if (this.useNumber) {
            int n2 = n;
            n = (short)(n + 1);
            this.headerCellValue("Name", n2);
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n3 = this.clmNo[i];
            if (n3 < 0) {
                n = (short)(n + 1);
                continue;
            }
            String string = dBTableModel.getColumnName(n3);
            int n4 = n;
            n = (short)(n + 1);
            this.headerCellValue(string, n4);
            if (!this.isKeyLbl[i]) continue;
            int n5 = n;
            n = (short)(n + 1);
            this.headerCellValue("", n5);
        }
        this.excel.removeCell(n);
    }

    protected void writeSize(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = 0;
        this.excel.createRow(this.nRowIndex++);
        if (this.useNumber) {
            int n2 = n;
            n = (short)(n + 1);
            this.headerCellValue("Size", n2);
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n3 = this.clmNo[i];
            if (n3 < 0) {
                n = (short)(n + 1);
                continue;
            }
            String string = String.valueOf(this.dbColumn[n3].getTotalSize());
            int n4 = n;
            n = (short)(n + 1);
            this.headerCellValue(string, n4);
            if (!this.isKeyLbl[i]) continue;
            int n5 = n;
            n = (short)(n + 1);
            this.headerCellValue("", n5);
        }
        this.excel.removeCell(n);
    }

    protected void writeClass(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = 0;
        this.excel.createRow(this.nRowIndex++);
        if (this.useNumber) {
            int n2 = n;
            n = (short)(n + 1);
            this.headerCellValue("Class", n2);
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n3 = this.clmNo[i];
            if (n3 < 0) {
                n = (short)(n + 1);
                continue;
            }
            String string = this.dbColumn[n3].getClassName();
            int n4 = n;
            n = (short)(n + 1);
            this.headerCellValue(string, n4);
            if (!this.isKeyLbl[i]) continue;
            int n5 = n;
            n = (short)(n + 1);
            this.headerCellValue("", n5);
        }
        this.excel.removeCell(n);
    }

    protected void writeSeparator(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = 0;
        this.excel.createRow(this.nRowIndex++);
        if (this.useNumber) {
            int n2 = n;
            n = (short)(n + 1);
            this.headerCellValue("----", n2);
        }
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n3 = this.clmNo[i];
            if (n3 < 0) {
                n = (short)(n + 1);
                continue;
            }
            int n4 = n;
            n = (short)(n + 1);
            this.headerCellValue("----", n4);
            if (!this.isKeyLbl[i]) continue;
            int n5 = n;
            n = (short)(n + 1);
            this.headerCellValue("----", n5);
        }
        this.excel.removeCell(n);
    }

    private void headerCellValue(String string, int n) {
        if (n == 0) {
            this.excel.setCellValue("#" + string, n);
        } else {
            this.excel.setCellValue(string, n);
        }
    }

    private void initWriteData() {
        DBTableModel dBTableModel = this.getDBTableModel();
        this.pageBreakClmNo = dBTableModel.getColumnNo(this.pageBreakColumn, false);
        this.fileBreakClmNo = dBTableModel.getColumnNo(this.fileBreakColumn, false);
        this.hLinkKeyClmNo = dBTableModel.getColumnNo(this.hLinkKeyColumn, false);
        this.hLinkValClmNo = dBTableModel.getColumnNo(this.hLinkValColumn, false);
        this.nvar = new boolean[this.numberOfColumns];
        this.isNums = new boolean[this.numberOfColumns];
        boolean bl = this.isUseRenderer();
        for (int i = 0; i < this.numberOfColumns; ++i) {
            int n = this.clmNo[i];
            if (n < 0) continue;
            if (bl && this.dbColumn[n].isStringOutput()) {
                this.isNums[i] = false;
            } else {
                NativeType nativeType = this.dbColumn[n].getNativeType();
                switch (nativeType) {
                    case INT: 
                    case LONG: 
                    case DOUBLE: {
                        this.isNums[i] = true;
                        break;
                    }
                    default: {
                        this.isNums[i] = false;
                    }
                }
            }
            this.nvar[i] = "NVAR".equals(this.dbColumn[n].getDbType());
        }
    }

    @Override
    protected void writeData(DBTableModel dBTableModel, PrintWriter printWriter) {
        int n = dBTableModel.getRowCount();
        boolean bl = this.isUseRenderer();
        if (this.useAutoCellSize) {
            this.excel.setDataStartRow(this.nRowIndex);
        }
        int n2 = 1;
        while (this.tblRow < n) {
            String string;
            if (this.fileBreakClmNo >= 0 && !this.fileKey.equals(string = (String)dBTableModel.getValue(this.tblRow, this.fileBreakClmNo))) {
                this.fileKey = string;
                this.noPageBreak = false;
                return;
            }
            if (this.pageBreakClmNo >= 0 && !this.sheetName.equals(string = (String)dBTableModel.getValue(this.tblRow, this.pageBreakClmNo))) {
                this.sheetName = string;
                return;
            }
            int n3 = 0;
            this.excel.createRow(this.nRowIndex++);
            if (this.useNumber) {
                int n4 = n2++;
                int n5 = n3;
                n3 = (short)(n3 + 1);
                this.excel.setCellValue(String.valueOf(n4), n5, true);
            }
            for (int i = 0; i < this.numberOfColumns; ++i) {
                int n6 = this.clmNo[i];
                if (n6 < 0) {
                    n3 = (short)(n3 + 1);
                    continue;
                }
                String string2 = (String)dBTableModel.getValue(this.tblRow, n6);
                if (this.isKeyLbl[i]) {
                    int n7 = n3;
                    n3 = (short)(n3 + 1);
                    this.excel.setCellValue(string2, n7, this.isNums[i]);
                }
                if (this.nvar[i]) {
                    string2 = StringUtil.getReplaceEscape((String)string2);
                } else if (bl) {
                    string2 = this.dbColumn[n6].getWriteValue(string2);
                }
                this.excel.setCellValue(string2, n3, this.isNums[i]);
                if (n6 == this.hLinkKeyClmNo && this.hLinkValClmNo >= 0) {
                    String string3 = (String)dBTableModel.getValue(this.tblRow, this.hLinkValClmNo);
                    this.excel.setCellLink(string3, n3);
                }
                n3 = (short)(n3 + 1);
            }
            this.excel.removeCell(n3);
            ++this.tblRow;
        }
        this.noPageBreak = false;
        this.fileKey = null;
    }

    public void setFilename(String string, String string2) {
        this.filename = StringUtil.urlAppend((String)string, (String)string2, (String[])new String[0]);
        this.directory = string;
        this.fileKey = string2;
    }

    public void setSheetName(String string) {
        if (string != null) {
            this.sheetName = string;
        }
    }

    public boolean isExcel() {
        return true;
    }

    public void setRefFilename(String string) {
        this.refFilename = string;
    }

    public void setRefSheetName(String string) {
        if (string != null) {
            this.refSheetName = string;
        }
    }

    public void setSkipRowCount(int n) {
        this.skipRowCount = n;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public void setFontPoint(short s) {
        this.fontPoint = s;
    }

    public void setUseCellStyle(boolean bl) {
        this.useCellStyle = bl;
    }

    public void setUseAutoCellSize(boolean bl) {
        this.useAutoCellSize = bl;
    }

    public void setUseActiveWorkbook(boolean bl) {
        this.useActiveWorkbook = bl;
    }

    public void setPageBreakColumn(String string) {
        this.pageBreakColumn = string;
    }

    public void setFileBreakColumn(String string) {
        this.fileBreakColumn = string;
    }

    public void setHyperLinkColumn(String string) {
        if (string != null && string.length() > 0) {
            int n = string.indexOf(58);
            if (n >= 0) {
                this.hLinkKeyColumn = string.substring(0, n);
                this.hLinkValColumn = string.substring(n + 1);
            } else {
                this.hLinkKeyColumn = string;
                this.hLinkValColumn = string;
            }
        }
    }

    public void setAddTitleSheet(String string) {
        this.addTitleSheet = string;
    }
}

