/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.transfer;

import java.io.IOException;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.transfer.TransferConfig;
import org.opengion.fukurou.transfer.TransferExec;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.URLConnect;

public abstract class AbstractTransferExecHTTP
implements TransferExec {
    private static final String REMOTE_SERVLET = "servlet/remoteControl?class=TransferExecWrapper";

    @Override
    public void execute(String[] stringArray, TransferConfig transferConfig, Transaction transaction) {
        URLConnect uRLConnect = null;
        try {
            this.splitExecObj(transferConfig.getExecObj());
            uRLConnect = transferConfig.connect(this.getRemoteHost() + REMOTE_SERVLET, this.getPostData(stringArray, transferConfig));
            String string = uRLConnect.readData();
            if (string != null && string.indexOf("row_error") >= 0) {
                throw new RuntimeException(string);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("URL\u63a5\u7d9a\u6642\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", iOException);
        }
        finally {
            if (uRLConnect != null) {
                uRLConnect.disconnect();
            }
        }
    }

    protected abstract void splitExecObj(String var1);

    protected abstract String getRemoteHost();

    protected abstract String getRemoteExecObj();

    private String getPostData(String[] stringArray, TransferConfig transferConfig) {
        String string = this.getClass().getName().replace(this.getClass().getSuperclass().getName() + "_", "");
        StringBuilder stringBuilder = new StringBuilder(200).append("KBREAD=").append(StringUtil.urlEncode(transferConfig.getKbRead())).append("&READOBJ=").append(StringUtil.urlEncode(transferConfig.getReadObj())).append("&READPRM=").append(StringUtil.urlEncode(transferConfig.getReadPrm())).append("&KBEXEC=").append(StringUtil.urlEncode(string)).append("&EXECDBID=").append(StringUtil.urlEncode(transferConfig.getExecDbid())).append("&EXECOBJ=").append(StringUtil.urlEncode(this.getRemoteExecObj())).append("&EXECPRM=").append(StringUtil.urlEncode(transferConfig.getExecPrm())).append("&ERROR_SENDTO=").append(StringUtil.urlEncode(transferConfig.getErrorSendto())).append("&HFROM=").append(StringUtil.urlEncode(transferConfig.getHfrom()));
        if (stringArray != null && stringArray.length > 0) {
            stringBuilder.append("&n=").append(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append("&v").append(i).append('=');
                stringBuilder.append(StringUtil.urlEncode(stringArray[i]));
            }
        } else {
            stringBuilder.append("&n=0");
        }
        return stringBuilder.toString();
    }
}

