/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.opengion.fukurou.util.Closer;

public final class ZipArchive {
    private ZipArchive() {
    }

    public static List<File> unCompress(File file, File file2) {
        return ZipArchive.unCompress(file, file2, "Windows-31J");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<File> unCompress(File file, File file2, String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        ZipArchiveInputStream zipArchiveInputStream = null;
        File file3 = null;
        try {
            zipArchiveInputStream = new ZipArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(file2)), string);
            ZipArchiveEntry zipArchiveEntry = null;
            while ((zipArchiveEntry = zipArchiveInputStream.getNextZipEntry()) != null) {
                long l;
                String string2;
                file3 = new File(file, zipArchiveEntry.getName());
                arrayList.add(file3);
                if (zipArchiveEntry.isDirectory()) {
                    if (!file3.exists() && !file3.mkdirs()) {
                        String string3 = "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[\u30d5\u30a1\u30a4\u30eb\u540d=" + file3 + "]";
                        System.err.println(string3);
                        continue;
                    }
                } else {
                    if (!file3.getParentFile().exists() && !file3.getParentFile().mkdirs()) {
                        String string4 = "\u89aa\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[\u30d5\u30a1\u30a4\u30eb\u540d=" + file3 + "]";
                        System.err.println(string4);
                        continue;
                    }
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
                    try {
                        IOUtils.copy((InputStream)zipArchiveInputStream, (OutputStream)bufferedOutputStream);
                    }
                    catch (IOException iOException) {
                        string2 = "ZIP\u30d5\u30a1\u30a4\u30eb\u306e\u4f5c\u6210(copy)\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[\u30d5\u30a1\u30a4\u30eb\u540d=" + file3 + "]";
                        System.err.println(string2);
                        continue;
                    }
                    finally {
                        Closer.ioClose(bufferedOutputStream);
                        continue;
                    }
                }
                if ((l = zipArchiveEntry.getTime()) < 0L || file3.setLastModified(l)) continue;
                string2 = "ZIP\u66f4\u65b0\u6642\u523b\u306e\u8a2d\u5b9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[\u30d5\u30a1\u30a4\u30eb\u540d=" + file3 + "]";
                System.err.println(string2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                String string5 = "\u89e3\u51cd\u30d5\u30a1\u30a4\u30eb\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3002[\u30d5\u30a1\u30a4\u30eb\u540d=" + file3 + "]";
                throw new RuntimeException(string5, fileNotFoundException);
                catch (IOException iOException) {
                    String string6 = "ZIP\u30d5\u30a1\u30a4\u30eb\u306e\u89e3\u51cd\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[\u30d5\u30a1\u30a4\u30eb\u540d=" + file3 + "]";
                    throw new RuntimeException(string6, iOException);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(zipArchiveInputStream);
                throw throwable;
            }
        }
        Closer.ioClose((Closeable)zipArchiveInputStream);
        return arrayList;
    }

    public static List<File> compress(File[] fileArray, File file) {
        return ZipArchive.compress(fileArray, file, "Windows-31J");
    }

    public static List<File> compress(File file, File file2) {
        File[] fileArray;
        if (file.isDirectory()) {
            fileArray = file.listFiles();
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        }
        File[] fileArray3 = fileArray;
        return ZipArchive.compress(fileArray3, file2, "Windows-31J");
    }

    public static List<File> compress(File[] fileArray, File file, String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (fileArray != null && fileArray.length > 0 && file != null) {
            ZipArchiveOutputStream zipArchiveOutputStream = null;
            try {
                zipArchiveOutputStream = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
                if (string != null) {
                    zipArchiveOutputStream.setEncoding(string);
                }
                ZipArchive.addZipEntry(arrayList, zipArchiveOutputStream, "", fileArray);
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    String string2 = "ZIP\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002[\u30d5\u30a1\u30a4\u30eb\u540d=" + file + "]";
                    throw new RuntimeException(string2, fileNotFoundException);
                }
                catch (Throwable throwable) {
                    Closer.ioClose(zipArchiveOutputStream);
                    throw throwable;
                }
            }
            Closer.ioClose((Closeable)zipArchiveOutputStream);
        }
        return arrayList;
    }

    private static void addZipEntry(List<File> list, ZipArchiveOutputStream zipArchiveOutputStream, String string, File ... fileArray) {
        File file = null;
        try {
            File[] fileArray2 = fileArray;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                ZipArchiveEntry zipArchiveEntry;
                String string2;
                File file2;
                file = file2 = fileArray2[i];
                list.add(file2);
                if (file2.isDirectory()) {
                    string2 = string + file2.getName() + "/";
                    zipArchiveEntry = new ZipArchiveEntry(string2);
                    zipArchiveOutputStream.putArchiveEntry((ArchiveEntry)zipArchiveEntry);
                    zipArchiveOutputStream.closeArchiveEntry();
                    ZipArchive.addZipEntry(list, zipArchiveOutputStream, string2, file2.listFiles());
                    continue;
                }
                string2 = string + file2.getName();
                zipArchiveEntry = new ZipArchiveEntry(string2);
                zipArchiveOutputStream.putArchiveEntry((ArchiveEntry)zipArchiveEntry);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                IOUtils.copy((InputStream)bufferedInputStream, (OutputStream)zipArchiveOutputStream);
                zipArchiveOutputStream.closeArchiveEntry();
                Closer.ioClose(bufferedInputStream);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = "\u5727\u7e2e\u5bfe\u8c61\u306e\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002[\u30d5\u30a1\u30a4\u30eb\u540d=" + file + "]";
            throw new RuntimeException(string3, fileNotFoundException);
        }
        catch (IOException iOException) {
            String string4 = "ZIP\u5727\u7e2e\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[\u30d5\u30a1\u30a4\u30eb\u540d=" + file + "]";
            throw new RuntimeException(string4, iOException);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            System.out.println("Usage: java org.opengion.fukurou.util.ZipArchive comp|uncomp targetPath zipFileName");
            return;
        }
        long l = System.currentTimeMillis();
        List<File> list = null;
        File file = new File(stringArray[1]);
        File file2 = new File(stringArray[2]);
        if ("comp".equalsIgnoreCase(stringArray[0])) {
            list = ZipArchive.compress(file, file2);
        } else if ("uncomp".equalsIgnoreCase(stringArray[0])) {
            list = ZipArchive.unCompress(file, file2);
        } else {
            System.out.println("Usage: java org.opengion.fukurou.util.ZipArchive comp|uncomp targetPath zipFileName");
            return;
        }
        if (list != null) {
            System.out.println("\u51e6\u7406\u6642\u9593 : " + (System.currentTimeMillis() - l) + "(ms)");
            for (File file3 : list) {
                System.out.println(file3);
            }
        }
    }
}

