/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.util.TimeStampObject;

public abstract class AbstractObjectPool<E> {
    private List<E> pool;
    private Map<Integer, TimeStampObject> poolBack;
    private final Object lock = new Object();
    private boolean limit;
    private int maxsize;
    private int limitTime;
    private static final int MAX_LIMIT_COUNT = 1000;

    protected void init(int n, int n2, boolean bl) {
        this.init(n, n2, bl, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(int n, int n2, boolean bl, int n3) {
        this.maxsize = n2;
        this.limit = bl;
        this.limitTime = n3;
        Object object = this.lock;
        synchronized (object) {
            this.pool = Collections.synchronizedList(new ArrayList(n2));
            this.poolBack = Collections.synchronizedMap(new HashMap());
            for (int i = 0; i < n; ++i) {
                E e = this.createInstance();
                this.pool.add(e);
                Integer n4 = e.hashCode();
                this.poolBack.put(n4, new TimeStampObject(e, n3));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E newInstance() throws MissingResourceException {
        E e;
        Object object = this.lock;
        synchronized (object) {
            if (this.pool.isEmpty()) {
                if (this.limit && this.poolBack.size() >= this.maxsize) {
                    String string = "\u751f\u6210\u30ea\u30df\u30c3\u30c8\u3044\u3063\u3071\u3044\u3067\u65b0\u305f\u306b\u751f\u6210\u3067\u304d\u307e\u305b\u3093\u3002[" + this.poolBack.size() + "]";
                    Iterator<TimeStampObject> iterator = this.poolBack.values().iterator();
                    while (iterator.hasNext()) {
                        TimeStampObject timeStampObject = iterator.next();
                        if (timeStampObject != null && !timeStampObject.isTimeOver()) continue;
                        iterator.remove();
                    }
                    throw new MissingResourceException(string, this.getClass().getName(), "limit");
                }
                if (this.poolBack.size() > 1000) {
                    this.clear();
                    String string = "ObjectPool \u3067\u3001\u30e1\u30e2\u30ea\u30ea\u30fc\u30af\u306e\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002size=[" + this.poolBack.size() + "]";
                    throw new RuntimeException(string);
                }
                e = this.createInstance();
                Integer n = e.hashCode();
                this.poolBack.put(n, new TimeStampObject(e, this.limitTime));
            } else {
                e = this.pool.remove(0);
                if (e != null) {
                    Integer n = e.hashCode();
                    TimeStampObject timeStampObject = this.poolBack.get(n);
                    if (timeStampObject == null || timeStampObject.isTimeOver()) {
                        this.remove(e);
                        return this.newInstance();
                    }
                } else {
                    throw new MissingResourceException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", this.getClass().getName(), "pool");
                }
            }
        }
        return e;
    }

    protected abstract E createInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(E e) {
        E e2 = this.objectInitial(e);
        if (e2 != null) {
            Integer n = e2.hashCode();
            Object object = this.lock;
            synchronized (object) {
                TimeStampObject timeStampObject = this.poolBack.get(n);
                if (timeStampObject != null) {
                    this.pool.add(e2);
                } else {
                    this.remove(e2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(E e) {
        if (e != null) {
            Integer n = e.hashCode();
            Object object = this.lock;
            synchronized (object) {
                this.poolBack.remove(n);
            }
        }
        this.objectFinal(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.poolBack.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.poolBack.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clear() {
        Object object = this.lock;
        synchronized (object) {
            Iterator<E> iterator = this.pool.iterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            this.pool.clear();
            boolean bl = this.poolBack.isEmpty();
            this.poolBack.clear();
            return bl;
        }
    }

    protected void objectFinal(E e) {
    }

    protected E objectInitial(E e) {
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            StringBuilder stringBuilder = new StringBuilder(200).append("  freeCount    = [").append(this.pool.size()).append("]").append(HybsConst.CR).append("  createCount  = [").append(this.poolBack.size()).append(']').append(" ( max=[").append(this.maxsize).append("] )").append(HybsConst.CR).append("  limiter      = [").append(this.limit).append("]").append(HybsConst.CR).append("  limitTime    = [").append(this.limitTime).append("](s)").append(HybsConst.CR);
            Iterator<E> iterator = this.pool.iterator();
            stringBuilder.append("Free Objects ").append(HybsConst.CR);
            while (iterator.hasNext()) {
                E e = iterator.next();
                if (e == null) continue;
                Integer n = e.hashCode();
                stringBuilder.append(' ').append(this.poolBack.get(n)).append(' ').append(e).append(HybsConst.CR);
            }
            return stringBuilder.toString();
        }
    }
}

