/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.xml;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.fukurou.xml.JspParserFilter;
import org.opengion.fukurou.xml.OGDocument;
import org.opengion.fukurou.xml.OGElement;
import org.opengion.fukurou.xml.OGNode;
import org.opengion.fukurou.xml.OGNodeType;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class JspSaxParser
extends DefaultHandler2 {
    private final List<JspParserFilter> filters = new ArrayList<JspParserFilter>();
    private SAXParser parser;
    private Map<String, OGElement> idMap;
    private Stack<OGNode> stack;
    private OGNode ele;
    private boolean inCDATA;
    private boolean inEntity;
    private String filename;

    public OGDocument read(File file) {
        this.filename = file.getAbsolutePath();
        try {
            if (this.parser == null) {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                this.parser = sAXParserFactory.newSAXParser();
                this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            }
            this.parser.parse(file, (DefaultHandler)this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = "\u91cd\u5927\u306a\u69cb\u6210\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + "\t" + parserConfigurationException.getMessage() + HybsConst.CR + "\t" + file;
            throw new RuntimeException(string, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            String string = "SAX \u306e\u4e00\u822c\u7684\u306a\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + "\t" + sAXException.getMessage() + HybsConst.CR + "\t" + file;
            Exception exception = sAXException.getException();
            if (exception != null) {
                string = string + HybsConst.CR + "\t" + exception.getMessage();
            }
            throw new RuntimeException(string, sAXException);
        }
        catch (IOException iOException) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u8aad\u53d6\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + "\t" + iOException.getMessage() + HybsConst.CR + "\t" + file;
            throw new RuntimeException(string, iOException);
        }
        return this.getDocument();
    }

    public OGDocument string2Node(String string) {
        this.filename = null;
        try {
            Object object;
            if (this.parser == null) {
                object = SAXParserFactory.newInstance();
                this.parser = ((SAXParserFactory)object).newSAXParser();
                this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            }
            object = new InputSource(new StringReader(string));
            this.parser.parse((InputSource)object, (DefaultHandler)this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string2 = "\u91cd\u5927\u306a\u69cb\u6210\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + parserConfigurationException.getMessage();
            throw new RuntimeException(string2, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            String string3 = "SAX \u306e\u4e00\u822c\u7684\u306a\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + sAXException.getMessage();
            Exception exception = sAXException.getException();
            if (exception != null) {
                string3 = string3 + HybsConst.CR + "\t" + exception.getMessage();
            }
            throw new RuntimeException(string3, sAXException);
        }
        catch (IOException iOException) {
            String string4 = "\u30b9\u30c8\u30ea\u30fc\u30e0\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u4f5c\u6210\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + iOException.getMessage();
            throw new RuntimeException(string4, iOException);
        }
        return this.getDocument();
    }

    public void write(File file, OGDocument oGDocument) {
        PrintWriter printWriter = null;
        String string = oGDocument.getEncode();
        try {
            printWriter = FileUtil.getPrintWriter(file, string);
            printWriter.println(oGDocument.toString());
        }
        catch (RuntimeException runtimeException) {
            String string2 = "\u5b9f\u884c\u6642\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + "\t " + runtimeException.getMessage() + HybsConst.CR + "\t File=[" + file + ']' + HybsConst.CR + "\t Encode=[" + string + ']';
            throw new RuntimeException(string2, runtimeException);
        }
        finally {
            Closer.ioClose(printWriter);
        }
    }

    public void copyDirectry(File file, File file2) {
        if (file.exists() && file.isFile()) {
            boolean bl = false;
            String string = file.getName();
            if (string.endsWith(".jsp") || string.endsWith(".xml")) {
                try {
                    OGDocument oGDocument = this.read(file);
                    if (oGDocument != null && !this.filters.isEmpty()) {
                        JspParserFilter jspParserFilter;
                        Iterator<JspParserFilter> iterator = this.filters.iterator();
                        while (iterator.hasNext() && (oGDocument = (jspParserFilter = iterator.next()).filter(oGDocument)) != null) {
                        }
                    }
                    if (oGDocument != null) {
                        this.write(file2, oGDocument);
                        bl = true;
                    }
                }
                catch (RuntimeException runtimeException) {
                    System.out.println(runtimeException.getMessage());
                }
            }
            if (!bl) {
                FileUtil.copy(file, file2, true);
            }
            return;
        }
        if (!file2.exists() && !file2.mkdirs()) {
            System.err.println(file2 + " \u306e \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file3 : fileArray) {
                this.copyDirectry(file3, new File(file2, file3.getName()));
            }
        }
    }

    public void addFilter(JspParserFilter jspParserFilter) {
        this.filters.add(jspParserFilter);
    }

    @Override
    public void startDocument() {
        this.stack = new Stack();
        this.ele = new OGDocument();
        ((OGDocument)this.ele).setFilename(this.filename);
        this.idMap = new HashMap<String, OGElement>();
        this.inCDATA = false;
        this.inEntity = false;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        OGElement oGElement = new OGElement(string3, attributes);
        String string4 = oGElement.getId();
        if (string4 != null) {
            this.idMap.put(string4, oGElement);
        }
        this.ele.addNode(oGElement);
        this.stack.push(this.ele);
        this.ele = oGElement;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.inEntity) {
            return;
        }
        String string = this.toText(cArray, n, n2);
        if (this.inCDATA) {
            this.ele.addNode(string);
            return;
        }
        OGNode oGNode = new OGNode(string);
        this.ele.addNode(oGNode);
    }

    @Override
    public void startCDATA() {
        OGNode oGNode = new OGNode();
        oGNode.setNodeType(OGNodeType.Cdata);
        this.ele.addNode(oGNode);
        this.stack.push(this.ele);
        this.ele = oGNode;
        this.inCDATA = true;
    }

    @Override
    public void endCDATA() {
        this.ele = this.stack.pop();
        this.inCDATA = false;
    }

    @Override
    public void startDTD(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder().append("<!DOCTYPE ").append(string);
        if (string2 != null) {
            stringBuilder.append(" PUBLIC \"").append(string2).append('\"');
        }
        if (string3 != null) {
            stringBuilder.append('\"').append(string3).append('\"');
        }
        OGNode oGNode = new OGNode(stringBuilder.toString());
        oGNode.setNodeType(OGNodeType.DTD);
        this.ele.addNode(oGNode);
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void startEntity(String string) {
        String string2 = "&" + string + ";";
        OGNode oGNode = new OGNode(string2);
        this.ele.addNode(oGNode);
        this.inEntity = true;
    }

    @Override
    public void endEntity(String string) {
        this.inEntity = false;
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        String string = this.toText(cArray, n, n2);
        OGNode oGNode = new OGNode(string);
        this.ele.addNode(oGNode);
    }

    @Override
    public void comment(char[] cArray, int n, int n2) {
        String string = this.toText(cArray, n, n2);
        OGNode oGNode = new OGNode(string);
        oGNode.setNodeType(OGNodeType.Comment);
        this.ele.addNode(oGNode);
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.ele = this.stack.pop();
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        String string = sAXParseException.getMessage() + ":" + sAXParseException.getPublicId() + HybsConst.CR + "\t" + this.filename + " (" + sAXParseException.getLineNumber() + ")";
        System.err.println("WARNING:" + string);
    }

    private String toText(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2);
        return string.replaceAll("\n", HybsConst.CR);
    }

    private OGDocument getDocument() {
        OGDocument oGDocument = null;
        if (this.ele != null && this.ele.getNodeType() == OGNodeType.Document) {
            if (this.ele instanceof OGDocument) {
                oGDocument = (OGDocument)this.ele;
                oGDocument.setIdMap(this.idMap);
            } else {
                System.err.println("WARNING:\u3053\u306e\u3001OGNode \u306f\u3001OGDocument \u306e\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
            }
        }
        return oGDocument;
    }

    public static void main(String[] stringArray) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (stringArray.length < 2) {
            System.out.println("Usage: org.opengion.fukurou.xml.JspSaxParser <inFile|inDir> <outFile|outDir> [<JspParserFilter1> \uff65\uff65\uff65 ]");
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        JspSaxParser jspSaxParser = new JspSaxParser();
        if (stringArray.length >= 3) {
            for (int i = 2; i < stringArray.length; ++i) {
                JspParserFilter jspParserFilter = (JspParserFilter)Class.forName(stringArray[i]).newInstance();
                jspSaxParser.addFilter(jspParserFilter);
            }
        }
        jspSaxParser.copyDirectry(file, file2);
    }
}

