/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import java.util.ArrayList;
import java.util.List;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.report2.TagParser;

class OdsSheet {
    private static final String ROW_START_TAG = "<table:table-row ";
    private static final String ROW_END_TAG = "</table:table-row>";
    private static final String SHEET_NAME_START = "table:name=\"";
    private static final String SHEET_NAME_END = "\"";
    private static final String VAR_START = "{@";
    private static final String VAR_END = "}";
    private static final String VAR_CON = "_";
    private static final String LINE_COPY = "LINECOPY";
    private final List<String> sheetRows = new ArrayList<String>();
    private String sheetHeader;
    private String sheetFooter;
    private String sheetName;
    private String origSheetName;
    private String confSheetName;

    OdsSheet() {
    }

    public void analyze(String string, int n) {
        int n2;
        String[] stringArray = TagParser.tag2Array(string, ROW_START_TAG, ROW_END_TAG);
        this.sheetHeader = stringArray[0];
        this.sheetFooter = stringArray[1];
        for (n2 = 2; n2 < stringArray.length; ++n2) {
            this.sheetRows.add(stringArray[n2]);
            this.lineCopy(stringArray[n2], n);
        }
        this.origSheetName = this.sheetName = TagParser.getValueFromTag(this.sheetHeader, SHEET_NAME_START, SHEET_NAME_END);
        this.confSheetName = null;
        if (this.sheetName != null && (n2 = this.sheetName.indexOf("__")) > 0 && !this.sheetName.endsWith("__")) {
            this.confSheetName = this.sheetName.substring(n2 + 2);
            this.sheetName = this.sheetName.substring(0, n2);
        }
    }

    private void lineCopy(String string, int n) {
        int n2 = string.indexOf("{@LINECOPY");
        if (n2 < 0) {
            return;
        }
        int n3 = string.indexOf(VAR_END, n2);
        if (n3 < 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        String string2 = TagParser.checkKey(string.substring(n2 + VAR_START.length(), n3), stringBuilder);
        if (string2 == null || !LINE_COPY.equals(string2)) {
            return;
        }
        int n4 = 1;
        while (n4 < n) {
            final int n5 = n4++;
            String string3 = new TagParser(){

                @Override
                protected void exec(String string, StringBuilder stringBuilder, int n) {
                    String string2 = TagParser.checkKey(string, stringBuilder);
                    if (string2.indexOf(60) >= 0) {
                        String string3 = "[ERROR]PARSE:{@\u3068}\u306e\u6574\u5408\u6027\u304c\u4e0d\u6b63\u3067\u3059\u3002\u5909\u6570\u5185\u306e\u7279\u5b9a\u306e\u6587\u5b57\u5217\u306b\u66f8\u5f0f\u8a2d\u5b9a\u304c\u3055\u308c\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002\u30ad\u30fc=" + string2;
                        throw new HybsSystemException(string3);
                    }
                    stringBuilder.append(OdsSheet.VAR_START).append(OdsSheet.this.incrementKey(string2, n5)).append(OdsSheet.VAR_END);
                }
            }.doParse(stringBuilder.toString(), VAR_START, VAR_END, false);
            this.sheetRows.add(string3);
        }
    }

    private String incrementKey(String string, int n) {
        int n2 = string.lastIndexOf(VAR_CON);
        if (n2 < 0) {
            return string;
        }
        String string2 = string.substring(0, n2);
        int n3 = -1;
        try {
            n3 = Integer.parseInt(string.substring(n2 + VAR_CON.length(), string.length()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n3 < 0) {
            return string;
        }
        return string2 + VAR_CON + n3 + n;
    }

    public String getHeader() {
        return this.sheetHeader;
    }

    public String getFooter() {
        return this.sheetFooter;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public String getConfSheetName() {
        return this.confSheetName;
    }

    public String getOrigSheetName() {
        return this.origSheetName;
    }

    public String[] getRows() {
        return this.sheetRows.toArray(new String[this.sheetRows.size()]);
    }
}

