<?xml version="1.0" encoding="UTF-8"?>
<jsp:root xmlns:jsp="http://java.sun.com/JSP/Page" xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld" version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= ""
	pgid	= "GF2255"
	title	= "DBセット基準"
	date	= "2010/07/24"
	author	= "Auto Create"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck command="{@command}" columns="SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" dbid="{@FROM_DBID}" maxRowCount="{@maxRowCount}">
		select
			A1.SYSTEM_ID,A1.PGID,A1.NMSYORI,A1.SEQ,A1.TABLE_NAME,A1.CLM,A1.MOTO,A1.ADDACT,A1.MODIACT,A1.DELACT
		from GF95 A1
	<og:where>
		<og:and value = "A1.SYSTEM_ID	=	'{@SYSTEM_ID}'"	/>
		<og:and value = "A1.PGID	like	'{@PGID}'"	/>
		<og:and value = "A1.NMSYORI	like	'{@NMSYORI}'"	/>
		<og:and value = "A1.TABLE_NAME	like	'{@TABLE_NAME}'"	/>
		<og:and value = "A1.CLM	like	'{@CLM}'"	/>
		<og:and value = "A1.MOTO	like	'{@MOTO}'"	/>
	</og:where>
	<og:appear startKey = "ORDER BY" value = "{@ORDER_BY}"
			defaultVal = "1,4" />

</og:query>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit value="update" command="COPY" lbl="COPY" accesskey="C"
		keys="noWritable" vals="null" />
	<og:submit value="update" command="MODIFY" lbl="MODIFY" accesskey="M"
		keys="noWritable" vals="CLM" />
	<og:submit value="update" command="DELETE" lbl="DELETE" accesskey="Z"
		keys="columnWritable" vals="null" />
	<og:submit gamenId="GF9110" value="index" dbkeys="SYSTEM_ID,LANG,CLM" command="NEW"
		lbl="GF9100" target="CONTENTS" />
<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
