/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.AbstractEditor;
import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.fukurou.util.TagBuffer;

import static org.opengion.fukurou.util.StringUtil.isNull;				// 6.1.1.0 (2015/01/17)

/**
 * YMD エディターは、カラムのデータを日付(年/月/日)編集する場合に使用するクラスです。
 * YMD2はカレンダーのポップアップボタンが付属するタイプです。
 *
 * このエディタはeventColumnに対応していません。
 *
 *  カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * @og.rev 3.5.6.2 (2004/07/05) 新規作成
 * @og.rev 5.4.3.6 (2012/01/19) コメント修正
 * @og.rev 5.6.5.2 (2013/06/21) ポップアップ変更
 * @og.rev 5.9.4.0 (2016/01/08) type=button追加,背景色transparent
 *
 * @og.group データ編集
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class Editor_YMD2 extends AbstractEditor {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "5.9.4.0 (2016/01/08)" ;

	// 5.6.5.2 (2013/06/21) htmlからjspに変更
	// 6.0.2.5 (2014/10/31) height,width に、"px"を追加
//	private static final String CAL1 = "<button onclick=\"ogPopup('../common/calendar.jsp','250px','265px',null,this,new Array('" ;
	// 5.9.4.0 (2016/01/09) type=button追加
	private static final String CAL1 = "<button type=\"button\" onclick=\"ogPopup('../common/calendar.jsp','250px','265px',null,this,new Array('" ;
	// 4.3.6.7 (2009/05/22) FireFox対応
//	private static final String CAL2 = "'),event); return false;\" style=\"background-color:Beige;border:0px\"><img src=\"../image/calendar.gif\" alt=\"Calendar\"/></button>";
	// 5.9.4.0 背景色transparent
	private static final String CAL2 = "'),event); return false;\" style=\"background-color:transparent;border:0px\"><img src=\"../image/calendar.gif\" alt=\"Calendar\"/></button>";

	/**
	 * デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 *
	 */
	public Editor_YMD2() { super(); }			// PMD:Document empty constructor 対策

	/**
	 * コンストラクター。
	 *
	 * @param	clm	DBColumnオブジェクト
	 */
	private Editor_YMD2( final DBColumn clm ) {
		super( clm );
		tagBuffer.add( XHTMLTag.inputAttri( attributes ) );
	}

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellEditorオブジェクト
	 * @og.rtnNotNull
	 */
	public CellEditor newInstance( final DBColumn clm ) {
		return new Editor_YMD2( clm );
	}

	/**
	 * データの編集用文字列を返します。
	 *
	 * @og.rev 4.3.7.2 (2009/06/15) 属性でidが出力される場合は、idを出力しない
	 *
	 * @param	value 入力値
	 *
	 * @return	データの編集用文字列
	 * @og.rtnNotNull
	 */
	@Override
	public String getValue( final String value ) {
		// 6.1.1.0 (2015/01/17) TagBufferの連結記述
		final String tag = new TagBuffer( "input" )
						.add( "name"	, name )
						.add( "id"		, name , isNull( attributes.get( "id" ) ) )		// 4.3.7.2 (2009/06/15)
						.add( "value"	, value )
						.add( "size"	, size1 )
						.add( tagBuffer.makeTag() )
						.makeTag();

		return tag + CAL1 + name + CAL2 ;
	}

	/**
	 * name属性を変えた、データ表示/編集用のHTML文字列を作成します。
	 * テーブル上の name に 行番号を付加して、名前_行番号 で登録するキーを作成し,
	 * リクエスト情報を１つ毎のフィールドで処理できます。
	 *
	 * @og.rev 4.3.7.2 (2009/06/15) 属性でidが出力される場合は、idを出力しない
	 *
	 * @param	row   行番号
	 * @param	value 入力値
	 *
	 * @return	データ表示/編集用の文字列
	 * @og.rtnNotNull
	 */
	@Override
	public String getValue( final int row,final String value ) {
		final String name2 =  name + HybsSystem.JOINT_STRING + row ;

		// 6.1.1.0 (2015/01/17) TagBufferの連結記述
		final String tag = new TagBuffer( "input" )
						.add( "name"	, name2 )
						.add( "id"		, name2 , isNull( attributes.get( "id" ) ) )		// 4.3.7.2 (2009/06/15)
						.add( "value"	, value )
						.add( "size"	, size2 )
						.add( tagBuffer.makeTag() )
						.makeTag( row,value );

		return tag + CAL1 + name2 + CAL2 ;
	}
}
