/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.resource.ColumnData;

final class ColumnDataLoader {
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");
    private static final String QUERY = "select CLM,CLS_NAME,USE_LENGTH,VIEW_LENGTH,RENDERER,EDITOR,DBTYPE,DATA_DEFAULT,LABEL_CLM,CODE_CLM,CLM_PARAM,RENDERER_PARAM,EDITOR_PARAM,TYPE_PARAM,ROLES,null AS FIELD_SIZE,FGLOAD from GEA03 where SYSTEM_ID in ( ?,'**') and FGJ='1' order by SYSTEM_ID,CLM,KBSAKU";
    private static final String QUERY2 = "select CLM,CLS_NAME,USE_LENGTH,VIEW_LENGTH,RENDERER,EDITOR,DBTYPE,DATA_DEFAULT,LABEL_CLM,CODE_CLM,CLM_PARAM,RENDERER_PARAM,EDITOR_PARAM,TYPE_PARAM,ROLES,null AS FIELD_SIZE,FGLOAD,UNIQ,SYSTEM_ID from GEA03 where SYSTEM_ID in ( ?,'**') and CLM=? and FGJ='1' order by SYSTEM_ID,KBSAKU";
    private static final boolean IS_FGLOAD_AUTOSET = HybsSystem.sysBool("USE_FGLOAD_AUTOSET");
    private static final String UPDATE2 = "update GEA03 set FGLOAD='2' where UNIQ=? and SYSTEM_ID=? and CLM=?";
    private final Map<String, ColumnData> pool = Collections.synchronizedMap(new WeakHashMap());
    private final String SYSTEM_ID;
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;

    ColumnDataLoader(String string, boolean bl) {
        this.SYSTEM_ID = string;
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYSTEM_ID, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("ColumnDataLoader", null, null);
        } else {
            this.appInfo = null;
        }
        if (bl) {
            this.loadDBResource();
        }
    }

    private void loadDBResource() {
        String[] stringArray = new String[]{this.SYSTEM_ID};
        String[][] stringArray2 = DBUtil.dbExecute((String)QUERY, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            if ("1".equals(stringArray2[i][16])) {
                this.pool.put(stringArray2[i][0], new ColumnData(stringArray2[i]));
                continue;
            }
            if (this.pool.get(stringArray2[i][0]) == null) continue;
            this.pool.remove(stringArray2[i][0]);
        }
        System.out.println("  ColumnDataLoader [" + n + "] loaded");
    }

    public ColumnData getColumnData(String string) {
        String[] stringArray;
        String[][] stringArray2;
        ColumnData columnData = this.pool.get(string);
        if (columnData == null && (stringArray2 = DBUtil.dbExecute((String)QUERY2, (String[])(stringArray = new String[]{this.SYSTEM_ID, string}), (ApplicationInfo)this.appInfo, (String)this.DBID)).length > 0) {
            int n = stringArray2.length - 1;
            columnData = new ColumnData(stringArray2[n]);
            this.pool.put(string, columnData);
            if (IS_FGLOAD_AUTOSET) {
                String string2 = stringArray2[n][16];
                String string3 = stringArray2[n][18];
                if (!("1".equals(string2) || "2".equals(string2) || "**".equals(string3))) {
                    String[] stringArray3 = new String[]{stringArray2[n][17], this.SYSTEM_ID, string};
                    DBUtil.dbExecute((String)UPDATE2, (String[])stringArray3, (ApplicationInfo)this.appInfo, (String)this.DBID);
                }
            }
        }
        return columnData;
    }

    public void clear(String string) {
        this.pool.remove(string);
    }

    public void clear() {
        this.pool.clear();
    }
}

