/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.fukurou.xml.XMLFileLoader;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.resource.GUIInfo;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class DirectXMLSaveTag
extends CommonTagSupport {
    private static final String VERSION = "6.4.2.1 (2016/02/05)";
    private static final long serialVersionUID = 642120160205L;
    private String dbid;
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String filename;
    private String displayMsg = "MSG0003";
    private String[] keys;
    private String[] vals;
    private boolean useTimeStamp;
    private boolean useTimeView = HybsSystem.sysBool("VIEW_USE_TIMEBAR");

    @Override
    public int doEndTag() {
        int n;
        Object object;
        Object object2;
        this.debugPrint();
        if (!this.useTag()) {
            return 6;
        }
        long l = System.currentTimeMillis();
        StringWriter stringWriter = new StringWriter();
        String string = HybsSystem.url2dir(this.fileURL, new String[0]);
        File file = this.filename == null ? new File(string) : new File(string, this.filename);
        try {
            object2 = this.getTransaction();
            Throwable throwable = null;
            try {
                object = object2.getConnection(this.dbid);
                XMLFileLoader xMLFileLoader = new XMLFileLoader((Connection)object, this.useTimeStamp);
                if (this.keys != null) {
                    xMLFileLoader.setAfterMap(this.getAfterMap());
                }
                xMLFileLoader.setLogWriter((Writer)stringWriter);
                xMLFileLoader.loadXMLFiles(file);
                int[] nArray = xMLFileLoader.getCRUDCount();
                n = nArray[0];
                object2.commit();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object2 != null) {
                    if (throwable != null) {
                        try {
                            object2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        object2.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            String string2 = "XML\u30d5\u30a1\u30a4\u30eb\u306eLoad\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + CR + throwable.getMessage() + CR + " file=" + file;
            throw new HybsSystemException(string2, throwable);
        }
        if (this.displayMsg != null && this.displayMsg.length() > 0) {
            object2 = new StringBuilder(200).append("<pre>").append(stringWriter.toString()).append(CR).append(HybsSystem.getDate()).append("  ").append(this.getResource().getLabel(this.displayMsg)).append(CR).append("</pre>");
            this.jspPrint(((StringBuilder)object2).toString());
        }
        long l2 = System.currentTimeMillis() - l;
        object = (GUIInfo)this.getSessionAttribute("h_gInfo");
        if (object != null) {
            ((GUIInfo)object).addWriteCount(n, l2, file.getPath());
        }
        if (this.useTimeView) {
            this.jspPrint("<div id=\"queryTime\" value=\"" + l2 + "\"></div>");
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.dbid = null;
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.filename = null;
        this.displayMsg = "MSG0003";
        this.keys = null;
        this.vals = null;
        this.useTimeStamp = false;
        this.useTimeView = HybsSystem.sysBool("VIEW_USE_TIMEBAR");
    }

    private Map<String, String> getAfterMap() {
        if (this.keys == null || this.vals == null) {
            return null;
        }
        if (this.keys.length != this.vals.length) {
            String string = "keys \u3068 vals \u306e\u500b\u6570\u304c\u7570\u306a\u308a\u307e\u3059\u3002 keys=" + Arrays.toString(this.keys) + " vals=" + Arrays.toString(this.vals);
            throw new HybsSystemException(string);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null || this.keys[i].length() <= 0) continue;
            hashMap.put(this.keys[i], this.vals[i]);
        }
        return hashMap;
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.fileURL = StringUtil.urlAppend((String)this.fileURL, (String)string2, (String[])new String[0]);
        }
    }

    public void setFilename(String string) {
        this.filename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.filename);
    }

    public void setDisplayMsg(String string) {
        if (string != null) {
            this.displayMsg = string;
        }
    }

    public void setKeys(String string) {
        this.keys = this.getCSVParameter(string);
    }

    public void setVals(String string) {
        this.vals = this.getCSVParameter(string);
    }

    public void setUseTimeStamp(String string) {
        this.useTimeStamp = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useTimeStamp);
    }

    public void setUseTimeView(String string) {
        this.useTimeView = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useTimeView);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("dbid", (Object)this.dbid).println("fileURL", (Object)this.fileURL).println("filename", (Object)this.filename).println("displayMsg", (Object)this.displayMsg).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

