/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.business;

import org.opengion.fukurou.util.ErrorMessage;

/**
 * パラメーターのみを使用する(メインカーソルを定義しない)業務ロジックの構造を定義します。
 *
 * このクラスでは、以下に示すメソッドが呼び出されるタイミングのみを定義しています。
 * メソッドの中身については、サブクラスでオーバーライドし実装して下さい。
 *
 * 処理が途中で中断される条件は、以下の3つです。
 * ①各メソッドの戻り値がfalseの場合
 * ②チェックメソッド(check())が全ての行で実装された後、エラーメッセージに"エラー"が含まれている場合
 * ③実行時エラーが発生した場合
 *
 *  check()  パラメーターチェック 1回のみ呼び出し
 *  logic()  メイン処理           1回のみ呼び出し
 *
 * @og.rev 5.1.1.0 (2009/12/01) 新規作成
 * @og.group 業務ロジック
 *
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */
public class BizLogic_ENTRY extends AbstractBizLogic {

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 6.4.2.0 (2016/01/29) PMD refactoring. Each class should declare at least one constructor.
	 */
	public BizLogic_ENTRY() {
		super();		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。
	}

	/**
	 * 処理のメインロジックの前処理を記述します。
	 * (ここでは何もしません)
	 *
	 * このメソッド自体は、protected属性であるため、サブクラスから直接参照することができます。
	 * 但し、これは、各業務ロジックで直接参照することを想定したものではなく、BizLogicの
	 * メイン構造を拡張するサブクラスを定義する際に使用することを想定しています。
	 * (この想定がなければ、本来は、package privateにすべきです)
	 * このため、業務ロジックを各実装クラスでは直接参照しないで下さい。
	 */
	@Override
	protected void init() {
		// Document empty method チェック対策
	}

	/**
	 * 処理のメインロジックを記述します。
	 *
	 * このメソッド自体は、protected属性であるため、サブクラスから直接参照することができます。
	 * 但し、これは、各業務ロジックで直接参照することを想定したものではなく、BizLogicの
	 * メイン構造を拡張するサブクラスを定義する際に使用することを想定しています。
	 * (この想定がなければ、本来は、package privateにすべきです)
	 * このため、業務ロジックを各実装クラスでは直接参照しないで下さい。
	 *
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean main() {
		row = 0;

		// 6.4.1.1 (2016/01/16) PMD refactoring. A method should have only one exit point, and that should be the last statement in the method
		// 条件判定注意
		return check() && getKekka() < ErrorMessage.NG && logic();	

//		if( !check() ){ return false;  }
//		if( getKekka() >= ErrorMessage.NG ) {
//			return false;
//		}
//
//		return logic();				// 6.2.6.0 (2015/06/19) refactoring
	}

	/**
	 * チェックロジックを定義します。
	 * ここでは何も実装されていません。
	 *
	 * @return 処理が正常終了したか
	 */
	protected boolean check() {
		return true;
	}

	/**
	 * メイン処理を定義します。
	 * ここでは何も実装されていません。
	 *
	 * @return 処理が正常終了したか
	 */
	protected boolean logic() {
		return true;
	}
}
