/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.develop;

import java.util.Map;
import java.util.List;

import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.xml.JspParserFilter;

/**
 * コンストラクタに引数で与えられたマスタデータ情報を元に、特定のJSPタグ情報を生成する基底クラス。
 * マスタデータ情報はGF92のNMSYORIカラムの種別毎にJspConvertEntityオブジェクトに事前に準備する必要がある。
 *
 * 例)
 * JspConvertEntity e = new JspConvertEntity("RESULT");
 * e.setTableName("GF92");
 * e.setColumnName("NMSYORI");
 *
 *
 * 継承先のクラスのexecuteメソッドでは、引数のマスタデータ情報からJSPタグの文字列を生成する処理を実装します。
 *
 * @author Takeshi.Takada
 *
 */
public final class JspCreateFactory {

	/** 作成するクラスのベースとなる文字列  {@value}	*/
	private static final String CLS_BASE = "org.opengion.plugin.develop.JspCreate_" ;

	/**
	 * プライベート デフォルトコンストラクタ
	 *
	 * このクラスはファクトリクラスであり、インスタンスの作成を禁止します。
	 */
	private JspCreateFactory() {}

	/**
	 * コンストラクタ(メイン)
	 *
	 * 引数のキー文字列を使用して、新しい JspParserFilter オブジェクトを作成します。
	 * 基準文字列は、"org.opengion.plugin.develop.JspCreate_" です。
	 *
	 * @param	key		JspCreate_****の****部分
	 * @param	master	マスタデータ情報のMap
	 *
	 * @return	新しく作成されたJspParserFilter
	 */
	public static JspParserFilter newInstance( final String key , final Map<String,List<JspConvertEntity>> master ) {

		final AbstractJspCreate jspGen = (AbstractJspCreate)StringUtil.newInstance( CLS_BASE + key );

		jspGen.init( master );

		return jspGen ;
	}
}
