/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.html;

/**
 * カレンダー表示クラスで使用する各種キーパラメータを管理している定数クラスです。
 *
 * パラメータのキーとなる値と、初期値を設定しています。
 * すべて、public static final で定義されている為、設定値はドキュメント等で
 * 確認することが可能です。
 * ただし、キー値などを、直書きすることを前提に公開していませんので、
 * 必要であれば、定数として、このクラス経由で使用してください。
 *
 * @og.group その他
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public final class ViewCalendarParam  {

	// 3.5.6.0 (2004/06/18) taglib/ViewCalendarParamTag 用のキー
	/** パラメータキー {@value} */
	public static final String VIEW_KEYS		 = "h_viewKeys"		 ;
	/** パラメータキー {@value} */
	public static final String YM_KEY			 = "h_ymKey"			 ;
	/** パラメータキー {@value} */
	public static final String DAY_KEY			 = "h_dayKey"		 ;
	/** パラメータキー {@value} */
	public static final String VALUE_KEY		 = "h_valueKey"		 ;
	/** パラメータキー {@value} */
	public static final String VALUE_BR_FLAG_KEY = "h_valueBRFlagKey" ;
	/** パラメータキー {@value} */
	public static final String FIRSTWEEK_KEY	 = "h_firstWeek"		 ;
	/** パラメータキー {@value} */
	public static final String HEADER_LOCALE_KEY = "h_headerLocale"	 ;
	/** パラメータキー {@value} */
	public static final String COLUMN_SIZE_KEY	 = "h_columnSize"	 ;

	// 3.5.6.0 (2004/06/18) taglib/ViewCalendarParamTag 用の初期値
	/** パラメータ初期値:{@value} */
	public static final String VIEW_VALUES			= "CDJGS"	;
	/** パラメータ初期値:{@value} */
	public static final String YM_VALUE				= "YYYYMM"	;
	/** パラメータ初期値:{@value} */
	public static final String DAY_VALUE			= "DY"		;
	/** パラメータ初期値:{@value} */
	public static final String VALUE_BR_FLAG_VALUE	= "true"	;
	/** パラメータ初期値:{@value} */
	public static final String FIRSTWEEK_VALUE		= "0"		;
	/** パラメータ初期値:{@value} */
	public static final String HEADER_LOCALE_VALUE	= "en"		;
	/** パラメータ初期値:{@value} */
	public static final String COLUMN_SIZE_VALUE	= "3"		;

	/**
	 * デフォルトコンストラクター
	 * 定数クラスなので、オブジェクトを生成できないように、private にしておきます。
	 *
	 * @og.rev 6.4.2.0 (2016/01/29) PMD refactoring. Each class should declare at least one constructor.
	 */
	private ViewCalendarParam() {
		super();		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。
	}
}
