/* Warning: Please carry out the opening save of this file by UTF-8. */

//Copy From http://msdn.microsoft.com/library/default.asp?url=/workshop/author/dhtml/overview/browserdetection.asp
// Returns the version of Internet Explorer or a -1
// (indicating the use of another browser).
function getInternetExplorerVersion() {
  var rv = -1 , ua , re ;					// Return value assumes failure
  if (navigator.appName == 'Microsoft Internet Explorer')  {
	ua = navigator.userAgent;
	re	= new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");
	if (re.exec(ua) != null)
	  rv = parseFloat( RegExp.$1 );
  }
  return rv;
}

// Global variables
var isCSS, isW3C, isIE4, isNN4, isIE6CSS;
// Initialize upon load to let all browsers establish content objects
function initDHTMLAPI() {
	if (document.images) {
		isCSS = (document.body && document.body.style) ? true : false;
		isW3C = (isCSS && document.getElementById) ? true : false;
		isIE4 = (isCSS && document.all) ? true : false;
		isNN4 = (document.layers) ? true : false;
		isIE6CSS = (document.compatMode && document.compatMode.indexOf("CSS1") >= 0) ? true : false;
	}

	__bInitDhtmlApi = true;
}
// Set event handler to initialize API
//window.onload = initDHTMLAPI;
var __bInitDhtmlApi = false;

// Return the available content width space in browser window
function getInsideWindowWidth() {
	if (window.innerWidth) {
		return window.innerWidth;
	} else if (isIE6CSS) {
		// measure the html element's clientWidth
		return document.body.parentElement.clientWidth;
	} else if (document.body && document.body.clientWidth) {
		return document.body.clientWidth;
	}
	return 0;
}

// Return the available content height space in browser window
function getInsideWindowHeight() {
	if (window.innerHeight) {
		return window.innerHeight;
	} else if (isIE6CSS) {
		// measure the html element's clientHeight
		return document.body.parentElement.clientHeight;
	} else if (document.body && document.body.clientHeight) {
		return document.body.clientHeight;
	}
	return 0;
}

function addEvent(element, eventType, fn, useCapture) {
	if (element.addEventListener) { // W3C DOM Standard - FireFox ...
		useCapture = ((useCapture) ? true : false);
		element.addEventListener(eventType, fn, useCapture);
		return true;
	}
	else if (element.attachEvent) { // Internet Explorer
//		var r = element.attachEvent('on' + eventType, fn);
//		return r;
		return element.attachEvent('on' + eventType, fn);
	}
	else {
		element['on'+eventType] = fn;
	}
}

/* Focus is moved to the first object of the element.  */
/* 3.1.1.0 (2003/03/28) When the first element is a button, focus is not applied.  */

var _sCompat_ = document.compatMode;
// var bIsBackCompat = ( "BackCompat" == _sCompat_ );
var bIsCSS1Compat = ( "CSS1Compat" == _sCompat_ );

/* 3.5.6.4 (2004/07/16) Focus is appropriated to the selection check box. */
/* 3.6.0.0 (2004/09/17) One focus of the selection check is appropriated ahead by h_focus. */
/* 3.7.0.3 (2005/02/25) Correspondence of setScrollRowNo. two or more h_focus appears.	*/
/* 3.7.0.4 (2005/03/14) Correspondence when the first line is checked.	*/
/* 3.8.0.3 (2005/07/15) New Header Fix Type Add  */
/* 3.8.6.3 (2006/11/30) h_focus scrollLeft	*/
/* 3.8.8.1 (2007/01/06) Old Header Fix Type scrollTop offset -25 */
/* 5.1.1.1 (2009/12/02) ヘッダーに改行が含まれている場合に正しく表示されないバグを修正 */
/* 5.1.8.0 (2010/07/01) oLayerが存在しない場合にエラーが発生するバグを修正 */
/* 5.3.2.0 (2011/02/01) ヘッダー固定しない状態で左右分割ガントを表示した際に右Viewの自動フォーカスが動かないバグを修正 */
function focus2() {
	var fcu , oMySelf , oTr, oLayer, oDiv, oRun , oTHeads , iTHeadHeight , oDivHeader;

	fcu = document.getElementsByName( "h_fcs" );
	if( fcu.length > 0 ) {
		oMySelf = fcu[0];

		oRun = oMySelf.parentNode;
		while(oRun) {
			if(oRun.tagName == "TR" ) oTr = oRun;
			if(oTr && oRun.tagName == "DIV") {
				if(oRun.id == "layer") oLayer = oRun;
//				if(oRun.id == "X1" || oRun.id == "X2") { oDiv = oRun; break; }
				if(oRun.id == "X1" || oRun.id == "X2") {
					oDiv = oRun;
					if( !oDiv.HSibling ) {
						oDiv.HSibling = document.getElementById( ( oRun.id == "X1" ? "X2" : "X1" ) );
					}
					break;
				}
			}
			oRun = oRun.parentNode;
		}

		// 5.1.1.1 (2009/12/02)
		// 5.1.8.0 (2010/07/01) oLayerが存在しない場合にエラーが発生するバグを修正
//		var oTHeads = oLayer.getElementsByTagName("THEAD");
		oTHeads = ( oLayer ? oLayer.getElementsByTagName("THEAD") : null );
		iTHeadHeight = ( oTHeads && oTHeads.length > 0 ? oTHeads[0].offsetHeight + 5 : 0 );

		if(oLayer) {
//			var oTHeads = oLayer.getElementsByTagName("THEAD");
//			var oDivHeader;
			if(oTHeads.length >0 && oTHeads[0].id == "divheader") oDivHeader = oTHeads[0];
			if(oDivHeader) {
				//Set Expression Style Header Fixed(compatible with old version)
				oMySelf.scrollIntoView( true );
				if( oLayer.scrollTop >= oDivHeader.offsetHeight ) {		// 3.8.0.3
						oLayer.scrollTop -= oDivHeader.offsetHeight;
				}
			}
			else {
				//Div Style Header Fixed)
				oLayer.scrollIntoView( true );
				// oLayer.scrollTop = oTr.offsetTop;
//				oLayer.scrollTop = Math.max( oTr.offsetTop - 5, 0 );
				oLayer.scrollTop = Math.max( oTr.offsetTop - iTHeadHeight, 0 );
				// HSibling : 左右分割の意味
				// if(oLayer.HSibling) oLayer.HSibling.scrollTop = oTr.offsetTop;
//				if(oLayer.HSibling) oLayer.HSibling.scrollTop = Math.max( oTr.offsetTop - 5, 0 ); // 4.3.5.3 (2009/02/22)
				if(oLayer.HSibling) oLayer.HSibling.scrollTop = Math.max( oTr.offsetTop - iTHeadHeight, 0 ); // 5.1.1.1 (2009/12/02)
			}
		}
		else if(oDiv) {
			//Gantt Scroll
			oDiv.scrollIntoView( true );
			// oDiv.scrollTop = oTr.offsetTop;
//			oDiv.scrollTop = Math.max( oTr.offsetTop - 5, 0 );
			oDiv.scrollTop = Math.max( oTr.offsetTop - iTHeadHeight, 0 );
			// HSibling : 左右分割の意味
			// if(oDiv.HSibling) oDiv.HSibling.scrollTop = oTr.offsetTop;
//			if(oDiv.HSibling) oDiv.HSibling.scrollTop = Math.max( oTr.offsetTop - 5, 0 ); // 4.3.5.3 (2009/02/22)
			if(oDiv.HSibling) oDiv.HSibling.scrollTop = Math.max( oTr.offsetTop - iTHeadHeight, 0 ); // 5.1.1.1 (2009/12/02)
		}
		else {
			//Unspecified Table View
			// 5.1.8.0 (2010/07/01) oLayerが存在しない場合にエラーが発生するバグを修正
			if( oTr ) {
				window.scrollTo( 0,oTr.offsetTop );
			}
			else {
				oMySelf.scrollIntoView( true );
			}
		}
	}
}

/* 3.5.4.0 (2003/11/25) */
function historyBack() {
	var oAllForms , f , i , obj ;

	oAllForms = document.getElementsByTagName("FORM");
	if ( oAllForms.length > 0 ) {
		f = oAllForms[0];
		for ( i = 0; i < f.elements.length; i++) {
			obj = f.elements[i];
			if ( obj != null && obj.name == "historyBack" ) {
				if( obj.value == "1" ) {
					obj.value = "0";
					f.submit();
				}
				else {
					obj.value = "1";
				}
				break;
			}
		}
	}
}

/*
 *	The image is replaced.
 *
 *	  <a href="http://xxxxx"
 *			onMouseOver="changeImage('img01','over.gif')"
 *			onMouseOut ="changeImage('img01','up.gif')"  >
 *		<img src="up.gif" alt="IMG" border="0" name="img01">
 *	</a>
 */
function changeImage( id,src ) {
	document.images[id].src = src;
}

/*
 * 3.3.3.0 (2003/07/09) Double registration prevention of data by pushing twice
 *
 *	<form method="POST" action="forward.jsp" target="RESULT"
 *								onSubmit="return oneClick();">
 *								~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 *	・・・
 *	</form>
 */
var isClicked = false;
function oneClick() {
	if(isClicked) {
//		alert( "Don't twice pushed." );
		alert( "Don't click twice." );
		return false;
	} else {
		isClicked = true;
		return true;
	}
}

/*
 * 3.5.0.0 (2003/09/17) It submits it.
 *
 *	renew( action ,target,[this] );
 *
 *	 <og:column name="KBSAKU" onChange="renew('query.jsp','QUERY');" />
 *	 <og:column name="KBSAKU" onChange="renew('query.jsp','QUERY',this);" />
 *
 * Ver 3.8.6.3 (2006/11/30) Self form submit when this argment add.
 */
function renew( action , target , home ) {
	var f = null , oAllForms;

	if( home != null ) {
		f = home.form;
	}
	else {
		oAllForms = document.getElementsByTagName("FORM");
		if ( oAllForms.length > 0 ) {
			f = oAllForms[0];
		}
	}

	if( f != null ) {
		f.action= action ;
		f.target= target ;

		f.submit();
	}
}

/*
 * 3.5.4.2 (2003/12/15)
 *	The function to move the input cursor to the following field automatically is added.
 *
 * nextForm( this, nextFieldName, maxLength )
 *
 * 3.5.5.9 (2004/05/31) Correspondence to there are two or more attributes name (Example: Button etc.) the same
 * 3.8.1.2 (2005/12/19) The matter where focus cannot be moved to the pull-down menu is corrected.
 *
 *	 <og:column name="A" nextForm="B" />  ⇒ <input type="text" name="A" onKeyUp="nextForm(this, 'B', 3)" maxlength="3" />
 *	 <og:column name="B" nextForm="C" />  ⇒ <input type="text" name="B" onKeyUp="nextForm(this, 'C', 5)" maxlength="5" />
 *	 <og:column name="C" /> 				 <input type="text" name="C" maxlength="3" />
 */
function nextForm( tx, nm, maxlen ) {
	if( tx.value.length >= maxlen ) {
		var e = tx.form.elements[nm];
//		if( e[0] != null ) {
		if( e[0] != null && e[0].name != null ) {
			e[0].focus();
		}
		else if( e != null ) {
			e.focus();
		}
		else {
			alert( "There is no field named [" + nm + "]" );
		}
	}
}

/*
 * 3.5.4.3 (2004/01/05) Function to select all checks of check box.
 * 3.5.4.8 (2004/02/10) Correspondence when multiple form is arranged in the same page
 *
 * When selectedType of viewFormTag is only CHECKBOX, it is possible to use it.
 *
 *	 <input type="checkbox" name="ALL_CHECK" onClick="checkbox(this);" />
 */
function checkbox( cb ) {
	var f , eles , elesLen , i , el ;

	f = cb.form;
	if (f != null) {
		eles	= f.elements ;
		elesLen = eles.length;
		for ( i=0; i<elesLen; i++ ){
			el = eles[i];
	//		if ( el.name == "h_rowSelected" || el.name == "ALL_CHECK" ) {
			if ( el.name == "h_rowSel" || el.name == "ALL_CHECK" ) {
				 el.checked = cb.checked ;
			}
		}
	}
}

/*
 * The pull-down menu that reacts to the key input of two or more character strings is added.
 *
 * When the number of input items is 20 or more, it is set by the automatic operation.
 *
 * 3.5.4.8 (2004/02/23) 新規作成
 * 6.0.4.0 (2014/11/28) setKeySelect で、ラベルでも、値でも選択できるようにする。
 *
 *	<og:select name="TABLE_NAME" optionAttributes="onkeydown='setKeySelect(this);'" >
 *	<select name="XXX" onkeydown="setKeySelect(this);" >････
 */
var EMPTY_STR = "";
var strOldKey  = EMPTY_STR;
var oOldSelect = null;
var BACKSPACE_CODE = 8;

function clearOldKey() {
	strOldKey  = EMPTY_STR;
}

function setKeySelect(oMySelect) {
	var bFound , oOptions , nCode , bProcessKey , bIsArrayKey , strKey , strOldKey2 , nIndex , nKeyLen ;

	bFound	= false;
	if( oOldSelect != oMySelect ) {
		strOldKey  = EMPTY_STR;
		oOldSelect = oMySelect;
		//Clear Old Data
		if(null == oMySelect.onblur) oMySelect.onblur = clearOldKey;
	}

	oOptions = oMySelect.options;
	nCode = event.keyCode;

	// ((nCode >= 0x25) && (nCode <= 0x28))   Arrow Key
	// ((nCode >= 0x30) && (nCode <= 0x5A))   Number and Alpha
	// ((nCode >= 0x60) && (nCode <= 0x69))   Numpad
	// ((nCode >= 0x6A) && (nCode <= 0x6F))   Numpad * + ent - . /
	bProcessKey = (   ((nCode >= 0x25) && (nCode <= 0x28))
					||	((nCode >= 0x30) && (nCode <= 0x5A))
					||	((nCode >= 0x60) && (nCode <= 0x69))
					||	(BACKSPACE_CODE == nCode) );
	if( bProcessKey) {
		bIsArrayKey = (((nCode >= 0x25 ) && (nCode <= 0x28)) && !event.shiftKey);
		if(!bIsArrayKey) {
//			var strKey ;
			if( 0x5A >= nCode)	{ strKey = String.fromCharCode(nCode).toUpperCase(); }
			else				{ strKey = String.fromCharCode(nCode - 0x30);		 }

//			var strOldKey2;
//			var nIndex;
			if( BACKSPACE_CODE == nCode) {
				strOldKey2 = ((0 < strOldKey.length) ? strOldKey.substr(0, strOldKey.length -1) : EMPTY_STR);
			}
			else {
				strOldKey2 = strOldKey + strKey;
			}
			nKeyLen = strOldKey2.length;

			for ( nIndex = 0; nIndex < oOptions.length; nIndex++) {
				// 6.0.4.0 (2014/11/28)
				if( strOldKey2 == oOptions(nIndex).text.substr(0, nKeyLen).toUpperCase() ||
					strOldKey2 == oOptions(nIndex).value.substr(0, nKeyLen).toUpperCase() ) {
					bFound = true;
					break;
				}
			}

			if( bFound ) {
				strOldKey = strOldKey2;
				if( oMySelect.selectedIndex != nIndex ) { oMySelect.selectedIndex = nIndex; }
			}

			event.returnValue = false;
		}
		else {
			strOldKey = EMPTY_STR;
		}
	}

	return bFound;
}

/*
 * 3.5.6.2 (2004/07/04) Window opens.
 * The event is received, and new window is opened at the clicked position.
 *
 * window_open( url,evt,name,opt )
 *	 url  : Opening URL is specified.
 *	 evt  : When the number of cases is a little, height is adjusted, and the scroll bar is displayed.
 *	 name : It is a name when the value is returned.
 *	 opt  : It is an option for the opening of window.
 *
 *	The following examples are samples of the calendar assistance menu.
 *
 *	TEST1:<input type="text" name="TEST1"  id="TEST1"  size="10" maxlength="8" value="20040201" />
 *	<img src="calendar.gif" onclick="window_open('../common/calendar.html', event,'TEST1','width=220,height=170,resizable=no' );" />
 *
 */
function window_open( url,evt,name,opt ){
	var option , move;

	option = opt;
	if( evt != null ) {
		move = 'left=' + evt.x + ',top=' + evt.y ;
		if( option != null ) {
			option += ',' + move ;
		}
	}

	window.open( url, name, option );
}

/*
 * 3.8.0.8 (2005/10/03) Adjust Frame Height.(Option)
 * 3.8.6.1 (2006/10/20) SUB_FRAME Object get method changed.
 * 3.8.9.1 (2007/06/15) Correspondence of case with frame division into three or more.
 * 4.3.6.0 (2009/04/01) 3つ以上フレームが存在する場合でも自動調整できるように対応
 * 5.1.4.0 (2010/03/01) 横スクロールが出る場合及びFireFoxに対しての自動調整対応
 * 5.5.3.4 (2012/06/19) 上下分割で、下部の左右分割時（３フレームと認識）の処理に対応。
 */
function adjustFrameHeight() {
	var oFramesets , subFrmObj , oFrames , tempRows , endMarkObj , i , sw , cw , isFF , margin ;
	oFramesets = parent.document.getElementsByName( "SUB_FRAME" );
	if( oFramesets == null ) {  return; }

	subFrmObj  = null ;
	oFrames = null;
	if( oFramesets.length == 1 ) {
		subFrmObj = oFramesets[0];
		oFrames = parent.frames;
	}

	if( subFrmObj == null || subFrmObj.rows == null || subFrmObj.rows.length == 0
		|| oFrames == null || oFrames.length == 0 ) { return; }

	var origRows = subFrmObj.rows.split(",");
	tempRows = null;
	endMarkObj = null;
	var size = Math.min( origRows.length , oFrames.length );	// T字型フレーム分割時の処理
//	for( i=0; i<oFrames.length-1; i++ ) {
	for( i=0; i<size-1; i++ ) {
		endMarkObj = oFrames[i].document.getElementById( "END_MARKER" );
		if( endMarkObj == null ) {
			return;
		}
		else {
			sw = oFrames[i].document.documentElement.scrollWidth;
			cw = oFrames[i].document.documentElement.clientWidth;
			isFF = ( /a/[-1]=='a' );
			margin = 5;
			if( isFF || sw != cw ) { margin += 14; }
			tempRows = tempRows + ( endMarkObj.offsetTop + endMarkObj.parentNode.offsetTop + margin ) + ",";
//			tempRows = tempRows + ( oFrames[i].document.documentElement.scrollHeight + margin ) + ",";
		}
	}
	tempRows = tempRows + "*";

	subFrmObj.rows = tempRows;
}

/*
 * これは、フレームを左右分割した場合に、右側フレームのサイズを自動調整します。
 * 
 * 実行したいJSP画面で、呼び出してください。
 * 基本的には、Type5:一覧検索登録 パターンで使用します。
 * 
 * 5.5.3.4 (2012/06/19) Adjust Frame Width.(Option)
 */
function adjustFrameWidth() {
	var resFrameset , resFrmObj , oFrames , i , width;
	resFrameset = parent.document.getElementsByName( "RES_FRAME" );
	if( resFrameset == null ) {  return; }

	resFrmObj  = null ;
	oFrames = null;
	if( resFrameset.length == 1 ) {
		resFrmObj = resFrameset[0];
		oFrames = parent.frames;
	}

	if( resFrmObj == null || resFrmObj.cols == null || resFrmObj.cols.length == 0
		|| oFrames == null || oFrames.length == 0 ) { return; }

	for( i=0; i<oFrames.length; i++ ) {
		if( oFrames[i].name == "UPDATE" ) {
			sw = oFrames[i].document.documentElement.scrollWidth;
	//		cw = oFrames[i].document.documentElement.clientWidth;

			width = sw + 2;			// +2 は、気持ち程度
			resFrmObj.cols = "*," + width ;
			return ;
		}
	}
}

/*
 * 3.8.5.0 (2006/03/06) Adjust Textarea Auto Rows Size.
 *
 * autoArea( Textarea_Object,[MaxRowsSize] )
 *
 * <textarea id="area1" cols="80" rows="10" onKeyup="autoArea( this );"    ></textarea>
 * <textarea id="area2" cols="80" rows="5"	onKeyup="autoArea( this,20 );" ></textarea>
 *
 */
var initRow = new Object();

function autoArea( ara,maxRow ) {
	var text , cnt , idx ;

	if( ara == null ) { return; }
	if( initRow[ara.name] == null ) { initRow[ara.name] = ara.rows; }

	if( isCntAction( event.keyCode )  ) {
		text = ara.value ;
		cnt = 1;
		idx = text.indexOf( '\n' );
		while( idx >= 0 ) {
			cnt++ ;
			idx = text.indexOf( '\n' ,idx+1 );
		}
		if( cnt < initRow[ara.name] ) { cnt = initRow[ara.name]; }
		if( maxRow != null && cnt > maxRow ) { cnt = maxRow; }
		ara.rows = cnt;
	}
}

/*
 * 3.8.5.0 (2006/03/06) Adjust Textarea Auto Rows Size. sub function
 *
 * isCntAction( val )
 */
function isCntAction( val ) {
	return ( 	val == 13		// enter(10key)
			 || val == 14		// return
			 || val == 8		// back space
			 || val == 46		// del
			 || val == 67		// ctlr + C
			 || val == 86		// ctlr + V
			 || val == 88		// ctlr + X
			 ) ;
}

/*
 * 3.8.5.0 (2006/03/20) fieldset display ON/OFF Function.
 * 3.8.5.2 (2006/05/31) fieldset default ON/OFF hidden out.
 */
function hide( id,hiddenKey ) {
	var obj , obj2 , obj3 , i ;

	obj = document.getElementById( id + 'A' );
	if( obj != null ) {
		obj2 = document.getElementById( id + 'B' );
		obj3 = null;
		if( hiddenKey != null ) {
			obj3 = document.getElementsByName( hiddenKey );
		}

		if( obj.style.display == 'none' ) {
			obj.style.display = 'inline';
			if( obj2 != null ) { obj2.innerHTML = '- ' ; }
			if( obj3 != null ) {
				for( i=1; i<obj3.length; i++ ){
					obj3[i].value = "false" ;
				}
			}
		}
		else {
			obj.style.display = 'none';
			if( obj2 != null ) { obj2.innerHTML = '+ ' ; }
			if( obj3 != null ) {
				for( i=1; i<obj3.length; i++ ){
					obj3[i].value = "true" ;
				}
			}
		}
	}
	adjustFrameHeight();
}

/*
 * 3.8.5.3 (2006/06/30) replace All Text
 *
 * <input name="XXX" value="YYY" onBlur="value=replaceText(value,'-','');" />
 */
function replaceText( val,oldTxt,newTxt ) {
	var rtn = val ;
	if( rtn != null ) {
		while( rtn.indexOf( oldTxt ) >= 0 ) {
			rtn = rtn.replace( oldTxt,newTxt );
		}
	}
	return rtn;
}

/*
 * 3.8.6.1 (2006/10/24)
 */
function getDimensions(obj){
	var _width , _height , _top , _left ;

	_width	= obj.offsetWidth;
	_height = obj.offsetHeight;
	_top  = 0;
	_left = 0;
	for (; obj != null; obj = obj.offsetParent) {
		_top += obj.offsetTop;
		_left += obj.offsetLeft;
	}
	return {top:_top, left:_left, width:_width, height:_height};
}

function getClientHeight() {
	var nClientHeight = 0;
	if( bIsCSS1Compat ) {
		nClientHeight =document.documentElement.clientHeight;
	}
	else {
		nClientHeight =document.body.clientHeight;
	}

	return nClientHeight;
}

function getClientWidth() {
	var nClientWidth = 0;
	if( bIsCSS1Compat ) {
		nClientWidth =document.documentElement.clientWidth;
	}
	else {
		nClientWidth =document.body.clientWidth;
	}

	return nClientWidth;
}

/* Dummy function */
function hilightRow() {
	return ;
}

/*
 * 4.3.1.0 (2008/09/03)
 *
 * for prev,next
 */
function submitPrevNextForm( val ) {
	var frm , cmd ;

	frm = document.forms[0];
	cmd = document.getElementById("h_cmd");
	if( frm != null && cmd != null ) {
		cmd.value = val;
		frm.submit();
		cmd.value = "NEW";
	}
	return false;
}

/*
 * 4.3.6.0 (2009/04/01)
 *
 * for expand menu
 * @param evt event
 * @param trg trigger (this)
 * @param hiddenClass target class name
 */
function hideClass( evt, trg, hiddenClass, imgA, imgB ){
	atsrc = $(trg).attr("src");
	if(atsrc.indexOf( imgA ) >= 0){
		$(trg).attr("src",atsrc.replace( imgA, imgB ));
	} 
	else{
		$(trg).attr('src',atsrc.replace( imgB ,imgA ));
	}
	$('.'+hiddenClass).toggle();
	adjustFrameHeight();
}

/*************************************************************************************
 * 各JavaScriptからイベント(主にカラムに割り当てられたイベント)を登録します。
 *
 * 内部的には、セレクタ毎に、イベントを配列で保持することで、後のイベント発動時の
 * セレクタ処理時間を短縮しています。
 *
 * @og.rev 5.2.0.0 (2010/09/01) 新規作成
 *
 * @param String   イベントを登録する要素のセレクタ文字列
 * @param String   バインドするイベント
 * @param function イベント発生時に実行する関数
 * @param String   (任意指定)イベントを登録するセレクタに対して、さらに要素を絞り込むためのフィルター
 * @param boolean  (任意指定)イベントバインド時にイベントを実行するかどうか (初期値:false)
 * @param function (任意指定)イベントのバインド直前に、実行する関数を指定します。
 * Revision: $Id$
 *************************************************************************************/
var ogEvents = new Object();
function setEvent() {
	var thisSelector , thisEvent , thisFunction , thisFilter , isFire , bFunc ;

	thisSelector	= arguments[0];
	thisEvent 		= arguments[1];
	thisFunction	= arguments[2];
	thisFilter		= arguments[3];
	isFire			= arguments[4];
	bFunc			= arguments[5];
	if( ogEvents[thisSelector] == null ) {
		ogEvents[thisSelector] = new Array();
	}
	ogEvents[thisSelector][ogEvents[thisSelector].length]
		= { 'event': thisEvent, 'function': thisFunction, 'filter': thisFilter, 'fire': isFire, 'bindFunc': bFunc };
}

/*************************************************************************************
 * 各JavaScriptで登録されたイベント(主にカラムに割り当てられたイベント)を
 * 実際のイベントハンドラにバインドします。
 *
 * @og.rev 5.2.0.0 (2010/09/01) 新規作成
 *
 * @param jQueryObject (任意指定)イベント登録を走査する要素の集合(指定しない場合、
 *					   ドキュメント全体に対して走査されます。
 * Revision: $Id$
 *************************************************************************************/
var endInitEvent = false;
function bindEvents() {
	var ogSelector , jEle , evList , isFire , jEleTmp , i , j ;

	for( ogSelector in ogEvents ) {
		jEle = arguments[0] ? arguments[0].find( ogSelector ) : $( ogSelector );
		evList = ogEvents[ogSelector];
		isFire = false;
		for( i=0; i<evList.length; i++ ) {
			if( evList[i]["bindFunc"] ) { evList[i]["bindFunc"](); }

			jEleTmp = evList[i]["filter"] ? jEle.filter( evList[i]["filter"] ) : jEle;
			jEleTmp.bind( evList[i]["event"], evList[i]["function"] );
			if( evList[i]["fire"] ) {
				isFire = true;
				for( j=0; j<jEleTmp.length; j++ ) {
					$(jEleTmp[j]).triggerHandler( evList[i]["event"] );
				}
			}
		}
	}
	endInitEvent = true;
}

/*************************************************************************************
 * イベントハンドラに登録されたイベントの初期実行が終わっているかどうかを返します。
 *
 * @og.rev 5.2.0.0 (2010/09/01) 新規作成
 *
 * Revision: $Id$
 *************************************************************************************/
function isEndInitEvent() { return endInitEvent; }

/************************************************************************************/
/* 旧 inputMenu.js の内容を移植 5.2.1.0 (2010/10/01) 								*/
/*																					*/
/* @og.rev 5.6.3.0 (2013/04/01) changeイベント発生									*/
/* Revision: $Id$																	*/
/************************************************************************************/
function selChanged(sel) {
	var text = sel.textObj;
	text.value = sel.options[sel.selectedIndex].value;
	if( text.value == "" ) {
		text.value = sel.options[sel.selectedIndex].text;
	}
	// 5.6.3.0 (2013/04/01)
	$(text).change();
//	  sel.selectedIndex = -1;
}

// function getDimensions(obj){
// 	var _width	= obj.offsetWidth;
// 	var _height = obj.offsetHeight;
// 	var _top = 0, _left = 0;
// 	for (; obj != null; obj = obj.offsetParent) {
// 		_top += obj.offsetTop;
// 		_left += obj.offsetLeft;
// 	}
// 	return {top:_top, left:_left, width:_width, height:_height};
// }

// Ver 3.8.9.2 (2007/07/13) setTimeout 100 -> 200 ms
function makeInputMenu(id) {
	var text , sel , tid , w , dim , dim2 ;

	text = document.getElementById(id);
	sel  = document.getElementById(id+".sel");

//	var tid;
	//if( text.offsetWidth == 0 ) {
	if( !text.setSel ) {
		text.setSel = true;
		tid = setTimeout( "makeInputMenu('" + id + "')",200 );	// 100 -> 200 ms
		return ;
	}
	// 2009/06/09 - Comment Out
	//clearTimeout( tid );

	// w = text.offsetWidth - 15 + "px";
	w = text.offsetWidth - 18 + "px";		// 2011/12/07 -3px 
	sel.style.position = "absolute";		// JyunBAN ga Jyuyo
	sel.style.width  = text.offsetWidth + "px";
	sel.style.height = text.offsetHeight + "px";
	dim  = getDimensions(text);
	dim2 = getDimensions(sel.offsetParent);
	sel.style.left = dim.left - dim2.left + "px";
	sel.style.top  = dim.top  - dim2.top + "px";
	sel.style.clip = "rect(auto auto auto "+w+")";
	sel.textObj = text;
	sel.selectedIndex = -1;
}

/************************************************************************************/
/* 旧 ogPopup.js の内容を移植 5.2.1.0 (2010/10/01) 									*/
/*																					*/
/* 3.8.6.1 (2006/10/20) 															*/
/* POPUP画面起動用標準Function(TS より寄贈) 										*/
/* Modified: 2009/05/15 Extend to Firefox											*/
/* ポップアップ画面から値を渡し、ウィンドウを閉じる(ogPopup と同時使用)				*/
/* <og:view ････ popupReturnKeys = "SYSTEM_ID,CLM,NAME_JA" />						*/
/* 5.2.1.0 (2010/10/01) 															*/
/*   height,width は、px 単位が付いているものとして扱う								*/
/* 5.5.1.5 (2012/04/12)	[0]が_RENEWなら[1]をRENEWで呼び出し							*/
/* Revision: $Id$																	*/
/*	6.4.6.1 (2016/06/03) iframeポップアップで、親を探して戻り値をセットする			*/
/************************************************************************************/
function rtnPopup( rtnValue ) {
//	window.returnValue = rtnValue;

	if( parent ){ 
		parent.window.returnValue = rtnValue;
	}
	else{
		window.returnValue = rtnValue;
	}
	window.close();
}

/********************************************************************/
/* TS POPUP画面起動用標準Function()									*/
/*	引数0：POPUP PGID												*/
/*	引数1：POPUP 高(px)												*/
/*	引数2：POPUP 幅(px)												*/
/*	引数3：入力の引数(1,2をｾｯﾄに複数可能)							*/
/*				1:key	･･･ 呼出先画面のｶﾗﾑ名						*/
/*				2:value ･･･ 呼出元画面の値							*/
/*	引数4：this														*/
/*	引数5：出力の引数(KEY1,KEY2,・・)								*/
/*																	*/
/*	【例1】返り値が不要なケース										*/
/*		<og:popup gamenId="GEXXXX" href="popup.jsp"					*/
/*			keys="SYSTEM_ID,CLM,NAME_JA"							*/
/*			vals="{@SYS.SYSTEM_ID},CLM.value,NAME_JA.value" />		*/
/*																	*/
/*	【例2】返り値が通常のテキストフィールドのケース					*/
/*		<og:popup gamenId="GEXXXX" href="popup.jsp"					*/
/*			keys="SYSTEM_ID,CLM,NAME_JA"							*/
/*			vals="{@SYS.SYSTEM_ID},CLM.value,NAME_JA.value"			*/
/*			rtnKeys="SYSTEM_ID,CLM,NAME_JA" />						*/
/*																	*/
/*	【例3】一覧表示の行単位に値を設定するケース						*/
/*		<og:viewMarker command="{@command}" isRenderer="false">		*/
/*			<og:popup column="PUP" href="popup.jsp" 				*/
/*					keys="SYSTEM_ID,CLM,NAME_JA" 					*/
/*					vals="[SYSTEM_ID],[CLM].value,[NAME_JA].value"	*/
/*					rtnKeys="SYSTEM_ID,CLM,NAME_JA" />				*/
/*		</og:viewMarker>											*/
/*																	*/
/*	5.1.7.0 (2010/06/01) 引数にコマンドを追加						*/
/*	5.7.5.0 (2014/04/04) サイズ変更できるように resizable:on;追加	*/
/*	6.0.2.5 (2014/10/31) height,width で、"px" がなければ追加		*/
/*	6.1.0.0 (2014/12/26) ヘッダー固定のBulkSet対応					*/
/*	6.1.0.0 (2014/12/26) height,width の "px" 処理の修正			*/
/*	6.1.1.0 (2015/01/17) BulkSet対応バグ修正						*/
/*	5.8.5.0 (2015/03/06) ポップアップの戻り値をキャレット位置に追記	*/
/*	6.4.6.1 (2016/06/03) ポップアップの戻り値を引数に追加			*/
/********************************************************************/

// function ogPopup( p_pgid,p_height,p_width,p_in_Array,p_this,p_out_Array,event ) {
// function ogPopup( p_pgid,p_height,p_width,p_in_Array,p_this,p_out_Array,command,event ) {
function ogPopup( p_pgid,p_height,p_width,p_in_Array,p_this,p_out_Array,command,p_append,event ) {
	var height , width , url , sTmp , param , ret_val , tmp , i , j , _oldTmpVal ;

	// 5.8.5.0 (2015/02//6) キャレットの位置を取得
	var getCaretPositionIE = function( elem ){
		elem.focus();
		var range = document.selection.createRange();
		range.moveStart( "character", - elem.value.length );
		var caret_position = range.text.length;
		return caret_position;
	}

//	// 5.2.1.0 (2010/10/01) 
//	height = "600px" ;
//	width  = "900px" ;
//
////	if( p_height != null && p_height.length() > 0 ) { height = p_height; }
////	if( p_width  != null && p_width.length()  > 0 ) { width  = p_width;  }
//	if( p_height != null ) {
//		height = p_height;
//		if( height.indexOf( "px" ) < 0 ) { height = height + "px" ;}	// 6.0.2.5 (2014/10/31) "px" がなければ追加
//	}
//	if( p_width  != null ) {
//		width	= p_width;
//		if( width.indexOf( "px" ) < 0 ) { width = width + "px" ;}		// 6.0.2.5 (2014/10/31) "px" がなければ追加
//	}

	// 6.1.0.0 (2014/12/26) height,width の "px" 処理の修正
	height = p_height ? parseInt(p_height, 10) + "px" : "600px" ;
	width  = p_width  ? parseInt(p_width , 10) + "px" : "900px" ;

	// ポップアップ画面定義
//	var url  =	p_pgid + "?command=NEW";
//	var url  =	p_pgid + "?command=" + command;
	url  =	p_pgid + "?command=" + ( command ? command : "NEW" );
//	sTmp = 'dialogHeight:' + height + 'px;dialogWidth:' + width + 'px';
//	sTmp = 'dialogHeight:' + height + ';dialogWidth:' + width;						// 5.2.1.0 (2010/10/01)
	sTmp = 'resizable:on; dialogHeight:' + height + ';dialogWidth:' + width;		// 5.7.5.0 (2014/04/04)
	if( event ) {
		sTmp = sTmp + ';dialogLeft:' + event.screenX + 'px;' + 'dialogTop:' + event.screenY + 'px';
	}

	// 入力引数の設定
	if( p_in_Array != null ) {
		for( i=0; i<p_in_Array.length; i+=2 ) {
//			url = url + "&" + p_in_Array[i] + "=" + EscapeUTF8(p_in_Array[i+1]);
			url = url + "&" + p_in_Array[i] + "=" + encodeURIComponent( p_in_Array[i+1]);  // 5.2.0.0 (2010/09/01)
		}
	}

	// 6.4.6.1 (2016/06/03) ポップアップの戻り値を引数に追加
	if( p_out_Array != null ) {
		url = url + "&popupReturnKeys=" + p_out_Array[0] ;
		for( i=1; i<p_out_Array.length; i++ ) {
			url = url + "," + p_out_Array[i] ;
		}
	}

	// ポップアップ画面
	param = "";
	if( ( p_out_Array != null ) && ( document.getElementById( p_out_Array[0] ) ) ){
		param = document.getElementById( p_out_Array[0] ).value;
	}
	ret_val = showModalDialog( url,param,sTmp );
	// 4.1.1.2 2008/03/11 既存仕様に合わせるため、戻り値が文字列の場合は、配列に変換
	//if( ( ret_val != null ) && ( ret_val[0] == null ) ){
	if( ( ret_val != null ) && ( typeof ret_val !== "object" ) ){
		ret_val = new Array( ret_val );
	}

	// 5.5.3.0 changeイベントを起こすオブジェクトを保存しておいて、後からキックする
	var changes_obj = new Array();

	// 出力引数に、ポップアップからの戻り値を設定
	if( ret_val != null && p_out_Array != null ) {
//		var tmp,j ;
		for( j=0; ( j<p_out_Array.length && j<ret_val.length ) ; j++ ) {
			if( p_out_Array[j] != '' ) {
//				tmp = eval( 'document.' + p_this.form +'.' + p_out_Array[j]);
				tmp = p_this.form.elements[p_out_Array[j]];
				if( tmp != null ) {
					// 6.1.0.0 (2014/12/26) ヘッダー固定のBulkSet対応
					// 6.1.1.0 (2015/01/17) BulkSet のキーは、"h_" で始まり、getElementsByName() は複数存在する場合
//					if( tmp.length ) {			// getElementsByName() の戻り値で複数存在した場合
					if( p_out_Array[j].indexOf( "h_" ) == 0 && tmp.length ) {
						for( var k=0; k<tmp.length; k++) {
							_oldTmpVal = tmp[k].value;

//							tmp[k].value = ret_val[j];
							// 5.8.5.0 (2015/02//6) キャレットの位置を取得
							if( p_append == "true" ){ // 5.8.5.0 (2015/02/16)
								var caret_position = getCaretPositionIE(tmp[k]);
								tmp[k].value = tmp[k].value.substring(0,caret_position) + ret_val[j] + tmp[k].value.substring(caret_position,tmp[k].value.length); 
							}
							else{
								tmp[k].value = ret_val[j];
							}

							// 4.3.6.2 (2009/04/15) 異なる値をセットした場合にChangeイベントを発生させる。
							if( _oldTmpVal != ret_val[j] ){
								//$(tmp[k]).change();
								changes_obj[changes_obj.length] = tmp[k];
							}
						}
					}
					else {
						_oldTmpVal = tmp.value;
//						tmp.value = ret_val[j];
						// 5.8.5.0 (2015/02//6) キャレットの位置を取得
						if( p_append == "true" ){ // 5.8.5.0 (2015/02/16)
							var caret_position = getCaretPositionIE(tmp);
							tmp.value = tmp.value.substring(0,caret_position) + ret_val[j] + tmp.value.substring(caret_position,tmp.value.length); 
						}
						else{
							tmp.value = ret_val[j];
						}

						// 4.3.6.2 (2009/04/15) 異なる値をセットした場合にChangeイベントを発生させる。
						if( _oldTmpVal != ret_val[j] ){
							//$(tmp).change();
							changes_obj[changes_obj.length] = tmp;
						}
					}
				}
			}
		}
	}

	// 5.5.3.0
	for( i=0; i<changes_obj.length; i++){
		$(changes_obj[i]).change();
	}
		
	// 5.5.1.5 (2012/04/12) 先頭が_RENEWの場合は[1]をRENEW付きでcall
	if( ret_val != null && ret_val[0] == '_RENEW' ){
		if(ret_val[1].indexOf('?') > 0 ){
			location.href=ret_val[1]+'&command=RENEW';
		}
		else{
			location.href=ret_val[1]+'?command=RENEW';
		}
	}
}

// http://nurucom-archives.hp.infoseek.co.jp/digital/ecl.js.txt
//EscapeUTF8=function(str){
//	return str.replace(/[^*+.-9A-Z_a-z-]/g,function(s){
//		var c=s.charCodeAt(0);
//		return (c<16?"%0"+c.toString(16):c<128?"%"+c.toString(16):c<2048?"%"+(c>>6|192).toString(16)+"%"+(c&63|128).toString(16):"%"+(c>>12|224).toString(16)+"%"+(c>>6&63|128).toString(16)+"%"+(c&63|128).toString(16)).toUpperCase()
//	})
//};

/*
 * 4.0.1.0 (2007/12/12) Window opens.
 *
 * default.js#window_open( url,evt,name,opt ) の代替処理
 * The event is received, and new window is opened at the clicked position.
 *
 * ogOpen( url,evt,name,opt )
 *	 url  : Opening URL is specified.
 *	 evt  : When the number of cases is a little, height is adjusted, and the scroll bar is displayed.
 *	 name : It is a name when the value is returned.
 *	 opt  : It is an option for the opening of window.
 *
 *	The following examples are samples of the calendar assistance menu.
 *
 *	TEST1:<input type="text" name="TEST1"  id="TEST1"  size="10" maxlength="8" value="20040201" />
 *	<img src="calendar.gif" onclick="ogOpen('../common/calendar.html', event,'TEST1','width=220,height=170,resizable=no' );" />
 *
 */
function ogOpen( url,evt,name,opt ){
	var option , move ;
	option = opt;
	if( evt != null ) {
		move = 'left=' + evt.x + ',top=' + evt.y ;
		if( option != null ) {
			option += ',' + move ;
		}
	}

	window.open( url, name, option );
}

/*
 * 5.2.1.0 (2010/10/01) DisplayCapture
 *
 * org.opengion.fukurou.util.DisplayCapture のデータをクリップボード経由でやり取りします。
 * GUI:{@GUI.KEY} {@SESSION.JSPID} 形式のデータを受け取り、画面キャプチャを所定の
 * フォルダに出力します。
 * エラーが発生したときは、クリップボード経由で報告します。
 *
 * window.onload = setTimeout( 'setDisplayCapture( "GUI:{@GUI.KEY} {@SESSION.JSPID}" )', 100 );
 *
 */
function setDisplayCapture( msg )	{
	clipboardData.setData( "Text", msg );

	setTimeout( "getDisplayCapture()", 1000 );	// エラーメッセージの取得は、時間差で行う。
}

function getDisplayCapture()	{
	var cpdata = clipboardData.getData("Text");
	if( cpdata.lastIndexOf("ERROR:", 0) == 0 ) {
		alert(cpdata);
	}
	return cpdata ;
}
