/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.model;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.TreeSet;
import org.apache.poi.POITextExtractor;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.model.Slide;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.usermodel.SlideShow;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.SheetUtil;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.xmlbeans.XmlException;
import org.opengion.fukurou.model.ExcelModel;
import org.opengion.fukurou.model.ExcelStyleFormat;
import org.opengion.fukurou.model.TextConverter;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.system.ThrowUtil;
import org.opengion.fukurou.util.FileInfo;

public final class POIUtil {
    private static final String VERSION = "6.4.6.0 (2016/05/27)";
    public static final String POI_SUFIX = "ppt,pptx,doc,docx,xls,xlsx,xlsm";

    private POIUtil() {
    }

    public static boolean isPOI(File file) {
        return POI_SUFIX.contains(FileInfo.getSUFIX(file));
    }

    public static String extractor(File file) {
        POITextExtractor pOITextExtractor = null;
        try {
            pOITextExtractor = ExtractorFactory.createExtractor((File)file);
            String string = pOITextExtractor.getText();
            return string;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093[" + file + "]" + HybsConst.CR + fileNotFoundException.getMessage();
            throw new OgRuntimeException(string, fileNotFoundException);
        }
        catch (IOException iOException) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u51e6\u7406\u30a8\u30e9\u30fc[" + file + "]" + HybsConst.CR + iOException.getMessage();
            throw new OgRuntimeException(string, iOException);
        }
        catch (InvalidFormatException invalidFormatException) {
            String string = "\u30d5\u30a1\u30a4\u30eb\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30a8\u30e9\u30fc[" + file + "]" + HybsConst.CR + invalidFormatException.getMessage();
            throw new OgRuntimeException(string, invalidFormatException);
        }
        catch (OpenXML4JException openXML4JException) {
            String string = "ODF-XML\u51e6\u7406\u30a8\u30e9\u30fc[" + file + "]" + HybsConst.CR + openXML4JException.getMessage();
            throw new OgRuntimeException(string, openXML4JException);
        }
        catch (XmlException xmlException) {
            String string = "XML\u51e6\u7406\u30a8\u30e9\u30fc[" + file + "]" + HybsConst.CR + xmlException.getMessage();
            throw new OgRuntimeException(string, xmlException);
        }
        finally {
            Closer.ioClose((Closeable)pOITextExtractor);
        }
    }

    public static String extractor(File file, String string) {
        try {
            byte[] byArray = Files.readAllBytes(file.toPath());
            return new String(byArray, string);
        }
        catch (IOException iOException) {
            String string2 = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + file + "] , ENCODE=[" + string + "]";
            throw new OgRuntimeException(string2, iOException);
        }
    }

    public static void textReader(File file, TextConverter<String, String> textConverter, String string) {
        BufferedReader bufferedReader = null;
        int n = 0;
        try {
            String string2;
            bufferedReader = Files.newBufferedReader(file.toPath(), Charset.forName(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                textConverter.change(string2, String.valueOf(n++));
            }
        }
        catch (IOException iOException) {
            try {
                String string3 = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + file + "] , ENCODE=[" + string + "] , ROW=[" + n + "]";
                throw new OgRuntimeException(string3, iOException);
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedReader);
                throw throwable;
            }
        }
        Closer.ioClose(bufferedReader);
    }

    public static void textReader(File file, TextConverter<String, String> textConverter) {
        String string = FileInfo.getSUFIX(file);
        if ("doc".equalsIgnoreCase(string)) {
            POIUtil.wordReader1(file, textConverter);
        } else if ("docx".equalsIgnoreCase(string)) {
            POIUtil.wordReader2(file, textConverter);
        } else if ("ppt".equalsIgnoreCase(string)) {
            POIUtil.pptReader1(file, textConverter);
        } else if ("pptx".equalsIgnoreCase(string)) {
            POIUtil.pptReader2(file, textConverter);
        } else if ("xls".equalsIgnoreCase(string)) {
            POIUtil.excelReader1(file, textConverter);
        } else if ("xlsx".equalsIgnoreCase(string) || "xlsm".equalsIgnoreCase(string)) {
            POIUtil.excelReader2(file, textConverter);
        } else {
            String string2 = "\u62e1\u5f35\u5b50\u306f\u3001ppt,pptx,doc,docx,xls,xlsx,xlsm \u306b\u3057\u3066\u304f\u3060\u3055\u3044\u3002[" + file + "]";
            throw new OgRuntimeException(string2);
        }
    }

    private static void wordReader1(File file, TextConverter<String, String> textConverter) {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            HWPFDocument hWPFDocument = new HWPFDocument((InputStream)bufferedInputStream);
            int n = 0;
            Range range = hWPFDocument.getRange();
            for (int i = 0; i < range.numParagraphs(); ++i) {
                Paragraph paragraph = range.getParagraph(i);
                String string = Range.stripFields((String)paragraph.text()).replaceAll("\\x13[^\\x01]+\\x01\\x14", "").replaceAll("\\x0b", "\n").trim();
                textConverter.change(string, String.valueOf(n++));
            }
        }
        catch (IOException iOException) {
            try {
                String string = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + file + "]" + HybsConst.CR + iOException.getMessage();
                throw new OgRuntimeException(string, iOException);
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedInputStream);
                throw throwable;
            }
        }
        Closer.ioClose(bufferedInputStream);
    }

    private static void wordReader2(File file, TextConverter<String, String> textConverter) {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            XWPFDocument xWPFDocument = new XWPFDocument((InputStream)bufferedInputStream);
            int n = 0;
            for (XWPFParagraph xWPFParagraph : xWPFDocument.getParagraphs()) {
                String string = xWPFParagraph.getParagraphText().trim();
                textConverter.change(string, String.valueOf(n++));
            }
        }
        catch (IOException iOException) {
            try {
                String string = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + file + "]" + HybsConst.CR + iOException.getMessage();
                throw new OgRuntimeException(string, iOException);
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedInputStream);
                throw throwable;
            }
        }
        Closer.ioClose(bufferedInputStream);
    }

    private static void pptReader1(File file, TextConverter<String, String> textConverter) {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            SlideShow slideShow = new SlideShow(new HSLFSlideShow((InputStream)bufferedInputStream));
            Slide[] slideArray = slideShow.getSlides();
            int n = 0;
            for (int i = 0; i < slideArray.length; ++i) {
                TextRun[] textRunArray = slideArray[i].getTextRuns();
                for (int j = 0; j < textRunArray.length; ++j) {
                    String string = textRunArray[j].getText();
                    if (string.length() <= 0) continue;
                    textConverter.change(string, String.valueOf(n++));
                }
            }
        }
        catch (IOException iOException) {
            try {
                String string = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + file + "]" + HybsConst.CR + iOException.getMessage();
                throw new OgRuntimeException(string, iOException);
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedInputStream);
                throw throwable;
            }
        }
        Closer.ioClose(bufferedInputStream);
    }

    private static void pptReader2(File file, TextConverter<String, String> textConverter) {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            XMLSlideShow xMLSlideShow = new XMLSlideShow((InputStream)bufferedInputStream);
            XSLFPowerPointExtractor xSLFPowerPointExtractor = new XSLFPowerPointExtractor(xMLSlideShow);
            String[] stringArray = xSLFPowerPointExtractor.getText().split("\\n");
            for (int i = 0; i < stringArray.length; ++i) {
                textConverter.change(stringArray[i], String.valueOf(i));
            }
        }
        catch (IOException iOException) {
            try {
                String string = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + file + "]" + HybsConst.CR + iOException.getMessage();
                throw new OgRuntimeException(string, iOException);
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedInputStream);
                throw throwable;
            }
        }
        Closer.ioClose(bufferedInputStream);
    }

    public static void excelReader1(File file, TextConverter<String, String> textConverter) {
        POIUtil.excelReader2(file, textConverter);
    }

    public static void excelReader2(File file, TextConverter<String, String> textConverter) {
        ExcelModel excelModel = new ExcelModel(file, true);
        excelModel.textConverter((string, string2) -> {
            textConverter.change((String)string, (String)string2);
            return null;
        });
    }

    public static int[] kigo2rowCol(String string) {
        int n = 0;
        int n2 = -1;
        if ("SHEET".equalsIgnoreCase(string)) {
            n = -1;
        } else {
            int n3 = string.indexOf(45);
            if (n3 > 0) {
                n = Integer.parseInt(string.substring(0, n3));
                n2 = Integer.parseInt(string.substring(n3 + 1));
            } else {
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if ('A' > c || c > 'Z') {
                        n = Integer.parseInt(string.substring(i)) - 1;
                        break;
                    }
                    n2 = (n2 + 1) * 26 + c - 65;
                }
            }
        }
        return new int[]{n, n2};
    }

    public static String getValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        String string = "";
        int n = cell.getCellType();
        switch (n) {
            case 0: {
                string = POIUtil.getNumericTypeString(cell);
                break;
            }
            case 1: {
                RichTextString richTextString = cell.getRichStringCellValue();
                if (richTextString == null) break;
                string = richTextString.getString();
                break;
            }
            case 2: {
                Workbook workbook = cell.getSheet().getWorkbook();
                CreationHelper creationHelper = workbook.getCreationHelper();
                FormulaEvaluator formulaEvaluator = creationHelper.createFormulaEvaluator();
                try {
                    string = POIUtil.getValue(formulaEvaluator.evaluateInCell(cell));
                }
                catch (Throwable throwable) {
                    String string2 = "\u30bb\u30eb\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u304c\u89e3\u6790\u3067\u304d\u307e\u305b\u3093\u3002Formula=[" + cell.getCellFormula() + "]" + HybsConst.CR + POIUtil.getCellMsg(cell);
                    System.err.println(ThrowUtil.ogStackTrace(string2, throwable));
                }
                break;
            }
            case 4: {
                string = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                break;
            }
        }
        return string;
    }

    public static void setValue(Cell cell, String string) {
        if (cell == null) {
            return;
        }
        if (string == null || string.isEmpty()) {
            cell.setCellType(3);
        }
        switch (cell.getCellType()) {
            case 0: {
                cell.setCellValue(Double.valueOf(string).doubleValue());
                break;
            }
            case 4: {
                cell.setCellValue("true".equalsIgnoreCase(string));
                break;
            }
            default: {
                cell.setCellValue(string);
            }
        }
    }

    public static String getNumericTypeString(Cell cell) {
        String string;
        double d = cell.getNumericCellValue();
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            string = ExcelStyleFormat.dateFormat(d);
        } else {
            String string2 = cell.getCellStyle().getDataFormatString();
            string = ExcelStyleFormat.getNumberValue(string2, d);
        }
        return string;
    }

    public static void autoCellSize(Workbook workbook, int n, int n2) {
        int n3 = workbook.getNumberOfSheets();
        for (int i = 0; i < n3; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            int n4 = sheet.getDefaultColumnWidth();
            int n5 = n4 * 256 * n;
            int n6 = sheet.getFirstRowNum();
            int n7 = sheet.getLastRowNum();
            Row row = sheet.getRow(n6);
            int n8 = row.getFirstCellNum();
            short s = row.getLastCellNum();
            if (n6 < n2) {
                n6 = n2;
            }
            for (int j = n8; j < s; ++j) {
                double d = SheetUtil.getColumnWidth((Sheet)sheet, (int)j, (boolean)true, (int)n6, (int)n7);
                if (!(d >= 0.0)) continue;
                int n9 = (int)Math.ceil(d * 256.0);
                if (n5 >= 0 && n9 > n5) {
                    n9 = n5;
                }
                sheet.setColumnWidth(j, n9);
            }
        }
    }

    public static void activeWorkbook(Workbook workbook, boolean bl) {
        int n = workbook.getNumberOfSheets();
        block0: for (int i = 0; i < n; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            int n2 = sheet.getFirstRowNum();
            int n3 = sheet.getLastRowNum();
            boolean bl2 = true;
            for (int j = n3; j >= n2 && j >= 0; --j) {
                int n4;
                Row row = sheet.getRow(j);
                if (row == null) continue;
                short s = row.getFirstCellNum();
                for (int k = n4 = row.getLastCellNum(); k >= s && k >= 0; --k) {
                    Cell cell = row.getCell(k);
                    if (cell == null) continue;
                    String string = POIUtil.getValue(cell);
                    if (cell.getCellType() != 3 && string != null && string.length() > 0) {
                        bl2 = false;
                        break;
                    }
                    if (cell.getCellStyle() != null) {
                        bl2 = false;
                        break;
                    }
                    if (!bl) continue;
                    row.removeCell(cell);
                }
                if (bl2) {
                    sheet.removeRow(row);
                    continue;
                }
                if (!bl) continue block0;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Workbook createWorkbook(File file) {
        Workbook workbook;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            workbook = WorkbookFactory.create((InputStream)bufferedInputStream);
        }
        catch (IOException iOException) {
            try {
                String string = "\u30d5\u30a1\u30a4\u30eb\u8aad\u8fbc\u307f\u30a8\u30e9\u30fc[" + file + "]" + HybsConst.CR + iOException.getMessage();
                throw new OgRuntimeException(string, iOException);
                catch (InvalidFormatException invalidFormatException) {
                    String string2 = "\u30d5\u30a1\u30a4\u30eb\u5f62\u5f0f\u30a8\u30e9\u30fc[" + file + "]" + HybsConst.CR + invalidFormatException.getMessage();
                    throw new OgRuntimeException(string2, invalidFormatException);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(bufferedInputStream);
                throw throwable;
            }
        }
        Closer.ioClose(bufferedInputStream);
        return workbook;
    }

    public static String[] getSheetNames(Workbook workbook) {
        int n = workbook.getNumberOfSheets();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            stringArray[i] = sheet.getSheetName();
        }
        return stringArray;
    }

    public static String[] getNames(Workbook workbook) {
        int n = workbook.getNumberOfNames();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < n; ++i) {
            String string = null;
            String string2 = null;
            Name name = workbook.getNameAt(i);
            try {
                string = name.getNameName();
                string2 = name.getRefersToFormula();
            }
            catch (RuntimeException runtimeException) {
                String string3 = "POIUtil:RefersToFormula Error! name=[" + string + "]" + runtimeException.getMessage();
                System.out.println(string3);
            }
            treeSet.add(string + "\t" + string2);
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public static String[] getStyleNames(Workbook workbook) {
        int n = workbook.getNumCellStyles();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < n; ++i) {
            CellStyle cellStyle = workbook.getCellStyleAt((short)i);
            if (!(cellStyle instanceof HSSFCellStyle)) continue;
            HSSFCellStyle hSSFCellStyle = (HSSFCellStyle)cellStyle;
            String string = hSSFCellStyle.getUserStyleName();
            if (string == null) {
                String string2;
                HSSFCellStyle hSSFCellStyle2 = hSSFCellStyle.getParentStyle();
                if (hSSFCellStyle2 == null || (string2 = hSSFCellStyle2.getUserStyleName()) == null) continue;
                treeSet.add(string2);
                continue;
            }
            treeSet.add(string);
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public static String getCellMsg(Cell cell) {
        String string = null;
        if (cell != null) {
            String string2 = cell.getSheet().getSheetName();
            int n = cell.getRowIndex();
            int n2 = cell.getColumnIndex();
            string = " Sheet=" + string2 + ", Row=" + n + ", Cel=" + n2 + "(" + POIUtil.getCelKigo(n, n2) + ") , Val=" + cell.toString();
        }
        return string;
    }

    public static String getCelKigo(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(200);
        int n3 = n2;
        while (n3 >= 26) {
            stringBuilder.append((char)(65 + n3 % 26));
            n3 = n3 / 26 - 1;
        }
        stringBuilder.append((char)(65 + n3 % 26)).reverse().append(n + 1);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java org.opengion.fukurou.model.POIUtil \u5165\u529b\u30d5\u30a1\u30a4\u30eb\u540d [\u51e6\u7406\u65b9\u5f0f] [\u30a8\u30f3\u30b3\u30fc\u30c9]\n\t -A(LL)        \uff65\uff65\uff65 ALL \u4e00\u62ec\u51e6\u7406(\u521d\u671f\u5024)      \n\t -L(INE)       \uff65\uff65\uff65 LINE \u884c\u5358\u4f4d\u51e6\u7406           \n\t -S(heet)      \uff65\uff65\uff65 Sheet\u540d\u4e00\u89a7               \n\t -N(AME)       \uff65\uff65\uff65 NAME:\u540d\u524d\u5b9a\u7fa9             \n\t -C(ellStyle)  \uff65\uff65\uff65 CellStyle:\u66f8\u5f0f\u306e\u30b9\u30bf\u30a4\u30eb  \n");
            return;
        }
        File file = new File(stringArray[0]);
        int n = stringArray.length >= 2 ? (int)stringArray[1].charAt(1) : 65;
        String string3 = stringArray.length >= 3 ? stringArray[2] : null;
        switch (n) {
            case 65: {
                if (string3 == null) {
                    System.out.println(POIUtil.extractor(file));
                    break;
                }
                System.out.println(POIUtil.extractor(file, string3));
                break;
            }
            case 76: {
                TextConverter<String, String> textConverter = (string, string2) -> {
                    System.out.println("val=" + string + " , cmnt=" + string2);
                    return null;
                };
                if (string3 == null) {
                    POIUtil.textReader(file, textConverter);
                    break;
                }
                POIUtil.textReader(file, textConverter, string3);
                break;
            }
            case 83: {
                String[] stringArray2 = POIUtil.getSheetNames(POIUtil.createWorkbook(file));
                System.out.println("No:\tSheetName");
                for (int i = 0; i < stringArray2.length; ++i) {
                    System.out.println(i + "\t" + stringArray2[i]);
                }
                break;
            }
            case 78: {
                String[] stringArray3 = POIUtil.getNames(POIUtil.createWorkbook(file));
                System.out.println("No:\tName\tFormula");
                for (int i = 0; i < stringArray3.length; ++i) {
                    System.out.println(i + "\t" + stringArray3[i]);
                }
                break;
            }
            case 67: {
                String[] stringArray4 = POIUtil.getStyleNames(POIUtil.createWorkbook(file));
                System.out.println("No:\tStyleName");
                for (int i = 0; i < stringArray4.length; ++i) {
                    System.out.println(i + "\t" + stringArray4[i]);
                }
                break;
            }
            default: {
                System.err.println("Usage: java org.opengion.fukurou.model.POIUtil \u5165\u529b\u30d5\u30a1\u30a4\u30eb\u540d [\u51e6\u7406\u65b9\u5f0f] [\u30a8\u30f3\u30b3\u30fc\u30c9]\n\t -A(LL)        \uff65\uff65\uff65 ALL \u4e00\u62ec\u51e6\u7406(\u521d\u671f\u5024)      \n\t -L(INE)       \uff65\uff65\uff65 LINE \u884c\u5358\u4f4d\u51e6\u7406           \n\t -S(heet)      \uff65\uff65\uff65 Sheet\u540d\u4e00\u89a7               \n\t -N(AME)       \uff65\uff65\uff65 NAME:\u540d\u524d\u5b9a\u7fa9             \n\t -C(ellStyle)  \uff65\uff65\uff65 CellStyle:\u66f8\u5f0f\u306e\u30b9\u30bf\u30a4\u30eb  \n");
            }
        }
    }
}

