<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />

<!-- 検索都度、右側の登録画面を最小化します。 -->
<script type="text/javascript" >
	var resFrameset = parent.document.getElementsByName( "RES_FRAME" );
	if( resFrameset != null &amp;&amp; resFrameset.length != 0 ) {
		resFrameset[0].cols = "*,1" ;
	}
</script>

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9200"
	title	= "標準(PLSQL)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<!-- nullCheckの記述は不要です。columnのチェックを行う場合は、個別に記述する必要があります -->
<og:columnCheck command = "{@command}" />

<!-- データチェック -->
<og:equals val1="{@CDTAN}" val2="{@CDTAN}" >
	<og:dataCheck command="{@command}" lbl="GFE0003" lblParamKeys="{#GF44},{@CDTAN}">
		select count(*) from GF44 where USERID = '{@CDTAN}'
	</og:dataCheck>
</og:equals>
<!-- データチェック -->
<og:dataCheck
	command="{@command}"
	lbl="GFE0002"
	lblParamKeys="{#SYSTEM_ID},'ZW GE GF',{@SYSTEM_ID}"
>
	<![CDATA[
		'{@SYSTEM_ID}' == 'ZW' || '{@SYSTEM_ID}' == 'GE' || '{@SYSTEM_ID}' == 'GF'
	]]>
</og:dataCheck>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" scope="request">
	<!-- DB登録時に使用する USRSET カラムを、DBTableModel に設定しておきます。-->
		SELECT	(CASE KBSAKU WHEN '0' THEN 0 ELSE 1 END) AS WRITABLE	<!-- 書込制御 -->
				,SYSTEM_ID												<!-- ｼｽﾃﾑID -->
				,LANG													<!-- 言語 -->
				,CLM													<!-- 項目 -->
				,NAME_JA												<!-- 名称(漢字) -->
				,LABEL_NAME												<!-- 表示名称 -->
				,KBSAKU													<!-- 作成区分 -->
				,CDTAN													<!-- 担当者 -->
				,UNIQ													<!-- (非表示)ﾕﾆｰｸ -->
		FROM	GF41
	<og:where>
		<og:and value = "FGJ			IN		('0','1')"			/>	<!-- GF41》状態F    IN   ('0','1') -->
		<og:and value = "SYSTEM_ID		=		'{@SYSTEM_ID}'"		/>	<!-- GF41》ｼｽﾃﾑID   ＝   画面》ｼｽﾃﾑID-->
		<og:and value = "LANG			=		'{@LANG}'"			/>	<!-- GF41》言語     ＝   画面》言語-->
		<og:and value = "CLM			LIKE	'{@CLM}'"			/>	<!-- GF41》項目     LIKE 画面》項目-->
		<og:and value = "LABEL_NAME	LIKE	'{@LABEL_NAME}'"	/>	<!-- GF41》表示名称 LIKE 画面》表示名称 -->
		<og:and value = "KBSAKU		=		'{@KBSAKU}'" 		/>	<!-- GF41》作成区分 ＝   画面》作成区分 -->
		<og:and value = "CDTAN			=		'{@CDTAN}'" 		/>	<!-- GF41》担当者   ＝   画面》担当者 -->
	</og:where>
	<og:appear startKey = "ORDER BY" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,CLM,LANG" />
</og:query>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。 以下は、must属性を true にしています。 -->
<og:columnEditor columns="SYSTEM_ID,LANG,CLM" must="true" scope="request" />

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<!-- 項目 -->
	<og:link column="CLM" gamenId="GF9000" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,LANG,CLM,KBSAKU,IMAGE"
		vals="NEW,{@SYSTEM_ID},[LANG],[CLM],[KBSAKU],true" />
	<og:link column="SYSTEM_ID" href="update.jsp" target="UPDATE" onLink="[KBSAKU]" markList="1|2|3"
		keys="command,SYSTEM_ID,UNIQ,pageSize"
		vals="MODIFY,{@SYSTEM_ID},[UNIQ],{@pageSize}" >
			[SYSTEM_ID]<img src="{@SYS.JSP}/image/red_space.gif" alt="{@LBL.MODIFY}" width="30px" height="10px"  />
	</og:link>
</og:viewLink>

<!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
<og:viewMarker command="{@command}">
	<!-- 名称(漢字) -->
	<og:columnMarker column="NAME_JA" onMark="[KBSAKU]" markList="1">
		<span id="hybs_focus" name="hybs_focus" style="background-color:#ccff00">[NAME_JA]</span>
	</og:columnMarker>
	<!-- 表示名称 -->
	<og:columnMarker column="LABEL_NAME" onMark="[KBSAKU]" markList="3" >
		<font color='red'>[LABEL_NAME]</font>
	</og:columnMarker>
</og:viewMarker>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<og:view
	viewFormType = "HTMLTable" 
	command      = "{@command}" 
	noDisplay    = "UNIQ"
	scope		 = "request"
	selectedType = "no"  />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
