/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.report;

import org.opengion.fukurou.system.OgRuntimeException ;		// 6.4.2.0 (2016/01/29)
//import java.io.BufferedWriter;
import java.io.PrintWriter;											// 6.3.8.0 (2015/09/11)
import java.io.File;
// import java.io.FileNotFoundException;
// import java.io.FileOutputStream;
// import java.io.OutputStreamWriter;
// import java.io.UnsupportedEncodingException;
// import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.report.AbstractCSVPrintPointService;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.FileUtil;							// 6.3.8.0 (2015/09/11)
import org.opengion.fukurou.system.Closer ;							// 6.3.8.0 (2015/09/11)

import static org.opengion.fukurou.system.HybsConst.CR ;				// 5.9.0.0 (2015/09/04)
// import static org.opengion.fukurou.system.HybsConst.FS ;				// 5.9.0.0 (2015/09/04)
import static org.opengion.fukurou.system.HybsConst.BUFFER_MIDDLE ;	// 5.9.0.0 (2015/09/04)

/**
 * ユニリタ「Report & Form Warehouse」に対応したCSV形式でデータを作成します。
 * 
 * CSVはシステムリソースRFW_CSV_OUTPUTDIRで指定した場所に[LISTID]_[GRPID]_[YKNO].csvで出力されます。
 * 又、RFWはNASに出力する場合はJOB単位にNASサーバを指定する必要があるため、出力先ディレクトリの先頭文字が「\\」
 * となっていた際には「_NASサーバ名」を出力先ディレクトリとします。
 * 特殊な動作として、デーモングループに"BIG"の文字が入っている場合はCSV出力先ディレクトリ末尾に"_BIG"を付加します。
 * ２つのフォルダは予め作成しておきます。
 * 
 * データに関しては、全てダブルクウォートで囲って出力されます。
 * ダブルクウォートそのものは二重化でエスケープします。
 * ヘッダ、フッタが存在する場合、ボディ、ヘッダ、フッタの順番に連結して出力し、カラム名はヘッダはH_、フッタはF_を先頭に追加します。
 * 
 * 区分Excelの場合にどの文字列でヘッダーを出すかはシステムリソースRFW_EXCEL_TYPEで決めます。
 * 指定なしの場合はXLSとなります。
 * 区分Excel(XLSX)の場合はXLSX固定です。
 *
 * @og.group 帳票システム
 *
 * @version  5.9.0.0
 * @author	 Masakazu Takahashi
 * @since    JDK6.0,
 */
public class CSVPrintPointService_RFW extends AbstractCSVPrintPointService {

//	private static final String CR		= System.getProperty("line.separator");
	private final StringBuilder strCSV	= new StringBuilder( BUFFER_MIDDLE );				// CSVはこれに吐く

	private static final String	CSV_ENCODE 	= HybsSystem.sys("REPORT_CSV_TEXT_ENCODE");		// 6.4.1.1 (2016/01/16) csvEncode  → CSV_ENCODE  refactoring

	private static final String RFW_CSV_OUTPUTDIR = HybsSystem.sys("RFW_CSV_OUTPUTDIR");

	// 5.9.3.3 (2015/12/26) 新規追加
	private static final String RFW_EXCEL_TYPE = StringUtil.nval( HybsSystem.sys("RFW_EXCEL_TYPE"), "XLS" ) ;

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 6.4.2.0 (2016/01/29) PMD refactoring. Each class should declare at least one constructor.
	 */
	public CSVPrintPointService_RFW() {
		super();		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。
	}

	/**
	 * 発行処理。
	 * ファイル出力
	 *
	 * @og.rev 6.3.8.0 (2015/09/11) FileUtil#getPrintWriter( File,String ) を使用。
	 * @og.rev 5.9.2.2 (2015/11/20) ファイル名に標準OrderBy同様にGRPIDを付ける。デーモングループに「BIG」が入っている場合は出力先変更
	 * @og.rev 5.9.6.2 (2016/03/11) RFWのNAS出力対応に伴う修正。outdirが\\から開始される場合に、次の\もしくは/までの文字列を出力フォルダに付け足す。
	 * @og.rev 5.9.6.3 (2016/03/18) outdirからはサーバ名は削除する。
	 *
	 * @return 結果 [true:正常/false:異常]
	 */
	@Override
	public boolean execute(){
		System.out.print( "CSV create ... " );
//		BufferedWriter bw = null;
		PrintWriter    bw = null;				// 6.3.8.0 (2015/09/11)
//		boolean flg = false;					// 6.3.8.0 (2015/09/11) try ～ catch で、flag判定の意味がなかった。

		try {
			// 5.9.6.2 (2016/03/11) RFWのNAS出力対応に伴う修正
			// outdirが\\から開始される場合に、次の\もしくは/までの文字列を出力フォルダに付け足す
			// 5.9.6.3 (2016/03/18) かつ、outdirからはサーバ名は削除する
			String nasName = "";
			if( outdir != null && outdir.startsWith( "\\\\" ) ){
				int spl = outdir.indexOf( "\\", 2 );
				int spl2 = outdir.indexOf( "/", 2 );
				spl = spl<0 ? outdir.length() : spl;
				spl2 = spl2<0 ? outdir.length() : spl2;
				spl = spl < spl2 ? spl : spl2;
				nasName = "_" + outdir.substring( 2, spl );
				outdir = outdir.substring(spl+1); // 5.9.6.3
			}

			makeheader();
			makebody();

//			// 5.9.6.2 (2016/03/11) RFWのNAS出力対応に伴う修正
//			// outdirが\\から開始される場合に、次の\もしくは/までの文字列を出力フォルダに付け足す
//			String nasName = "";
//			if( outdir != null && outdir.startsWith( "\\\\" ) ){
//				int spl = outdir.indexOf( "\\", 2 );
//				int spl2 = outdir.indexOf( "/", 2 );
//				spl = spl<0 ? outdir.length() : spl;
//				spl2 = spl2<0 ? outdir.length() : spl2;
//				spl = spl < spl2 ? spl : spl2;
//				nasName = "_" + outdir.substring( 2, spl );
//			}

			// 6.3.8.0 (2015/09/11) FileUtil#getPrintWriter( File,String ) を使用。
//			bw = getWriter( RFW_CSV_OUTPUTDIR + File.separator + listid + "_" + ykno + ".csv" ,false,csvEncode);
//			final File file = new File( RFW_CSV_OUTPUTDIR , listid + "_" + ykno + ".csv" );
//			bw = FileUtil.getPrintWriter( file,csvEncode ) ;				// 6.3.8.0 (2015/09/11) 
			// 5.9.2.2 (2015/11/20) 汎用化も考えたが、予期せぬ出力があると困るのでBIG決め打ち。フォルダ存在しない場合はエラー
			final String dir = dmngrp != null && dmngrp.contains( "BIG" ) ? RFW_CSV_OUTPUTDIR + nasName + "_BIG" : RFW_CSV_OUTPUTDIR + nasName ;
			final String csv = listid + "_" + grpid + "_" + ykno + ".csv" ;
			bw = FileUtil.getPrintWriter( new File( dir , csv ),CSV_ENCODE ) ;				// 6.3.8.0 (2015/09/11) 

			bw.write( strCSV.toString() );
			bw.flush();
//			bw.close();

//			flg = true;

//			if( prgfile != null && prgfile.length() > 0){
//				makeShellCommand();
//				flg = programRun();
//			}

		}
		catch ( Throwable ex ) {
			errMsg.append( "CSV Print Request Execution Error. " ).append( CR )
				.append( "==============================" ).append( CR )
				.append( "SYSTEM_ID=[" ).append( systemId ).append( "] , " )
				.append( "YKNO=["    ).append( ykno    ).append( "] , " )
				.append( ex.toString() )
				.append( CR );
//			throw new OgRuntimeException( errMsg.toString() );
			throw new OgRuntimeException( errMsg.toString(), ex );
		}
		finally {
			Closer.ioClose( bw );		// 6.3.8.0 (2015/09/11) 
		}
//		return flg;
		return true;			// 6.3.8.0 (2015/09/11) catch 以外は、フラグにtrue がセットされるので、ここでは、true しか返さない。
	}

	/**
	 * ヘッダの出力。
	 *
	 * @og.rev 5.9.1.2 (2015/10/23) RDSetOutputPrinterの値をIDに変更
	 * @og.rev 5.9.3.0 (2015/12/04) option追加
	 * @og.rev 5.9.3.2 (2015/12/21) XLSX対応
	 * @og.rev 5.9.4.2 (2016/01/13) XLSXは区分に持たせるようにする
	 * @og.rev 5.9.6.0 (2016/03/01) 拡張子対応
	 */
	private void makeheader(){
		// ヘッダデータを出力する場合はここで指定する。
		strCSV.append( "<rdstart>" ).append( CR )
			.append( "RDSetForm=\"" ).append(modelname).append('"').append( CR )
			// 5.9.3.1 (2015/12/16)
			.append( "RDSetUserName=\"" ).append(systemId).append('"').append( CR )
//			.append( "RDSetComputer=\"" ).append( listid + "_" + grpid + "_" + ykno ).append("\"").append( CR )
			.append( "RDSetComputer=\"" ).append(listid).append('_').append( grpid ).append('_').append(ykno).append('"').append( CR )		// 6.4.1.1 (2016/01/16) refactoring
			.append( "RDSetDocName=\""  ).append(listid).append('"').append( CR );

		// 5.9.6.0 拡張子を自動で付ける対応を入れておく
		String suffix = ""; // 5.9.6.0

		// PDFの場合
		if( FGRUN_PDF.equals( fgrun ) ){
			if( outdir != null && outdir.indexOf(".") < 0 ) {
				suffix = ".pdf";
			}
			strCSV.append( "RDSetOutputMode=PDF" ).append( CR )
//				.append( "RDSetOutputFileName=\"" ).append( outdir ).append('"').append( CR );
				.append( "RDSetOutputFileName=\"" ).append( outdir ).append( suffix ).append('"').append( CR );
		}
		// Excel(XLS)
		else if( FGRUN_EXCEL.equals(fgrun) ){
			if( outdir != null && outdir.indexOf(".") < 0 ){
				suffix = ".xls";
			}
			// 5.9.3.2 (2015/12/21) XLSX対応
//			strCSV.append( "RDSetOutputMode=XLS" ).append( CR )
//			if( option != null && option.indexOf("RDSetOutputMode") < 0 ){
//				strCSV.append( "RDSetOutputMode=" ).append( RFW_EXCEL_TYPE ).append( CR );
//			}
			strCSV.append( "RDSetOutputMode=" ).append( RFW_EXCEL_TYPE ).append( CR )
//				.append( "RDSetOutputFileName=\"" ).append( outdir ).append('"').append( CR );
				.append( "RDSetOutputFileName=\"" ).append( outdir ).append( suffix ).append('"').append( CR );
		}
		// Excel(XLSX) 5.9.4.2 (2016/01/13)
		else if( FGRUN_EXCEL2.equals(fgrun) ){
			if( outdir != null && outdir.indexOf(".") < 0 ){
				suffix = ".xlsx";
			}
			strCSV.append( "RDSetOutputMode=XLSX" ).append( CR )
//				.append( "RDSetOutputFileName=\"" ).append( outdir ).append('"').append( CR );
				.append( "RDSetOutputFileName=\"" ).append( outdir ).append( suffix ).append('"').append( CR );
		}
		// 印刷
		else{
			strCSV.append( "RDSetOutputMode=SPOOL" ).append( CR )
//				.append( "RDSetOutputPrinter=\"" ).append(prtName).append( '"' ).append( CR );
				// プリンタ名ではなく、プリンタIDを出力するように変更
				.append( "RDSetOutputPrinter=\"" ).append(prtid).append( '"' ).append( CR );
		}

		if( option != null && option.length() > 0 ){
			strCSV.append( option ).append( CR );			// 5.9.3.0 (2015/12/04)
		}

		strCSV.append( "<rdend>" ).append( CR );

		//１行目にカラム名を出力します。クウォートで囲わない。
		// メインテーブルはNULLではない
		for( int clmNo=0; clmNo<table.getColumnCount(); clmNo++ ) {
			// 先頭以外はカンマを付ける
			if( clmNo > 0 ){ strCSV.append( ',' ); } 
			strCSV.append( table.getColumnName( clmNo ));
		}
		if( tableH != null){
			for( int clmNo=0; clmNo<tableH.getColumnCount(); clmNo++ ) {
//				strCSV.append( ',' )
//					.append("H_").append( tableH.getColumnName( clmNo ));
				strCSV.append(",H_").append( tableH.getColumnName( clmNo ));
			}
		}
		if( tableF != null){
			for( int clmNo=0; clmNo<tableF.getColumnCount(); clmNo++ ) {
//				strCSV.append( ',' )
//					.append("F_").append( tableF.getColumnName( clmNo ));
				strCSV.append(",F_").append( tableF.getColumnName( clmNo ));
			}
		}
		strCSV.append( CR );
	}

	/**
	 * 本体の出力を行います。
	 * HTMLエスケープされている場合は戻します
	 * 
	 * @og.rev 5.9.8.2 (2016/05/16) EOR対応
	 */
	private void makebody(){

		for( int rowNo=0; rowNo<table.getRowCount(); rowNo++ ) {
			// カラム単位の処理
			for( int clmNo=0; clmNo<table.getColumnCount(); clmNo++ ) {
				// 先頭以外はカンマを付ける
				if( clmNo > 0 ){ strCSV.append( ',' ); } 
//				// 全てダブルクウォートで囲う
//				strCSV.append('"').append( StringUtil.replace( StringUtil.getReplaceEscape( table.getValue( rowNo, clmNo )) ,"\"","\"\"" ) ).append('"');
				// 原則全てダブルクウォートで囲う
				// 5.9.8.2 (2016/05/16) 但し、先頭カラムが制御コードである//EOR//の場合のみ囲わない
				if( clmNo == 0 && "//EOR//".equals( table.getValue( rowNo, clmNo )) ){
					strCSV.append( table.getValue( rowNo, clmNo ) );
				}
				else{
					strCSV.append('"').append( StringUtil.replace( StringUtil.getReplaceEscape( table.getValue( rowNo, clmNo )) ,"\"","\"\"" ) ).append('"');
				}
			}

			//ヘッダ、フッタは毎行に必ず付加します。
			//例え複数行あったとしても先頭行のみ有効です
			//ヘッダ
			if( tableH != null){
				final int rowNoH=0;
				for( int clmNo=0; clmNo<tableH.getColumnCount(); clmNo++ ) {
					// 必ずカンマを付ける
//					strCSV.append( ',' )
					// 全てダブルクウォートで囲う
//						.append('"').append( StringUtil.replace( StringUtil.getReplaceEscape( tableH.getValue( rowNoH, clmNo )) ,"\"","\"\"" ) ).append('"');
					strCSV.append( ",\"" ).append( StringUtil.replace( StringUtil.getReplaceEscape( tableH.getValue( rowNoH, clmNo )) ,"\"","\"\"" ) ).append('"');
				}
			}

			//フッタ
			if( tableF != null ){
				final int rowNoF=0;
				for( int clmNo=0; clmNo<tableF.getColumnCount(); clmNo++ ) {
					// 必ずカンマを付ける
//					strCSV.append( ',' )
					// 全てダブルクウォートで囲う
//						.append('"').append( StringUtil.replace( StringUtil.getReplaceEscape( table.getValue( rowNoF, clmNo )) ,"\"","\"\"" ) ).append('"');
					strCSV.append( ",\"" ).append( StringUtil.replace( StringUtil.getReplaceEscape( tableF.getValue( rowNoF, clmNo )) ,"\"","\"\"" ) ).append('"');
				}
			}

			strCSV.append( CR );
		}
	}

//	/**
//	 * ファイル書き込み用のライターを返します。
//	 *
//	 * @og.rev 6.3.8.0 (2015/09/11) FileUtil#getPrintWriter( File,String ) を使用。廃止。
//	 *
//	 * @param fileName ファイル名
//	 * @param append アベンドするか
//	 * @param encode エンコード
//	 *
//	 * @return ライター
//	 */
//	private BufferedWriter getWriter( final String fileName, final boolean append, final String encode) {
//		File file = new File ( fileName );
//		BufferedWriter bw;
//
//		try {
//			bw = new BufferedWriter( new OutputStreamWriter( new FileOutputStream( file, append ), encode ) );
//		}
//		catch ( UnsupportedEncodingException ex ) {
//			errMsg.append( "[ERROR] Input File is written by Unsupported Encoding" );
//			throw new HybsSystemException( ex );
//		}
//		catch ( FileNotFoundException ex ) {
//			errMsg.append( "[ERROR] File not Found" );
//			throw new HybsSystemException( ex );
//		}
//		return bw;
//	}
}
