/*************************************************************************
 * Table Header Scroll (TYPE2)
 * 3.8.0.3 (2005/07/15)
 * Revision: $Id$
 *************************************************************************/

/* "<og:view ... />" The following tag is outputted by describing.		*/
/* <div id="layer" ><table id="viewTable" >ゥ･<thead id="header">Table Bdy</div></div>	*/
/* Usually, a header fixed scroll table is realized using these ID attributes.	*/

/* It is id="fix_height" when specifying the height of a header fixed table. */
/* Please specify it as a div element with a style attribute.  */
/* <div id="fix_height" style="height:150;overflow-y:auto;" >  */
/* <og:view ･･･ />		*/
/* </div>				*/

var _sCompat_ = document.compatMode;
// var bIsBackCompat = ( "BackCompat" == _sCompat_ );
var bIsCSS1Compat = ( "CSS1Compat" == _sCompat_ );

var nWidthScroll	= 17;
var cstrPosMark		= "divPos";
var cstrOutMark		= "outer";
var cstrHideMark	= "divHide";
var cstrLayerMark	= "layer";
var cstrTableMark	= "viewTable";
var cstrTHeadMark	= "header";
var cstrFixDiv		= "fix_height";

window.onresize		 = AdjustScroll2 ;
addEvent(window,"beforeunload",__endIE6Resize );	// 3.8.8.4 (2007/02/17)
// 4.3.5.0 (2009/02/01)
// addEvent(window, "load", _loadSB2);
// 4.3.6.0 (2009/04/01)
$(window).load( function(evt){_loadSB2(evt);} );
if(document.getBoxObjectFor) {
	addEvent(window, "pageshow", function (evt) {if(evt.persisted) _loadSB2(evt);});
}
function _loadSB2(evt) {
		scrollBar2(evt);
		AdjustScroll2(evt);
		focus2(evt);
}

//var nOldLeftScrollPos = 0;

function SetTdTop(oMyHead, nTopSet, fgset) {
	var oRows = oMyHead.rows;
    var bReset = (fgset) ? true : false;
	for (nRowUp=0; nRowUp < oRows.length; nRowUp++) {
		var oThisRow = oRows[nRowUp];
	//	for (nCellUp=0; nCellUp < oThisRow.cells.length; nCellUp++) {
	//		oThisRow.cells[nCellUp].style.top = nTopSet + "px";
	//	}
        var oRowCells = oThisRow.cells;
        var nTotalCells = oRowCells.length;
		for (nCellUp=0; nCellUp < nTotalCells; nCellUp++) {
            if(bReset) {
              if(oRowCells[nCellUp].offsetTop > 1) {
				oRowCells[nCellUp].style.top = nTopSet - 1 + "px";
				oRowCells[nCellUp].style.top = nTopSet + 1 + "px";
              }
            }
            else
				oRowCells[nCellUp].style.top = nTopSet + "px";
		}
	}
}

function SetTdLeftPos(oMyHead, nLeftSet) {
	var oRows = oMyHead.rows;
	for (nRowUp=0; nRowUp < oRows.length; nRowUp++) {
		var oThisRow = oRows[nRowUp];
		for (nCellUp=0; nCellUp < oThisRow.cells.length; nCellUp++) {
			oThisRow.cells[nCellUp].style.left = nLeftSet + "px";
		}
	}
}

function __resetScrollHeader(oMyLayer, fgset) {
    if(!oMyLayer.__bSBSetup__) {
        oMyLayer.__bSBSetup__ = true;
        oMyLayer.nOldLeftScrollPos = 0;
        SetScrollHeader(oMyLayer, fgset);
        oMyLayer.__bSBSetup__ = false;
    }
}

function SetScrollHeader(oMyLayer, fgset) {
	var oHeadersInDiv = oMyLayer.getElementsByTagName("THEAD");
	if(bIsCSS1Compat && (1 == oHeadersInDiv.length) &&	(cstrTHeadMark == oHeadersInDiv[0].id)) {

		var oHeader = oHeadersInDiv[0];
		var nScrollPos = (oMyLayer.nOldLeftScrollPos || 0) - oMyLayer.scrollLeft;
		SetTdLeftPos(oHeader, nScrollPos);
		oMyLayer.nOldLeftScrollPos = oMyLayer.scrollLeft ;
		SetTdLeftPos(oHeader, 0);
		//SetTdTop(oHeader, oMyLayer.scrollTop);
		//SetTdTop(oHeader, oMyLayer.scrollTop - oHeader.parentNode.cellSpacing, fgset);
		SetTdTop(oHeader, oMyLayer.scrollTop - oHeader.offsetTop, fgset);

        //Scroll My Sibling Horizantally(2008/03/27)
		var oMyHSibling = oMyLayer.HSibling;
		if(oMyHSibling && oMyHSibling.scrollTop != oMyLayer.scrollTop) oMyHSibling.scrollTop = oMyLayer.scrollTop;
	}
}

//Flag Specified for Scroll Bar Setting
var __bSBSetup__ = false;
function scrollBar2(evt, fgset) {
	if(!__bInitDhtmlApi) initDHTMLAPI();

	if(isIE4) __setIESB2(evt, fgset);	//IE ScrollBar
	else      __setFFSB2(evt);	//FireFox ScrollBar

    __bSBSetup__ = true;
}

function __setIESB2(evt, fgset) {
	/* +++++++++++++ 2009-04-22 Out +++++++++++++
//	var oLayers  = document.getElementsByName(cstrLayerMark);
//	var oTables  = document.getElementsByName(cstrTableMark);
//	var oHeaders = document.getElementsByName(cstrTHeadMark);
//	var divPos = document.getElementById("divPos");
//
//	if ( divPos == null || null == oLayers || null == oTables || null == oHeaders
//	  || oLayers.length != oTables.length
//	  || oTables.length != oHeaders.length ) return;
	   +++++++++++++ 2009-04-22 Out +++++++++++++ */
	var hFixedObjs = getHeaderFixedObjs();
	var oLayers  = hFixedObjs.divLayer;
//	var oTables  = hFixedObjs.tableView;
	var oHeaders = hFixedObjs.theadHeader;

	var nCountUp, nTotalCount = oLayers.length;
	for( nCountUp = 0; nCountUp < nTotalCount; nCountUp++) {

		var layer	= GetFixDiv(oLayers[nCountUp ]);
//		var table	= oTables[nCountUp ] ;
		var oHeader	= oHeaders[nCountUp];

		//document.compatMode
		var nHeaderH = oHeader.offsetHeight;
		var oTab	= oHeader.parentNode;
		var divHide = oTab.parentNode	;
		var oLayerDiv ;
		if(bIsCSS1Compat) {
			//Special case for X1 & X2
			var oCurSiblingX = getHoriSibling(layer.parentNode.parentNode);
			var bLastTable	= (nCountUp == (nTotalCount -1));
			if(oCurSiblingX && !bLastTable) {
				layer.parentNode.parentNode.style.position = layer.parentNode.style.position = "static";
			}

			divHide.style.height = (oTab.offsetHeight - nHeaderH) + "px";
			divHide.style.width = oTab.offsetWidth + "px";		// 2006/08/28
			layer.style.width = (oTab.offsetWidth + 20) + "px";	// 2006/08/28
			divHide.scrollTop	 = nHeaderH;
			oLayerDiv = divHide.parentNode	 ;
			//oLayerDiv.style.borderTopWidth = nHeaderH.toString(10);
			//oLayerDiv.style.borderTopWidth = nHeaderH + parseInt(oTab.cellSpacing , 10);
			oLayerDiv.style.borderTopWidth = (nHeaderH + 1) + "px";
			SetScrollHeader(oLayerDiv, fgset);
		}
		else {
			divHide.style.height = oTab.offsetHeight;
			oLayerDiv = divHide.parentNode	 ;
			oLayerDiv.style.height = "auto";
			oLayerDiv.style.width  = "auto";
		}
	}
}

var nVertExtra = 10;
// var nHoriExtra = 10;
// var nHoriExtra = 12;  // Ver4.1.0.0 (2008/01/17)
var nHoriExtra = 16;  // Ver4.1.0.1 (2008/01/21)
var nMinLimit  = 10;

var __oInterval		= null;
var __nWinWidth		= -1;
var __nWinHeight	= -1;
var __bInAdjusting	= false;

function __saveWinSizeInfo() {
	if( bIsCSS1Compat ) {

		var oBody = document.documentElement;
		__nWinWidth  = oBody.clientWidth ;
		__nWinHeight = oBody.clientHeight;
	}
}

function __AdjustScroll2() {
	if( !__bInAdjusting && bIsCSS1Compat ) {

		var oBody = document.documentElement;
		if((__nWinWidth  != oBody.clientWidth) || (__nWinHeight != oBody.clientHeight)) {
			AdjustScroll2();
		}
	}
}
function __fixIE6Resize() {
	if(!__oInterval) { __oInterval = window.setInterval(__AdjustScroll2, 1000); }
}

/* 3.8.8.4 (2007/02/17) */
function __endIE6Resize() {
	__bInAdjusting = true;
	if(__oInterval) {
		window.clearInterval(__oInterval);
		__oInterval = null;
	}
}

function AdjustScroll2(evt) {
  if(__bSBSetup__) {
	if(!__bInitDhtmlApi) initDHTMLAPI();

	if(isIE4) __adjustIESB2(evt);	//IE ScrollBar
	else      __adjustFFSB2(evt);	//FireFox ScrollBar
  }
}

function getHoriSibling(oLayer) {
    var oSibling = null;
    var oParent = oLayer;
    while(oParent) {
        if("DIV" != oParent.tagName) break;

        if("X1" == oParent.id || "X2" == oParent.id ) { oSibling = oParent; break; }

        oParent = oParent.parentNode;
    }
    return oSibling;
}

function __adjustIESB2(evt) {
	__bInAdjusting = true;

	/* +++++++++++++ 2009-04-22 Out +++++++++++++
//	var oLayers  = document.getElementsByName(cstrLayerMark);
//	var oTables  = document.getElementsByName(cstrTableMark);
//	var oHeaders = document.getElementsByName(cstrTHeadMark);
//	var divPos = document.getElementById("divPos");
//
//	if ( null == divPos || null == oLayers || null == oTables || null == oHeaders
//	  || oLayers.length != oTables.length
//	  || oTables.length != oHeaders.length ) {
//		__bInAdjusting = false;
//		return;
//	}
	   +++++++++++++ 2009-04-22 Out +++++++++++++ */
	var hFixedObjs = getHeaderFixedObjs();
	var oLayers  = hFixedObjs.divLayer;
	var oTables  = hFixedObjs.tableView;
//	var oHeaders = hFixedObjs.theadHeader;

	if(oTables.length <= 0) {
		__bInAdjusting = false;
		return;
	}

	var oPreSiblingX = 0;
	var oPreSiblingLayer = null;

	var nCountUp, nTotalCount = oLayers.length;
	for( nCountUp = 0; nCountUp < nTotalCount; nCountUp++) {

		var layer	= GetFixDiv(oLayers[nCountUp ]);
		var table	= oTables[nCountUp ] ;
//		var header	= oHeaders[nCountUp];

		table = table.parentNode;
		var bHoriScroll = false;

		//Special case for X1 & X2
		var oCurSiblingX = getHoriSibling(layer.parentNode.parentNode);
		var bLastTable	= (nCountUp == (nTotalCount -1));
		var nClientHeight = getClientHeight();

        var layerDim = getDimensions(layer);

		var oDivPos = layer.parentNode.parentNode;
		var nOTDivPos = oDivPos.offsetTop;
		
		// 4.2.0.0 計算方法を変更
		//var nDummy = getClientWidth()  - layer.offsetLeft - 2*layer.clientLeft - nHoriExtra ;
		var nDummySize = getAncestorSize( oDivPos,
			getClientWidth() - layerDim.left - 2*layer.clientLeft - nHoriExtra,
			nClientHeight - nOTDivPos - layer.clientTop - nVertExtra );
			
		var nDummy = nDummySize.width;

		if(table.offsetWidth > nDummy && (!oCurSiblingX || bLastTable)) {

			layer.style.width = ((nDummy <= 0) ? nMinLimit : nDummy ) ;
			layer.style.overflowX = "auto";
			bHoriScroll = true;
		}

		//Adjust height only at the last table
		var bVertScroll = false;

		if(oCurSiblingX) {
			nDummy = nClientHeight - layerDim.top - layer.clientTop - nVertExtra;
			if(table.offsetHeight > nDummy) {

				bVertScroll = true;
				if(!bLastTable) {
					nDummy -= nWidthScroll;
					layer.style.overflowY = "hidden";
					bVertScroll = false;
				}
				layer.style.height = ((nDummy <= 0) ? nMinLimit : nDummy ) ;
			}
			else {

				layer.style.height = (table.offsetHeight + (bHoriScroll ? nWidthScroll : 0));
			}

			//Adjust the previous sibling height
			if(!bHoriScroll && oPreSiblingX && (nDummy > (nMinLimit + nWidthScroll)))
				oPreSiblingLayer.style.posHeight = oPreSiblingLayer.style.posHeight + nWidthScroll;
		}
		else {
			// 4.2.0.0 ラスト以外にも適用
			//if( bLastTable ) {
				
			// 4.2.0.0 計算方法変更
			//nDummy = nClientHeight - nOTDivPos - layer.clientTop - nVertExtra;
			nDummy = nDummySize.height;
			
			if(table.offsetHeight > nDummy) {

				layer.style.height = ((nDummy <= 0) ? nMinLimit : nDummy ) ;
				bVertScroll = true;
				layer.style.overflowY = "auto"; // 4.3.5.5 (2008/03/08)
			}
			else {

				layer.style.height = (table.offsetHeight + (bHoriScroll ? nWidthScroll : 0));
				layer.style.overflowY = "hidden"; // 4.3.5.5 (2008/03/08)
			}
			
			//}
		}

		//layer.style.height = layer.offsetHeight + layer.offsetTop ;
		if(!bHoriScroll) {

			layer.style.width = table.offsetWidth + ( bVertScroll ? nWidthScroll : 0);
			layer.style.overflowX = "hidden";
		}
		//else { // Ver4.1.0.0 (2008/01/17)
		//	document.body.scroll = "no";
		//}

		//divheader.style.width = Math.min(layer.clientWidth, layer.scrollWidth);

		// We don't know the body scroll bar is still existed
		// after we adjust our layer dimensions , we check it once more
		var nowClientHeight = getClientHeight();
		if(bLastTable && (nowClientHeight > nClientHeight)) {

			layer.style.posHeight += (nowClientHeight - nClientHeight);
		}

		//Reserve for next adjusting
		oPreSiblingX = oCurSiblingX;
		if(oCurSiblingX) {
			if(bLastTable) {
				var nTopWidth = parseInt(layer.style.borderTopWidth || 0 , 10);
				layer.parentNode.parentNode.runtimeStyle.height = layer.parentNode.runtimeStyle.height = layer.style.posHeight + nTopWidth + "px";
				layer.parentNode.parentNode.runtimeStyle.width  = layer.parentNode.runtimeStyle.width  = layer.style.width;
				layer.HSibling = oPreSiblingLayer;
				oPreSiblingLayer.HSibling = layer;
			}
			oPreSiblingLayer = layer;
		}
		else {
			oPreSiblingLayer = null;
		}

        setTimeout("__resetScrollHeader(" + layer.uniqueID + ",false)", 500, "JavaScript");
	}

	__bInAdjusting = false;
	if(bIsCSS1Compat) {

		__saveWinSizeInfo();
		__fixIE6Resize();
	}
}

function GetFixDiv(oMyDiv) {
	var oLayer = oMyDiv;
	var oParent = oLayer.parentNode;
	if(oParent && ("DIV" == oParent.tagName) && (cstrFixDiv == oParent.id)) {
		oLayer = oParent;
	}
	return oLayer;
}

/*
//function getClientHeight() {
//	var nClientHeight = 0;
//	if( bIsCSS1Compat ) {
//		nClientHeight =document.documentElement.clientHeight;
//	}
//	else {
//		nClientHeight =document.body.clientHeight;
//	}
//
//	return nClientHeight;
//}

//function getClientWidth() {
//	var nClientWidth = 0;
//	if( bIsCSS1Compat ) {
//		nClientWidth =document.documentElement.clientWidth;
//	}
//	else {
//		nClientWidth =document.body.clientWidth;
//	}
//
//	return nClientWidth;
//}
*/

function getDimensions(obj) {
	var _width	= obj.offsetWidth;
	var _height = obj.offsetHeight;
	var _top = 0, _left = 0;
	for (; obj != null; obj = obj.offsetParent) {
		_top += obj.offsetTop;
		_left += obj.offsetLeft;
	}
	return {top:_top, left:_left, width:_width, height:_height};
}

//Setup Scroll Bar framework for FireFox
function __setFFSB2(evt) {
    var oTables = getHeaderFixedTabs();
	var nCountUp, nTotalCount = oTables.length;
	for( nCountUp = 0; nCountUp < nTotalCount; nCountUp++) {

		var table  = oTables[nCountUp ];
		var tHead = table.tHead;
		var tBody = table.tBodies[0];

		// 4.2.0.0 最終テーブルだからという判定はしない
//		var bLastTable  = (nCountUp == (nTotalCount -1));
//		if( !bLastTable ) {
//			//Adjust Middle table
//			table.style.overflow = "auto";
//			table.style.display  = "block";
//		}
//		else {
    		//Adjust height only at the last table
			table.style.overflow = "hidden";
			table.style.display  = "block";
			table.rules = "none";
			//table.border = "1px";

			tHead.style.overflow = "hidden";
			tBody.style.display  = "table-header-group";
			tBody.style.overflow = "auto";

			//tBody.onscroll = FSBodyScroll(table);
			addEvent(tBody, "scroll", FSBodyScroll(table));
//		}
	}
}


function __adjustFFSB2(evt) {
	//__bInAdjusting = true;

    var oTables = getHeaderFixedTabs();
	var nCountUp, nTotalCount = oTables.length;
	for( nCountUp = 0; nCountUp < nTotalCount; nCountUp++) {

		var table  = oTables[nCountUp ];
		var layer  = table.parentNode.parentNode;
		//var layer  = oLayers[nCountUp ];
		//var header = oHeaders[nCountUp];

		//var bHoriScroll = false;
		//var bVertScroll = false;

		//Special case for X1 & X2
		var oCurSiblingX = getHoriSibling(layer.parentNode.parentNode);

		var bLastTable  = (nCountUp == (nTotalCount -1));
		//var nClientWidth = getInsideWindowWidth();
		//var nClientHeight = getInsideWindowHeight();
		var nClientWidth  = getClientWidth();
		var nClientHeight = getClientHeight();

		var tabDim = getDimensions(table);

		var tHead = table.tHead;
		var tBody = table.tBodies[0];

		// 4.2.0.0 最終ビュー以外も調節を入れる
//		if( !bLastTable ) {
//		var nSpacing = parseInt(table.cellSpacing , 10) ;
//		nSpacing = ((nSpacing) ? nSpacing : 0);
//		
//		nDummy = nClientWidth - tabDim.left - nHoriExtra;
//		nDummy = 2*nSpacing + Math.max(nDummy, nMinLimit + nWidthScroll);
//		if(table.offsetWidth > nDummy) {
//			table.style.width =  nDummy + "px";
//		}
//		else {
//			table.style.width = table.offsetWidth
//				+ Math.min(nDummy - table.offsetWidth, table.scrollWidth - table.clientWidth) + "px";
//		}
//		}
		//else {
			var nSpacing = parseInt(table.cellSpacing,10) ;
			nSpacing = ((nSpacing) ? nSpacing : 0);
			
			// 4.2.0.0 計算方法変更
			var nDummySize = getAncestorSize( layer.parentNode.parentNode,
			nClientWidth - tabDim.left - nHoriExtra,
			nClientHeight - tabDim.top - nVertExtra);
			//alert(window.getComputedStyle(table,null).getPropertyValue('border'));
			//nDummy = nClientHeight - layer.offsetTop - 2*layer.clientTop - nVertExtra;
			//nDummy = nClientHeight - tabDim.top - nVertExtra;
			nDummy = nDummySize.height - 2;
			nDummy = Math.max(nDummy - tHead.offsetHeight, nMinLimit + nWidthScroll);
			if(tBody.offsetHeight > nDummy) {
				tBody.style.height = nDummy + "px";
			}
			else {
				tBody.style.height = tBody.offsetHeight
					+ Math.min(nDummy - tBody.offsetHeight, tBody.scrollHeight - tBody.clientHeight) + "px";
			}

			//var nDummy = nClientWidth - layer.offsetLeft - 2*layer.clientLeft - nHoriExtra ;
			//nDummy = nClientWidth - tabDim.left - nHoriExtra;
			nDummy = nDummySize.width - 3;
			nDummy = Math.max(nDummy, nMinLimit + nWidthScroll);
			if(tBody.offsetWidth > nDummy) {
				tBody.style.width = nDummy + "px";
			}
			else {
				tBody.style.width = tBody.offsetWidth
					+ Math.min(nDummy - tBody.offsetWidth, tBody.scrollWidth - tBody.clientWidth) + "px";
			}
			//tBody.style.width  = (table.offsetWidth - 2 * nSpacing) + "px";
			tHead.style.width  = (tBody.offsetWidth - nWidthScroll) + "px";
			//table.style.width  = Math.max(nDummy, 2*nSpacing + nMinLimit + nWidthScroll) + "px";
			table.style.width  = (tBody.offsetWidth + 2 * nSpacing) + "px";

			//var nRTWidth = table.offsetWidth, nRTHeight = table.offsetHeight;
			//var oLayer = table.parentNode;
			//while(oLayer && oLayer.id) {
			//	switch(oLayer.id) {
			//	case cstrPosMark  :
			//	case cstrOutMark  :
			//	case cstrHideMark :
			//	case cstrLayerMark:
			//		oLayer.style.width	= nRTWidth ;
			//		oLayer.style.height = nRTHeight;
			//		oLayer = oLayer.parentNode;
			//		break;
			//	default:
			//		oLayer = null;
			//		 break;
			//	}
			//}
		//}

		//Reserve for next adjusting
		oPreSiblingX = oCurSiblingX;
		if(oCurSiblingX) {
			oCurSiblingX.style.width  = table.offsetWidth ;
			oCurSiblingX.style.height = table.offsetHeight;

			if(bLastTable) {
				//var nTopWidth = parseInt(layer.style.borderTopWidth || 0 , 10);
				//layer.parentNode.parentNode.style.height = layer.parentNode.style.height = layer.style.posHeight + nTopWidth + "px";
				//layer.parentNode.parentNode.style.width  = layer.parentNode.style.width  = layer.style.width;
				layer.HSibling = oPreSiblingLayer;
			}
			oPreSiblingLayer = layer;
		}
		else {
			oPreSiblingLayer = null;
		}
	}

	//__bInAdjusting = false;
}

function FSBodyScroll(oTab) {
    var tHead = oTab.tHead;
    var tBody = oTab.tBodies[0];

    function __FSScroll(evt) {
        if(tHead.scrollLeft != tBody.scrollLeft) tHead.scrollLeft = tBody.scrollLeft;
    }
    return __FSScroll;
}

function getHeaderFixedTabs() {
	var oLayers   = new Array();
	var oHideDivs = new Array();
	var oTables   = new Array();
	var oHeaders  = new Array();

	var oAllTabs  = document.getElementsByTagName("TABLE");
	var nCountUp, nTotalCount = oAllTabs.length;
	for( nCountUp = 0; nCountUp < nTotalCount; nCountUp++) {

		var table	= oAllTabs[nCountUp ];

		if(!table.id || cstrTableMark != table.id) continue;

		var hidediv  = table.parentNode;
		if(!hidediv.id || cstrHideMark != hidediv.id) continue;

		//var layer  = table.parentNode;
		var layer  = hidediv.parentNode;
		if(!layer.id || cstrLayerMark != layer.id) continue;

		var header = table.tHead;
		if(!header || !header.id || cstrTHeadMark != header.id) continue;

        //Ignore tables which has a lot of tBody items
		if(table.tBodies.length > 1) continue;

		oHideDivs[oHideDivs.length] = hidediv;
		oLayers[ oLayers.length ]   = layer ;
		oTables[ oTables.length ]   = table ;
		oHeaders[oHeaders.length]   = header;
	}

    return oTables;
}

/* 複数ﾃｰﾌﾞﾙ時のﾍｯﾀﾞ固定の取得 */
function getHeaderFixedObjs() {
	var aLayers  = new Array();
	var aHides   = new Array();
	var aTables  = new Array();
	var aHeaders = new Array();

	var oAllTabs  = document.getElementsByTagName("TABLE");
	var nCountUp, nTotalCount = oAllTabs.length;
	for( nCountUp = 0; nCountUp < nTotalCount; nCountUp++) {

		var oTable	= oAllTabs[nCountUp];
		if(!oTable || cstrTableMark != oTable.id) continue;

		var oHide  = oTable.parentNode;
		if(!oHide || cstrHideMark != oHide.id) continue;

		var oLayer  = oHide.parentNode;
		if(!oLayer || cstrLayerMark != oLayer.id) continue;

		var oHeader = oTable.tHead;
		if(!oHeader || cstrTHeadMark != oHeader.id) continue;

        //Ignore tables which has a lot of tBody items
		//if(table.tBodies.length > 1) continue;

		aLayers.push(oLayer);
		aHides.push(oHide);
		aTables.push(oTable);
		aHeaders.push(oHeader);
	}

    return { theadHeader:aHeaders, tableView:aTables, divHide:aHides, divLayer:aLayers };
}

/* 4.2.0.0 ( 2008/03/18)								*/
/* 高さと横幅を取得した後								*/
/* 調整したサイズを返す									*/
function getAncestorSize( inObj, defWidth, defHeight ){
	var pos = new function(){ this.width = defWidth; this.height = defHeight; };
	
	var outerWidth = inObj.offsetWidth;
	if( inObj.style.width != "" && outerWidth > 30 && outerWidth < defWidth ){ // あまりに小さい場合は設定しない
		pos.width = outerWidth;
	}
	var outerHeight = inObj.offsetHeight -  2.5 * nVertExtra; // 適当な調整
	if( inObj.style.height != "" && outerHeight > 30 && outerHeight < defHeight ){ // あまりに小さい場合は設定しない
		pos.height = outerHeight;
	}
	return pos;
}