/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.List;
import java.util.Locale;
import javax.servlet.jsp.tagext.Tag;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.resource.LDAPSearch;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.QueryOptionTag;

public class LDAPQueryTag
extends CommonTagSupport {
    private static final String VERSION = "5.1.6.0 (2010/05/01)";
    private static final long serialVersionUID = 516020100501L;
    public static final String CMD_NEW = "NEW";
    public static final String CMD_RENEW = "RENEW";
    private static final String[] COMMAND_LIST = new String[]{"NEW", "RENEW"};
    private String initctx = HybsSystem.sys("LDAP_INITIAL_CONTEXT_FACTORY");
    private String providerURL = HybsSystem.sys("LDAP_PROVIDER_URL");
    private String entrydn = HybsSystem.sys("LDAP_ENTRYDN");
    private String password = HybsSystem.sys("LDAP_PASSWORD");
    private String searchbase = HybsSystem.sys("LDAP_SEARCH_BASE");
    private String filter = null;
    private String searchScope = HybsSystem.sys("LDAP_SEARCH_SCOPE");
    private static final long COUNTLIMIT = 0L;
    private int timeLimit = 0;
    private String[] attrs = null;
    private String[] columns = null;
    private boolean returningObjFlag = false;
    private boolean derefLinkFlag = false;
    private String tableId = "h_tblmdl";
    private String orderBy = null;
    private String command = "NEW";
    private int executeCount = 0;
    private int errCode = 0;
    private int maxRowCount = 0;
    private String displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
    private String overflowMsg = "MSG0007";
    private String notfoundMsg = "MSG0077";
    private boolean isMainTrans = true;

    @Override
    public int doEndTag() {
        this.debugPrint();
        QueryOptionTag queryOptionTag = (QueryOptionTag)LDAPQueryTag.findAncestorWithClass((Tag)this, QueryOptionTag.class);
        if (queryOptionTag != null) {
            queryOptionTag.setTableModel(this.makeDBTable());
            return 6;
        }
        if (this.check(this.command, COMMAND_LIST)) {
            this.useMainTrans(this.isMainTrans);
            this.startQueryTransaction(this.tableId);
            DBTableModel dBTableModel = this.makeDBTable();
            if (!this.commitTableObject(this.tableId, dBTableModel)) {
                this.jspPrint("LDAPQueryTag Query\u51e6\u7406\u304c\u5272\u308a\u8fbc\u307e\u308c\u307e\u3057\u305f\u3002DBTableModel \u306f\u767b\u9332\u3057\u307e\u305b\u3093\u3002");
                return 5;
            }
            StringBuilder stringBuilder = new StringBuilder(50);
            if (CMD_NEW.equals(this.command)) {
                if (this.executeCount > 0 && this.displayMsg != null && this.displayMsg.length() > 0) {
                    stringBuilder.append(this.executeCount);
                    stringBuilder.append(this.getResource().getLabel(this.displayMsg));
                    stringBuilder.append(HybsSystem.BR);
                } else if (this.executeCount == 0 && this.notfoundMsg != null && this.notfoundMsg.length() > 0) {
                    stringBuilder.append(this.getResource().getLabel(this.notfoundMsg));
                    stringBuilder.append(HybsSystem.BR);
                }
            }
            if (this.maxRowCount > 0 && this.maxRowCount <= this.executeCount) {
                stringBuilder.append(this.getResource().getLabel(this.overflowMsg));
                stringBuilder.append(HybsSystem.BR).append(HybsSystem.CR);
            }
            this.setRequestAttribute("DB.COUNT", String.valueOf(this.executeCount));
            this.setRequestAttribute("DB.ERR_CODE", String.valueOf(this.errCode));
            this.jspPrint(stringBuilder.toString());
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.searchScope = HybsSystem.sys("LDAP_SEARCH_SCOPE");
        this.timeLimit = 0;
        this.derefLinkFlag = false;
        this.returningObjFlag = false;
        this.attrs = null;
        this.columns = null;
        this.initctx = HybsSystem.sys("LDAP_INITIAL_CONTEXT_FACTORY");
        this.providerURL = HybsSystem.sys("LDAP_PROVIDER_URL");
        this.entrydn = HybsSystem.sys("LDAP_ENTRYDN");
        this.password = HybsSystem.sys("LDAP_PASSWORD");
        this.searchbase = HybsSystem.sys("LDAP_SEARCH_BASE");
        this.filter = null;
        this.tableId = "h_tblmdl";
        this.orderBy = null;
        this.command = CMD_NEW;
        this.executeCount = 0;
        this.errCode = 0;
        this.maxRowCount = 0;
        this.displayMsg = HybsSystem.sys("VIEW_DISPLAY_MSG");
        this.overflowMsg = "MSG0007";
        this.notfoundMsg = "MSG0077";
        this.isMainTrans = true;
    }

    private DBTableModel makeDBTable() {
        if (this.filter == null) {
            String string = "S\u691c\u7d22\u30d5\u30a3\u30eb\u30bf\u30fc\u306b null \u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f\u3002";
            throw new HybsSystemException(string);
        }
        LDAPSearch lDAPSearch = new LDAPSearch();
        lDAPSearch.setSearchScope(this.searchScope);
        lDAPSearch.setTimeLimit(this.timeLimit);
        lDAPSearch.setDerefLinkFlag(this.derefLinkFlag);
        lDAPSearch.setReturningObjFlag(this.returningObjFlag);
        lDAPSearch.setMaxRowCount(this.maxRowCount);
        lDAPSearch.setAttributes(this.attrs);
        lDAPSearch.setInitctx(this.initctx);
        lDAPSearch.setProviderURL(this.providerURL);
        lDAPSearch.setSearchbase(this.searchbase);
        if (this.entrydn != null) {
            lDAPSearch.setEntrydn(this.entrydn);
        }
        if (this.password != null) {
            lDAPSearch.setPassword(this.password);
        }
        lDAPSearch.setOrderBy(this.orderBy);
        lDAPSearch.init();
        List<String[]> list = lDAPSearch.search(this.filter);
        this.executeCount = list.size();
        String[] stringArray = lDAPSearch.getAttributes();
        if (this.columns != null && this.columns.length > 0) {
            if (stringArray.length != this.columns.length) {
                String string = "attributes \u5c5e\u6027\u3068columns\u5c5e\u6027\u306e\u500b\u6570\u304c\u7570\u306a\u308a\u307e\u3059\u3002attrs=[" + this.attrs.length + "]:" + StringUtil.array2csv((String[])this.attrs) + HybsSystem.CR + " columns=[" + this.columns.length + "]:" + StringUtil.array2csv((String[])this.columns) + HybsSystem.CR;
                throw new HybsSystemException(string);
            }
            for (int i = 0; i < this.columns.length; ++i) {
                if (this.columns[i] == null || this.columns[i].length() <= 0) continue;
                stringArray[i] = this.columns[i];
            }
        }
        DBTableModel dBTableModel = null;
        if (stringArray.length > 0) {
            int n;
            dBTableModel = DBTableModelUtil.newDBTable();
            dBTableModel.init(stringArray.length);
            for (n = 0; n < stringArray.length; ++n) {
                DBColumn dBColumn = this.getResource().makeDBColumn(stringArray[n]);
                dBTableModel.setDBColumn(n, dBColumn);
            }
            for (n = 0; n < this.executeCount; ++n) {
                dBTableModel.addColumnValues(list.get(n));
            }
        }
        return dBTableModel;
    }

    public void setSearchScope(String string) {
        this.searchScope = StringUtil.nval((String)this.getRequestParameter(string), (String)this.searchScope);
    }

    public void setTimeLimit(String string) {
        this.timeLimit = StringUtil.nval((String)this.getRequestParameter(string), (int)this.timeLimit);
    }

    public void setDerefLinkFlag(String string) {
        this.derefLinkFlag = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.derefLinkFlag);
    }

    public void setReturningObjFlag(String string) {
        this.returningObjFlag = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.returningObjFlag);
    }

    public void setMaxRowCount(String string) {
        this.maxRowCount = StringUtil.nval((String)this.getRequestParameter(string), (int)this.maxRowCount);
    }

    public void setAttributes(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.attrs = StringUtil.csv2Array((String)string2);
        }
    }

    public void setColumns(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.columns = StringUtil.csv2Array((String)string2);
        }
    }

    public void setInitctx(String string) {
        this.initctx = StringUtil.nval((String)this.getRequestParameter(string), (String)this.initctx);
    }

    public void setProviderURL(String string) {
        this.providerURL = StringUtil.nval((String)this.getRequestParameter(string), (String)this.providerURL);
    }

    public void setSearchbase(String string) {
        this.searchbase = StringUtil.nval((String)this.getRequestParameter(string), (String)this.searchbase);
    }

    public void setFilter(String string) {
        this.filter = StringUtil.nval((String)this.getRequestParameter(string), (String)this.filter);
    }

    public void setEntrydn(String string) {
        this.entrydn = StringUtil.nval((String)this.getRequestParameter(string), (String)this.entrydn);
    }

    public void setPassword(String string) {
        this.password = StringUtil.nval((String)this.getRequestParameter(string), (String)this.password);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setOrderBy(String string) {
        this.orderBy = StringUtil.nval((String)this.getRequestParameter(string), (String)this.orderBy);
        if (this.orderBy != null) {
            this.orderBy = this.orderBy.toUpperCase(Locale.JAPAN);
        }
    }

    public void setCommand(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() > 0) {
            this.command = string2.toUpperCase(Locale.JAPAN);
        }
    }

    public void setDisplayMsg(String string) {
        this.displayMsg = this.getRequestParameter(string);
    }

    public void setNotfoundMsg(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null) {
            this.notfoundMsg = string2;
        }
    }

    public void setOverflowMsg(String string) {
        this.overflowMsg = this.getRequestParameter(string);
    }

    public void setMainTrans(String string) {
        this.isMainTrans = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isMainTrans);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("initctx", (Object)this.initctx).println("providerURL", (Object)this.providerURL).println("entrydn", (Object)this.entrydn).println("searchbase", (Object)this.searchbase).println("filter", (Object)this.filter).println("searchScope", (Object)this.searchScope).println("COUNTLIMIT", (Object)0L).println("timeLimit", (Object)this.timeLimit).println("attrs", (Object[])this.attrs).println("columns", (Object[])this.columns).println("returningObjFlag", (Object)this.returningObjFlag).println("derefLinkFlag", (Object)this.derefLinkFlag).println("tableId", (Object)this.tableId).println("orderBy", (Object)this.orderBy).println("command", (Object)this.command).println("executeCount", (Object)this.executeCount).println("errCode", (Object)this.errCode).println("maxRowCount", (Object)this.maxRowCount).println("displayMsg", (Object)this.displayMsg).println("overflowMsg", (Object)this.overflowMsg).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

