<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE1004"
	title    = "DB検索"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<og:query command="NEW" debug="{@debug}" dbid="{@DBID}" maxRowCount="0">
		select OWNER,OBJECT_NAME,OBJECT_TYPE,TYPE,TYPE2,STTS,'' DEL,'' COMPILE,
				TYPE || ':' || OBJECT_NAME || ':' || COALESCE(TYPE2,' ') AS SQL
		from (
			select OWNER,OBJECT_NAME,OBJECT_TYPE,
					CASE OBJECT_TYPE WHEN 'PACKAGE BODY' THEN 'PACKAGE' ELSE OBJECT_TYPE END TYPE,
					CASE OBJECT_TYPE WHEN 'PACKAGE BODY' THEN 'BODY'    ELSE ''          END TYPE2,
					STATUS AS STTS
			from ALL_OBJECTS
		<og:where>
			<og:and value="OWNER		= '{@OWNER}'"			/>
<!--		<og:and value="OBJECT_TYPE in ( {@OBJECT_TYPE} )" multi="true" />	-->
			<og:and value="STATUS		= 'INVALID'"			/>
			<og:and value="INSTR(OBJECT_NAME,'$') &lt; 1"		/>
			<og:and value="OBJECT_NAME like '{@OBJECT_NAME}%'"	/>
		</og:where>
	)
</og:query>

<og:columnEditor dbid="{@DBID}" column="SQL" renderer="QUERY" param="ALTER $1 {@OWNER}.$2 COMPILE $3" />

<!--
<og:tableUpdate command="ENTRY" queryType="JDBCTableUpdate" selectedAll="true">
	ALTER [TYPE] [OWNER].[OBJECT_NAME] COMPILE [TYPE2]
</og:tableUpdate>
-->

<og:viewLink command="{@command}">
	<og:link column="OBJECT_NAME" href="viewObject.jsp" target="SUB_WIND"
		keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,[OWNER],[OBJECT_TYPE],[OBJECT_NAME],{@DBID}" />
	<og:link column="STTS" href="viewObject.jsp" target="SUB_WIND" onLink="INVALID" markList="[STTS]"
		keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,[OWNER],ERRORS,[OBJECT_NAME],{@DBID}" />
	<og:link column="DEL" href="drop.jsp" target="SUB_WIND" onClick="return confirm('DROP [OBJECT_TYPE] [OBJECT_NAME]');"
		lbl="MSG0058"
		keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,[OWNER],[OBJECT_TYPE],[OBJECT_NAME],{@DBID}" />
	<og:link column="COMPILE" href="compile.jsp" target="SUB_WIND" lbl="SUBMIT"
		keys="command,OWNER,TYPE,TYPE2,NAME,DBID" vals="NEW,[OWNER],[TYPE],[TYPE2],[OBJECT_NAME],{@DBID}" />
</og:viewLink>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	writable   = "false"
	startNo    = "{@startNo}"
	noDisplay  = "OBJECT_TYPE"
	pageSize   = "10000"
/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
