<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジン"
	pgid	= "MAIL06"
	title	= "バッチ送信エラー検索"
	date	= "2009/04/01"
	author	= "S.Li"
	text	= ""
	version	= "001"
>
	5.6.8.0 (2013/09/06) order by変更,日付条件にの00,99付加
</og:comment>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" scope="request">
		SELECT	 PARA_KEY
				,ERRMSG
				,DYSET
				,USRSET
				,PGUPD
		FROM	GE36
	<og:where>
		<og:and value = "SYSTEM_ID		=	 '{@SYSTEM_ID}'" />	<!-- システムID     -->
		<og:and value = "PARA_KEY		=	 '{@PARA_KEY}'"	 />	<!-- パラメータキー -->
		<og:and value = "DYSET			&gt; '{@DYSET_FROM}00000000'"/>	<!-- 登録時間(FROM) -->
		<og:and value = "DYSET			&lt; '{@DYSET_TO}99999999'"  />	<!-- 登録時間(TO)   -->
		<og:and value = "COALESCE(FGJ,'0')	!=		'9'"		 />
	</og:where>
		order by PARA_KEY desc
</og:query>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- DB検索結果を表示させます。 -->
<og:view
	scope        = "request"
	viewFormType = "HTMLTable" 
	command      = "{@command}" 
	writable	 = "false"
/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
