/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.develop;

import java.util.List;
import java.util.Map;

import org.opengion.hayabusa.develop.JspConvertEntity;
import org.opengion.fukurou.xml.OGElement;

/**
 * query.jspの &lt;og:hideMenu&gt;タグ 内の &lt;og:column&gt;タグを作成します。
 * column タグは、部分置換ではなく、hideMenu内の、table 部分からの全面置換です。（部分置換は難しかったので）
 * hideMenu は、通常の column タグの出力制限以上のカラムを書き出します。
 * 具体的には、TD_COUNT（初期値=3）＊ TR_COUNT（初期値=2）を超える検索条件の時のみ行います。
 * それ以下の場合は、hideMenu タグは書き出しません。
 * 
 * これと、JspCreate_COLUMN クラスは、密接に関連していますので、ご注意ください。
 *
 * ●使用例
 *      &lt;table summary = "layout" &gt;
 *          &lt;tr&gt;&lt;og:column ・・・ /&gt; ・・・TD_COUNT（初期値=3）&lt;/tr&gt;
 *                  ・・・・ TR_COUNT（初期値=2）
 *      &lt;/table&gt;
 *   &lt;og:hideMenu&gt;
 *      &lt;table summary = "layout" &gt;
 *          &lt;tr&gt;
 *              &lt;og:column
 *                  name       = column.getColumnName() 
 *                  defaultVal = column.getDefaultValue()
 *                  must       = "true"         ("1".equals( column.getMust() ))
 *                  clazz      = "aimai"        (ope.startsWith( "lk" ))
 *              /&gt;
 *              &lt;og:column
 *                  ・・・・
 *              /&gt;
 *          &lt;/tr&gt;
 *          &lt;tr&gt;
 *                  ・・・・
 *          &lt;/tr&gt;
 *      &lt;/table&gt;
 *   &lt;/og:hideMenu&gt;
 *
 * @og.rev 5.6.4.4 (2013/05/31) 新規作成。hideMenu の対応
 *
 * @version  5.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK7.0,
 */
public class JspCreate_HIDEMENU extends JspCreate_COLUMN {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.3.9.1 (2015/11/27)" ;

	// 6.3.9.1 (2015/11/27) Variables should start with a lowercase character(PMD)
//	private List<JspConvertEntity> QUERY_ROWS ;
//	private boolean IS_NULL ;
	private List<JspConvertEntity> queryROWS ;
	private boolean isNULL ;

	/**
	 * コンストラクター
	 *
	 * インスタンス構築時に、タグ名(key)とファイル名(names)を指定します。
	 *
	 * @og.rev 6.3.9.1 (2015/11/27) コンストラクタを用意して、KEY,NAME をセットするように変更します。
	 */
	public JspCreate_HIDEMENU() {
		super( ":hideMenu" , "query" );
	}

	/**
	 * 初期化メソッド
	 *
	 * 内部で使用する JspConvertEntity の リスト のマップを受け取り、初期化を行います。
	 *
	 * @param	master	JspConvertEntityのリストのマップ
	 */
	@Override
	protected void init( final Map<String,List<JspConvertEntity>> master ) {
		queryROWS = master.get("QUERY");						// 6.3.9.1 (2015/11/27)
		isNULL = !isNotEmpty( queryROWS );						// 6.3.9.1 (2015/11/27)
//		QUERY_ROWS = master.get("QUERY");
//		IS_NULL = !isNotEmpty( QUERY_ROWS );
//		KEY  = ":hideMenu";
//		NAME = "query";
	}

	/**
	 * JSPに出力するタグの内容を作成します。
	 * 引数より作成前のタグの属性内容を確認するする事が出来ます。
	 *
	 * @param ele OGElementエレメントオブジェクト
	 * @param	nameSpace	このドキュメントのnameSpace( og とか mis とか )
	 *
	 * @return	変換された文字列
	 * @og.rtnNotNull
	 * @throws Throwable 変換時のエラー
	 */
	@Override
	protected String execute( final OGElement ele , final String nameSpace )  throws Throwable {
//		if( IS_NULL ) { return ""; }
		if( isNULL ) { return ""; }										// 6.3.9.1 (2015/11/27)

//		if( QUERY_ROWS.size() <= TD_COUNT*TR_COUNT ) { return ""; }		// 指定以上のカラムがないと、hideMenu を作成しません。
		if( queryROWS.size() <= TD_COUNT*TR_COUNT ) { return ""; }		// 指定以上のカラムがないと、hideMenu を作成しません。

		// 既存の設定値をすべて削除します。ホントは自動登録した分だけを削除すべき。
		final OGElement newEle  = new OGElement( "og:hideMenu" );

		final OGElement tblEle  = new OGElement( "table" );
		newEle.addNode( tblEle );

		OGElement tr = null;
//			for( int i=TD_COUNT*TR_COUNT; i<QUERY_ROWS.size(); i++ ) {
//				final JspConvertEntity column = QUERY_ROWS.get(i);
			for( int i=TD_COUNT*TR_COUNT; i<queryROWS.size(); i++ ) {		// 6.3.9.1 (2015/11/27)
				final JspConvertEntity column = queryROWS.get(i);			// 6.3.9.1 (2015/11/27)
				if( i%TD_COUNT == 0 ) {
					tr = new OGElement( "tr" );
					tblEle.addNode( tr );
				}
				tr = trElement( tr,column );
			}

		return newEle.getText( 0 );
	}
}
