/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* DYDIFF ( FUNCTION )                                                      */
/* Created : 2016/11/04 10:32:06                                            */
/****************************************************************************/
CREATE     
FUNCTION DYDIFF(
	DATE1   IN VARCHAR2  ,
	DATE2   IN VARCHAR2 := NULL ,
	PLUS    IN NUMBER   := 0 ,
	VIEW_ZOOM IN VARCHAR2 := NULL )
RETURN NUMBER
IS
    RTN     NUMBER(4);

BEGIN

	IF DATE2 IS NULL THEN
		-- 5.4.0.0 (2011/10/01) 月ベースの場合のみ(1ヶ月=30日計算)を行う。
		IF VIEW_ZOOM in ( '5','6','7','8','9' ) THEN
			-- 5.3.5.0 (2011/05/01) 長さ計算のバグ修正
			RTN := MONTHS_BETWEEN(TO_DATE( SUBSTRB(DATE1,1,8),'YYYYMMDD' ),TRUNC(SYSDATE))*30 + PLUS;
		ELSE
			RTN := TO_DATE( SUBSTRB(DATE1,1,8),'YYYYMMDD') - TRUNC(SYSDATE) + PLUS;
		END IF;
	ELSE
		-- 5.4.0.0 (2011/10/01) 月ベースの場合のみ(1ヶ月=30日計算)を行う。
		IF VIEW_ZOOM in ( '5','6','7','8','9' ) THEN
			-- 5.3.5.0 (2011/05/01) 長さ計算のバグ修正
			RTN := MONTHS_BETWEEN(TO_DATE( SUBSTRB(DATE1,1,8),'YYYYMMDD' ),TO_DATE( SUBSTRB(DATE2,1,8),'YYYYMMDD' ))*30 + PLUS;
		ELSE
			RTN := TO_DATE( SUBSTRB(DATE1,1,8),'YYYYMMDD' ) - TO_DATE( SUBSTRB(DATE2,1,8),'YYYYMMDD' ) + PLUS;
		END IF;
	END IF;

	IF RTN < 0 THEN RTN := 0; END IF;

	RETURN RTN;

END DYDIFF;
/
