/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.system;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.system.HybsConst;

public final class ThrowUtil {
    private static final int MIN_STACK_SIZE = 3;
    private static final int UNLIMITED_SIZE = -1;

    private ThrowUtil() {
    }

    public static String ogStackTrace(Throwable throwable) {
        return ThrowUtil.ogStackTrace(null, throwable);
    }

    public static String ogStackTrace(String string, Throwable throwable) {
        if (throwable == null) {
            return string;
        }
        CaseBuilder caseBuilder = new CaseBuilder().append("Version: ", "openGion 6.6.0.0 Release6 Builds (2016341)").append("Error  : ", throwable.getClass().getCanonicalName()).append("         ", throwable.getLocalizedMessage()).append("Message: ", string).addStackTrace(throwable, 3, -1);
        for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
            caseBuilder.append("Cause  : ", throwable2.getClass().getCanonicalName()).append("         ", throwable2.getLocalizedMessage()).addStackTrace(throwable2, 0, -1);
        }
        for (Throwable throwable3 : throwable.getSuppressed()) {
            caseBuilder.append("Suppressed : ", throwable3.getClass().getCanonicalName()).append("             ", throwable3.getLocalizedMessage()).addStackTrace(throwable3, 0, -1);
        }
        return caseBuilder.toString();
    }

    public static String ogThrowMsg(String string) {
        return ThrowUtil.ogThrowMsg(string, null);
    }

    public static String ogThrowMsg(String string, Throwable throwable) {
        Throwable throwable2 = throwable == null ? new Throwable() : throwable.getCause();
        Throwable throwable3 = throwable2 == null ? new Throwable() : throwable2;
        CaseBuilder caseBuilder = new CaseBuilder().append("Version: ", "openGion 6.6.0.0 Release6 Builds (2016341)").append("Error  : ", throwable3.getClass().getCanonicalName()).append("         ", throwable3.getLocalizedMessage()).append("Message: ", string).addStackTrace(throwable3, 3, 3);
        return caseBuilder.toString();
    }

    private static final class CaseBuilder {
        private static final String USE_KEY = "USE_KEY";
        private static final long CACHE_TIME = 2000L;
        private static final ConcurrentMap<String, String> MSG_MAP = new ConcurrentHashMap<String, String>();
        private static volatile long lastCall = 0L;
        private final StringBuilder buf = new StringBuilder(200);

        public CaseBuilder() {
            long l = System.currentTimeMillis();
            if (l - lastCall > 2000L) {
                lastCall = l;
                MSG_MAP.clear();
            }
        }

        public CaseBuilder append(String string, String string2) {
            String string3;
            if (string2 != null && !string2.isEmpty() && MSG_MAP.putIfAbsent(string3 = string2.trim(), USE_KEY) == null) {
                int n = string3.indexOf(10);
                if (n < 0) {
                    this.buf.append(HybsConst.CR).append(string).append(string3);
                } else {
                    String string4 = string3.substring(0, n).trim();
                    String string5 = string3.substring(n + 1).trim();
                    if (MSG_MAP.putIfAbsent(string4, USE_KEY) == null) {
                        this.buf.append(HybsConst.CR).append(string).append(string4);
                    }
                    if (MSG_MAP.putIfAbsent(string5, USE_KEY) == null) {
                        this.buf.append(HybsConst.CR).append(string).append(string5);
                    }
                }
            }
            return this;
        }

        public CaseBuilder addStackTrace(Throwable throwable, int n, int n2) {
            int n3 = 0;
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                String string = stackTraceElement.getClassName();
                if (n3 < n || !string.contains("ThrowUtil") && (string.contains("org.opengion") || string.contains("org.apache.jsp.jsp"))) {
                    this.append("    at   ", stackTraceElement.toString());
                } else {
                    this.append("    at   ", "....");
                }
                if (n2 > 0 && n3 >= n2) break;
                ++n3;
            }
            return this;
        }

        public String toString() {
            return this.buf.append(HybsConst.CR).toString();
        }
    }
}

