/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.filter;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opengion.fukurou.security.URLHashMap;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;

public final class URLHashFilter
implements Filter {
    private static final String REQ_KEY = "h_r";
    private static final int ACCS_LVL = HybsSystem.sysInt("URL_ACCESS_SECURITY_LEVEL");
    private String initPage = "/jsp/index.jsp";
    private String filename = "jsp/custom/refuseAccess.html";
    private boolean isDebug;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        httpServletRequest.setCharacterEncoding("UTF-8");
        if (this.isValidAccess(httpServletRequest)) {
            String string = httpServletRequest.getParameter(REQ_KEY);
            if (string != null && servletResponse instanceof HttpServletResponse) {
                HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
                String string2 = URLHashMap.getValue((String)string);
                if (string2 == null) {
                    String string3 = httpServletResponse.encodeRedirectURL(this.initPage);
                    httpServletResponse.sendRedirect(string3);
                } else {
                    String string4;
                    String string5 = httpServletRequest.getRequestURI();
                    if (string5.startsWith(string4 = httpServletRequest.getContextPath())) {
                        String string6 = string5.substring(string4.length()) + "?" + string2;
                        RequestDispatcher requestDispatcher = servletRequest.getRequestDispatcher(string6);
                        requestDispatcher.forward(servletRequest, servletResponse);
                    } else {
                        String string7 = httpServletResponse.encodeRedirectURL(string5 + "?" + string2);
                        httpServletResponse.sendRedirect(string7);
                    }
                }
            } else {
                filterChain.doFilter(servletRequest, servletResponse);
            }
        } else {
            servletResponse.setContentType("text/html; charset=UTF-8");
            PrintWriter printWriter = servletResponse.getWriter();
            printWriter.println(this.refuseMsg());
            printWriter.flush();
        }
    }

    public void init(FilterConfig filterConfig) {
        this.initPage = StringUtil.nval((String)filterConfig.getInitParameter("initPage"), (String)this.initPage);
        this.isDebug = StringUtil.nval((String)filterConfig.getInitParameter("debug"), (boolean)this.isDebug);
        this.filename = HybsSystem.getRealPath() + StringUtil.nval((String)filterConfig.getInitParameter("filename"), (String)this.filename);
    }

    public void destroy() {
    }

    private String refuseMsg() {
        return FileUtil.getValue((String)this.filename, (String)"UTF-8");
    }

    private boolean isValidAccess(HttpServletRequest httpServletRequest) {
        boolean bl;
        if (ACCS_LVL == 0) {
            return true;
        }
        String string = httpServletRequest.getHeader("Referer");
        String string2 = httpServletRequest.getRequestURI();
        String string3 = httpServletRequest.getQueryString();
        String string4 = httpServletRequest.getParameter(REQ_KEY);
        if (this.isDebug) {
            System.out.println("URLHashFilter#httpReferer = " + string);
            System.out.println("URLHashFilter#requestURI  = " + string2);
        }
        boolean bl2 = bl = string3 == null || string4 != null;
        if (ACCS_LVL == 1 || ACCS_LVL == 2) {
            return bl || string != null;
        }
        if (ACCS_LVL == 3) {
            String string5 = httpServletRequest.getContextPath();
            return bl || string2.equalsIgnoreCase(this.initPage) || string2.startsWith(string5 + "/jsp/menu/") || string2.startsWith(string5 + "/jsp/custom/") || string2.startsWith(string5 + "/jsp/common/");
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200).append(this.getClass().getCanonicalName()).append(" : ").append("initPage = [").append(this.initPage).append("] , ").append("isDebug  = [").append(this.isDebug).append("]");
        return stringBuilder.toString();
    }
}

