/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.report.RFIDPrintPointService;
import org.opengion.hayabusa.report2.QueueManager_DB;
import org.opengion.hayabusa.resource.ResourceFactory;
import org.opengion.hayabusa.resource.ResourceManager;

public class RFIDPrintRequest {
    private final StringBuilder errMsg = new StringBuilder(200);
    private ResourceManager resource;
    private final String SYSTEM_ID;
    private final String YKNO;
    private final String LISTID;
    private final String LANG;
    private final String FGRUN;
    private final String PRTID;
    private final String PRGDIR;
    private final String PRGFILE;
    private final String OUTDIR;
    private final boolean DEBUG;
    private final String FILENAME;
    private boolean fgLOCAL;
    private String prtName;
    private String hostName;
    private String portnm;
    private String fgkan = "8";
    private final ConcurrentMap<String, String[]> rfidLayoutMap = new ConcurrentHashMap<String, String[]>();
    private static final String GE54_SELECT = "SELECT BSQL,FGLOCAL,SYSTEM_ID FROM GE54 WHERE FGJ = '1' AND  SYSTEM_ID IN (?,'**') AND  LISTID = ?";
    private static final int GE54_FGLOCAL = 1;
    private static final int GE54_SYSTEM_ID = 2;
    private static final String HOST = HybsSystem.sysBool("VER4_COMPATIBLE_MODE") ? "HOST" : "HOST_ID";
    private static final String GE55_SELECT = "SELECT PRTNM," + HOST + ",SYSTEM_ID,PORTNM FROM GE55 WHERE FGJ = '1' AND  SYSTEM_ID IN (?,'**') AND  PRTID = ?";
    private static final int GE55_PRTNM = 0;
    private static final int GE55_HOST_ID = 1;
    private static final int GE55_SYSTEM_ID = 2;
    private static final int GE55_PORTNM = 3;
    private static final String CLM = HybsSystem.sysBool("VER4_COMPATIBLE_MODE") ? "COLUMN_NAME" : "CLM";
    private static final String GE58_SELECT = "SELECT KBOUT,DATA1,DATA2,DATA3,DATA4,DATA5,DATA6,DATA7,DATA8 ,DATA9,DATA10,DATA11,DATA12,DATA13,DATA14,DATA15," + CLM + " FROM GE58 WHERE SYSTEM_ID IN (?,'**') AND LISTID = ?";
    public static final int GE58_KBOUT = 0;
    public static final int GE58_DATA1 = 1;
    public static final int GE58_DATA2 = 2;
    public static final int GE58_DATA3 = 3;
    public static final int GE58_DATA4 = 4;
    public static final int GE58_DATA5 = 5;
    public static final int GE58_DATA6 = 6;
    public static final int GE58_DATA7 = 7;
    public static final int GE58_DATA8 = 8;
    public static final int GE58_DATA9 = 9;
    public static final int GE58_DATA10 = 10;
    public static final int GE58_DATA11 = 11;
    public static final int GE58_DATA12 = 12;
    public static final int GE58_DATA13 = 13;
    public static final int GE58_DATA14 = 14;
    public static final int GE58_DATA15 = 15;
    public static final int GE58_CLM_NAME = 16;
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");

    public RFIDPrintRequest(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl) {
        this.SYSTEM_ID = string;
        this.YKNO = string2;
        this.LISTID = string3;
        this.LANG = string4;
        this.FGRUN = string5;
        this.PRTID = string6;
        this.PRGDIR = string7;
        this.PRGFILE = string8;
        this.OUTDIR = string9;
        this.DEBUG = bl;
        this.FILENAME = string10;
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYSTEM_ID, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("ReportConverter", this.YKNO, this.LISTID);
        } else {
            this.appInfo = null;
        }
    }

    public boolean initialDataSet() {
        String[][] stringArray;
        String string;
        String[] stringArray2 = new String[]{this.SYSTEM_ID, this.LISTID};
        String[][] stringArray3 = DBUtil.dbExecute((String)GE54_SELECT, (String[])stringArray2, (ApplicationInfo)this.appInfo, (String)this.DBID);
        if (stringArray3 == null || stringArray3.length == 0) {
            this.errMsg.append("Data does not exist in GE54 table.").append(HybsConst.CR).append("==============================").append(HybsConst.CR).append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , LISTID=[").append(this.LISTID).append(']').append(HybsConst.CR);
            return false;
        }
        int n = 0;
        for (int i = 0; i < stringArray3.length; ++i) {
            if (!this.SYSTEM_ID.equalsIgnoreCase(stringArray3[i][2])) continue;
            n = i;
            break;
        }
        this.fgLOCAL = (string = stringArray3[n][1]) != null && "1".equals(string.trim());
        String[] stringArray4 = new String[]{this.SYSTEM_ID, this.LISTID};
        String[][] stringArray5 = DBUtil.dbExecute((String)GE58_SELECT, (String[])stringArray4, (ApplicationInfo)this.appInfo, (String)this.DBID);
        for (int i = 0; i < stringArray5.length; ++i) {
            stringArray = stringArray5[i][16];
            if (stringArray == null) continue;
            this.rfidLayoutMap.put((String)stringArray, stringArray5[i]);
        }
        String[] stringArray6 = new String[]{this.SYSTEM_ID, this.PRTID};
        stringArray = DBUtil.dbExecute((String)GE55_SELECT, (String[])stringArray6, (ApplicationInfo)this.appInfo, (String)this.DBID);
        if (stringArray == null || stringArray.length == 0) {
            this.errMsg.append("Data does not exist in GE55 table.").append(HybsConst.CR).append("==============================").append(HybsConst.CR).append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , PRTID=[").append(this.PRTID).append(']').append(HybsConst.CR);
            return false;
        }
        int n2 = 0;
        for (int i = 0; i < stringArray3.length; ++i) {
            if (!this.SYSTEM_ID.equalsIgnoreCase(stringArray3[i][2])) continue;
            n2 = i;
            break;
        }
        this.prtName = stringArray[n2][0];
        this.hostName = stringArray[n2][1];
        this.portnm = stringArray[n2][3];
        return true;
    }

    public boolean execute() {
        System.out.print("RRID RequestData Creating ... ");
        this.resource = this.fgLOCAL ? ResourceFactory.newInstance(this.SYSTEM_ID, this.LANG, false) : ResourceFactory.newInstance(this.LANG);
        QueueManager_DB.DBTableModelCreator dBTableModelCreator = new QueueManager_DB.DBTableModelCreator(this.SYSTEM_ID, this.LISTID, this.YKNO, "B", this.resource);
        DBTableModel dBTableModel = dBTableModelCreator.getTable();
        if (dBTableModel.getRowCount() <= 0) {
            this.errMsg.append("Database Body row count is Zero.").append(HybsConst.CR);
            this.errMsg.append("==============================").append(HybsConst.CR);
            this.errMsg.append("SYSTEM_ID=").append(this.SYSTEM_ID);
            this.errMsg.append(",LISTID=").append(this.LISTID);
            this.errMsg.append(",YKNO=").append(this.YKNO);
            this.errMsg.append(HybsConst.CR);
            return false;
        }
        if (dBTableModel.isOverflow()) {
            this.errMsg.append("Database is Overflow. [");
            this.errMsg.append(dBTableModel.getRowCount());
            this.errMsg.append(']').append(HybsConst.CR).append(HybsConst.CR);
            this.errMsg.append("==============================").append(HybsConst.CR);
            this.errMsg.append("Check SystemParameter Data in DB_MAX_ROW_COUNT Overflow");
            this.errMsg.append(HybsConst.CR);
            return false;
        }
        RFIDPrintPointService rFIDPrintPointService = null;
        try {
            rFIDPrintPointService = (RFIDPrintPointService)StringUtil.newInstance((String)HybsSystem.sys("REPORT_RFID_SERVICE_CLASS"));
            rFIDPrintPointService.setYkno(this.YKNO);
            rFIDPrintPointService.setSystemId(this.SYSTEM_ID);
            rFIDPrintPointService.setFgrun(this.FGRUN);
            rFIDPrintPointService.setHostName(this.hostName);
            rFIDPrintPointService.setPrinterName(this.prtName);
            rFIDPrintPointService.setTable(dBTableModel);
            rFIDPrintPointService.setLayout(this.rfidLayoutMap);
            rFIDPrintPointService.setPrgDir(this.PRGDIR);
            rFIDPrintPointService.setPrgFile(this.PRGFILE);
            rFIDPrintPointService.setOutDir(this.OUTDIR);
            rFIDPrintPointService.setPrtId(this.PRTID);
            rFIDPrintPointService.setPortnm(this.portnm);
            rFIDPrintPointService.setListId(this.LISTID);
            rFIDPrintPointService.setLayoutFile(this.FILENAME);
            boolean bl = rFIDPrintPointService.execute();
            this.fgkan = rFIDPrintPointService.getFgkan();
            if (this.DEBUG) {
                System.out.println(rFIDPrintPointService);
            }
            if (!bl) {
                this.errMsg.append(rFIDPrintPointService.getErrMsg());
                return false;
            }
        }
        catch (Throwable throwable) {
            this.fgkan = "8";
            this.errMsg.append("RFID Print Request Execution Error. ").append(HybsConst.CR).append("==============================").append(HybsConst.CR).append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , YKNO=[").append(this.YKNO).append(']').append(HybsConst.CR).append(HybsSystem.sys("REPORT_RFID_SERVICE_CLASS")).append(HybsConst.CR).append(throwable.toString()).append(HybsConst.CR);
            if (rFIDPrintPointService != null) {
                this.errMsg.append(rFIDPrintPointService.getErrMsg());
            }
            return false;
        }
        System.out.println("End.");
        return true;
    }

    public String getErrMsg() {
        return this.errMsg.toString();
    }

    public String getFgkan() {
        return this.fgkan;
    }
}

