/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.model.DataModel;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.html.ViewMarker;

public class ViewMarker_MARKER
implements ViewMarker {
    private static final int MARK_NULL = -1;
    private static final int MARK_TRUE = 1;
    private static final int MARK_FALSE = 0;
    private List<Attributes> markData;
    private final ConcurrentMap<Integer, Formatter> formMap = new ConcurrentHashMap<Integer, Formatter>();
    private DBTableModel table;
    private int[] markCmlNo;
    private int[] isMark;
    private String[] markKey;
    private String[] markLists;
    private String[] instrVals;
    private int[] markListNo;
    private boolean[] useFmtDeco;
    private final ConcurrentMap<Integer, List<Integer>> clmMap = new ConcurrentHashMap<Integer, List<Integer>>();

    @Override
    public void clear() {
        this.markData = null;
        this.formMap.clear();
        this.table = null;
        this.isMark = null;
        this.markKey = null;
        this.markLists = null;
        this.instrVals = null;
        this.markListNo = null;
        this.clmMap.clear();
        this.useFmtDeco = null;
    }

    @Override
    public void addAttribute(Attributes attributes) {
        if (this.markData == null) {
            this.markData = new ArrayList<Attributes>();
        }
        this.markData.add(attributes);
    }

    @Override
    public boolean isUsable() {
        return this.markData != null && this.markData.size() > 0;
    }

    @Override
    public void setDBTableModel(DBTableModel dBTableModel) {
        this.table = dBTableModel;
        int n2 = this.markData.size();
        this.isMark = new int[n2];
        this.markKey = new String[n2];
        this.markCmlNo = new int[n2];
        this.markLists = new String[n2];
        this.instrVals = new String[n2];
        this.markListNo = new int[n2];
        this.useFmtDeco = new boolean[n2];
        Arrays.fill(this.isMark, 0);
        Arrays.fill(this.markCmlNo, -1);
        Arrays.fill(this.useFmtDeco, false);
        for (int i = 0; i < n2; ++i) {
            Attributes attributes = this.markData.get(i);
            String string = attributes.get("column");
            int n3 = this.table.getColumnNo(string);
            this.clmMap.computeIfAbsent(n3, n -> new ArrayList()).add(i);
            String string2 = attributes.get("body");
            Formatter formatter = new Formatter((DataModel)this.table, string2);
            this.formMap.put(i, formatter);
            this.makeOnMarkFormat(i, attributes);
            this.useFmtDeco[i] = "true".equalsIgnoreCase(attributes.get("useFormatDeco"));
        }
    }

    @Override
    public String getMarkerString(int n, int n2, String string) {
        Object object;
        int n3;
        int n4 = this.isOnMark(n, n2);
        if (n4 < 0) {
            return string;
        }
        Formatter formatter = (Formatter)this.formMap.get(n4);
        int[] nArray = formatter.getClmNos();
        String[] stringArray = formatter.getFormat();
        char[] cArray = formatter.getType();
        StringBuilder stringBuilder = new StringBuilder(500);
        for (n3 = 0; n3 < nArray.length; ++n3) {
            String string2 = n2 == nArray[n3] && cArray[n3] != '!' ? string : formatter.getValue(n, nArray[n3]);
            if (this.useFmtDeco[n4]) {
                object = this.table.getDBColumn(nArray[n3]);
                if (cArray[n3] == '$') {
                    string2 = ((DBColumn)object).getRendererValue(n, string2);
                } else if (cArray[n3] == '#') {
                    string2 = ((DBColumn)object).getLabel();
                }
            } else if (cArray[n3] == '$') {
                string2 = StringUtil.urlEncode((String)string2);
            }
            stringBuilder.append(stringArray[n3]);
            stringBuilder.append(string2);
        }
        if (n3 < stringArray.length) {
            stringBuilder.append(stringArray[n3]);
        }
        object = StringUtil.replace((String)stringBuilder.toString(), (String)"{I}", (String)String.valueOf(n));
        if (this.instrVals[n4] != null) {
            String[] stringArray2 = StringUtil.csv2Array((String)this.instrVals[n4], (char)' ');
            for (int i = 0; i < stringArray2.length; ++i) {
                String string3 = "<span class=\"instr" + i + "\">" + stringArray2[i] + "</span>";
                object = StringUtil.replace((String)object, (String)stringArray2[i], (String)string3);
            }
        }
        return object;
    }

    private void makeOnMarkFormat(int n, Attributes attributes) {
        String string = attributes.get("onMark");
        String string2 = attributes.get("markList");
        this.instrVals[n] = attributes.get("instrVals");
        this.isMark[n] = -1;
        if (string == null || string.isEmpty() || string2 == null || string2.isEmpty()) {
            this.isMark[n] = 0;
            return;
        }
        if (string.charAt(0) != '[' && string2.charAt(0) != '[') {
            this.isMark[n] = string2.indexOf(string) >= 0 ? 1 : 0;
            return;
        }
        if (string.charAt(0) == '[') {
            this.markCmlNo[n] = this.table.getColumnNo(string.substring(1, string.length() - 1));
        } else {
            this.markCmlNo[n] = -1;
            this.markKey[n] = string;
        }
        if (string2.charAt(0) == '[') {
            this.markListNo[n] = this.table.getColumnNo(string2.substring(1, string2.length() - 1));
        } else {
            this.markListNo[n] = -1;
            this.markLists[n] = string2;
        }
    }

    private int isOnMark(int n, int n2) {
        List list = (List)this.clmMap.get(n2);
        if (list == null) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            String string;
            String string2;
            int n3 = (Integer)list.get(i);
            if (!(this.isMark[n3] != -1 ? this.isMark[n3] == 1 : (string2 = this.markCmlNo[n3] < 0 ? this.markKey[n3] : (String)this.table.getValue(n, this.markCmlNo[n3])) != null && !string2.isEmpty() && (string = this.markListNo[n3] < 0 ? this.markLists[n3] : (String)this.table.getValue(n, this.markListNo[n3])) != null && !string.isEmpty() && (string.charAt(0) == '?' ? string2.matches(string.substring(1)) : string.indexOf(string2) >= 0))) continue;
            return n3;
        }
        return -1;
    }

    @Override
    public int[] getColumnNos() {
        int[] nArray = new int[this.clmMap.size()];
        int n = 0;
        for (Integer n2 : this.clmMap.keySet()) {
            nArray[n++] = n2;
        }
        return nArray;
    }
}

