/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.ResultSetValue;
import org.opengion.fukurou.db.TransactionReal;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBColumnConfig;
import org.opengion.hayabusa.db.DBEditConfig;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelEditor;
import org.opengion.hayabusa.db.DBTableModelImpl;
import org.opengion.hayabusa.db.Query;
import org.opengion.hayabusa.db.QueryFactory;
import org.opengion.hayabusa.resource.LabelData;
import org.opengion.hayabusa.resource.ResourceManager;

public final class DBTableModelUtil {
    private DBTableModelUtil() {
    }

    public static DBTableModel makeDBTable(String string, String[] stringArray, ResourceManager resourceManager, ApplicationInfo applicationInfo) {
        return DBTableModelUtil.makeDBTable(string, stringArray, resourceManager, applicationInfo, null);
    }

    public static DBTableModel makeDBTable(String string, String[] stringArray, ResourceManager resourceManager, ApplicationInfo applicationInfo, String string2) {
        DBTableModel dBTableModel;
        block14: {
            if (string == null || string.isEmpty()) {
                return null;
            }
            dBTableModel = null;
            try (TransactionReal transactionReal = new TransactionReal(applicationInfo);){
                Query query = QueryFactory.newInstance("JDBCPrepared");
                query.setConnection(transactionReal.getConnection(string2));
                query.setResourceManager(resourceManager);
                query.setStatement(string);
                query.execute(stringArray);
                int n = query.getErrorCode();
                int n2 = query.getExecuteCount();
                if (n < 2 && n2 >= 0) {
                    dBTableModel = query.getDBTableModel();
                    transactionReal.commit();
                    break block14;
                }
                transactionReal.rollback();
                ErrorMessage errorMessage = query.getErrorMessage();
                throw new HybsSystemException(errorMessage.toString());
            }
        }
        return dBTableModel;
    }

    public static DBTableModel newDBTable() {
        return new DBTableModelImpl();
    }

    public static DBTableModel makeDBTable(String[] stringArray, String[][] stringArray2, ResourceManager resourceManager) {
        int n;
        if (stringArray == null || stringArray.length == 0 || stringArray2 == null || stringArray2.length == 0 || stringArray2[0] == null || stringArray2[0].length == 0) {
            return null;
        }
        if (stringArray.length != stringArray2[0].length) {
            String string = "\u30ad\u30fc\u306e\u30ab\u30e9\u30e0\u6570\u3068\u30c7\u30fc\u30bf\u306e\u30ab\u30e9\u30e0\u6570\u304c\u4e00\u81f4\u3057\u3066\u3044\u307e\u305b\u3093\u3002" + HybsConst.CR + " clms.length=[" + stringArray.length + "]  vals.length=[" + stringArray2[0].length + "] clms=" + StringUtil.array2csv((String[])stringArray) + HybsConst.CR + " vals=" + StringUtil.array2csv((String[])stringArray2[0]);
            throw new HybsSystemException(string);
        }
        int n2 = stringArray.length;
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        dBTableModel.init(n2);
        DBColumn[] dBColumnArray = new DBColumn[n2];
        for (n = 0; n < n2; ++n) {
            dBColumnArray[n] = resourceManager.makeDBColumn(stringArray[n]);
            dBTableModel.setDBColumn(n, dBColumnArray[n]);
        }
        n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            dBTableModel.addColumnValues(stringArray2[i]);
        }
        return dBTableModel;
    }

    public static DBTableModel makeDBTable(ResultSet resultSet, int n, int n2, ResourceManager resourceManager) throws SQLException {
        int n3;
        if (resultSet == null || resourceManager == null) {
            return null;
        }
        ResultSetValue resultSetValue = new ResultSetValue(resultSet);
        int n4 = resultSetValue.getColumnCount();
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        dBTableModel.init(n4);
        for (n3 = 0; n3 < n4; ++n3) {
            String string = resultSetValue.getColumnName(n3);
            DBColumn dBColumn = resourceManager.getDBColumn(string);
            if (dBColumn == null) {
                dBColumn = DBTableModelUtil.makeDBColumn(string, n3, resultSetValue, resourceManager);
            }
            dBTableModel.setDBColumn(n3, dBColumn);
        }
        for (n3 = 0; n3 < n && resultSetValue.next(); ++n3) {
        }
        for (n3 = 0; n3 < n2 && resultSetValue.next(); ++n3) {
            dBTableModel.addColumnValues(resultSetValue.getValues());
        }
        if (n3 >= n2 && resultSetValue.next()) {
            dBTableModel.setOverflow(true);
        }
        return dBTableModel;
    }

    public static DBTableModel makeEditDBTable(ResultSet resultSet, int n, int n2, ResourceManager resourceManager, DBEditConfig dBEditConfig) throws SQLException {
        if (resultSet == null || resourceManager == null) {
            return null;
        }
        DBTableModelEditor dBTableModelEditor = new DBTableModelEditor();
        dBTableModelEditor.create(resultSet, n, n2, resourceManager, dBEditConfig);
        return dBTableModelEditor;
    }

    public static DBColumn makeDBColumn(String string, int n, ResultSetValue resultSetValue, ResourceManager resourceManager) {
        DBColumn dBColumn;
        LabelData labelData = resourceManager.getLabelData(string);
        String string2 = resourceManager.getLang();
        try {
            String string3 = resultSetValue.getClassName(n);
            int n2 = resultSetValue.getColumnDisplaySize(n);
            if (n2 == 0) {
                n2 = 60;
            }
            boolean bl = resultSetValue.isWritable(n);
            String string4 = "NUMBER".equals(string3) ? "S9" : "XK";
            String string5 = "NUMBER".equals(string3) ? "0" : "";
            DBColumnConfig dBColumnConfig = new DBColumnConfig(string2, string, labelData, string3, null, null, String.valueOf(n2), String.valueOf(bl), null, null, null, string4, string5, null, null, null, null, false, null);
            dBColumn = new DBColumn(dBColumnConfig);
        }
        catch (RuntimeException runtimeException) {
            String string6 = "\u4e88\u671f\u305b\u306c\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002name=[" + string + " , label=[" + labelData + "]";
            throw new HybsSystemException(string6, runtimeException);
        }
        return dBColumn;
    }
}

