/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.taglet;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opengion.fukurou.taglet.DocletTagWriter;
import org.opengion.fukurou.taglet.DocletUtil;

public final class DocletSpecific {
    private static final String SELECT_PACKAGE = "org.opengion";
    private static final boolean NOT_PRIVATE = false;
    private static final String ENCODE = "UTF-8";
    private static final String OG_FOR_SMPL = "og.formSample";
    private static final String OG_REV = "og.rev";
    private static final String OG_TAG_NAME = "og.tag";
    private static final String OG_GROUP = "og.group";
    private static final String DOC_VERSION = "version";
    private static final String DOC_AUTHOR = "author";
    private static final String DOC_SINCE = "since";
    private static final String DOC_PARAM = "param";
    private static final String DOC_RETURN = "return";
    private static final String CONSTRUCTOR = "\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf";
    private static final String METHOD = "\u30e1\u30bd\u30c3\u30c9";
    private static final Set<String> METHOD_SET = new HashSet<String>();
    private static int debugLevel;
    private static final Pattern PTN;

    private DocletSpecific() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean start(RootDoc rootDoc) {
        String string = DocletUtil.getOption("-version", rootDoc.options());
        String string2 = DocletUtil.getOption("-outfile", rootDoc.options());
        String string3 = DocletUtil.getOption("-debugLevel", rootDoc.options());
        if (string3 != null) {
            debugLevel = Integer.parseInt(string3);
        }
        try (DocletTagWriter docletTagWriter = null;){
            docletTagWriter = new DocletTagWriter(string2, ENCODE);
            docletTagWriter.printTag("<?xml version=\"1.0\" encoding=\"", ENCODE, "\" ?>");
            docletTagWriter.printTag("<javadoc>");
            docletTagWriter.printTag("  <version>", string, "</version>");
            docletTagWriter.printTag("  <description></description>");
            DocletSpecific.writeContents(rootDoc.classes(), docletTagWriter);
            docletTagWriter.printTag("</javadoc>");
        }
        return true;
    }

    private static void writeContents(ClassDoc[] classDocArray, DocletTagWriter docletTagWriter) {
        for (int i = 0; i < classDocArray.length; ++i) {
            ClassDoc classDoc = classDocArray[i];
            String string = classDoc.name();
            String string2 = classDoc.qualifiedName();
            String string3 = (classDoc.modifiers() + (classDoc.isClass() ? " class" : "")).trim();
            Type type2 = classDoc.superclassType();
            String string4 = type2 == null ? "" : type2.qualifiedTypeName();
            String string5 = Stream.of(classDoc.interfaceTypes()).map(type -> type.qualifiedTypeName()).collect(Collectors.joining(","));
            Tag[] tagArray = classDoc.firstSentenceTags();
            Tag[] tagArray2 = classDoc.inlineTags();
            Tag[] tagArray3 = classDoc.tags(OG_FOR_SMPL);
            Tag[] tagArray4 = classDoc.tags(OG_REV);
            Tag[] tagArray5 = classDoc.tags(DOC_VERSION);
            Tag[] tagArray6 = classDoc.tags(DOC_AUTHOR);
            Tag[] tagArray7 = classDoc.tags(DOC_SINCE);
            Tag[] tagArray8 = classDoc.tags(OG_GROUP);
            docletTagWriter.printTag("<classDoc>");
            docletTagWriter.printTag("  <fullName>", string2, "</fullName>");
            docletTagWriter.printTag("  <modifiers>", string3, "</modifiers>");
            docletTagWriter.printTag("  <className>", string, "</className>");
            docletTagWriter.printTag("  <superClass>", string4, "</superClass>");
            docletTagWriter.printTag("  <interface>", string5, "</interface>");
            docletTagWriter.printTag("  <createVer>", tagArray5, "</createVer>");
            docletTagWriter.printTag("  <author>", tagArray6, "</author>");
            docletTagWriter.printTag("  <since>", tagArray7, "</since>");
            docletTagWriter.printTag("  <description>", tagArray, "</description>");
            docletTagWriter.printTag("  <contents>", tagArray2, "</contents>");
            docletTagWriter.printTag("  <classGroup>");
            docletTagWriter.printCSVTag(tagArray8);
            docletTagWriter.printTag("  </classGroup>");
            docletTagWriter.printTag("  <formSample>", tagArray3, "</formSample>");
            docletTagWriter.printTag("  <history>", tagArray4, "</history>");
            if (debugLevel >= 2 && (tagArray2.length == 0 || tagArray.length == 0) && string4.isEmpty()) {
                System.err.println("\u8b66\u544a2:\u30b3\u30e1\u30f3\u30c8C=\t" + classDoc.position());
            }
            int n = 0;
            DocletSpecific.checkPMD(classDoc);
            DocletSpecific.checkTag2(classDoc);
            while (true) {
                ConstructorDoc[] constructorDocArray = classDoc.constructors(false);
                for (int j = 0; j < constructorDocArray.length; ++j) {
                    if (!DocletSpecific.isAction((ExecutableMemberDoc)constructorDocArray[j], n)) continue;
                    if (n < 2) {
                        DocletSpecific.checkTag((ExecutableMemberDoc)constructorDocArray[j]);
                    }
                    DocletSpecific.menberTag((ExecutableMemberDoc)constructorDocArray[j], CONSTRUCTOR, docletTagWriter, n);
                }
                MethodDoc[] methodDocArray = classDoc.methods(false);
                for (int j = 0; j < methodDocArray.length; ++j) {
                    if (!DocletSpecific.isAction((ExecutableMemberDoc)methodDocArray[j], n)) continue;
                    if (n < 2) {
                        DocletSpecific.checkTag((ExecutableMemberDoc)methodDocArray[j]);
                    }
                    DocletSpecific.menberTag((ExecutableMemberDoc)methodDocArray[j], METHOD, docletTagWriter, n);
                }
                Type type3 = classDoc.superclassType();
                if (type3 == null || "java.lang.Object".equals(string2 = (classDoc = type3.asClassDoc()).qualifiedName()) || classDoc.isEnum()) break;
                if (string2.startsWith(SELECT_PACKAGE)) {
                    n = 1;
                    continue;
                }
                n = 2;
            }
            docletTagWriter.printTag("  </classDoc>");
        }
    }

    private static boolean isAction(ExecutableMemberDoc executableMemberDoc, int n) {
        String string = executableMemberDoc.name();
        boolean bl = !METHOD_SET.add(executableMemberDoc.toString()) || n > 0 && executableMemberDoc.isPrivate() || string.length() > 0 && string.charAt(0) == '<';
        return !bl;
    }

    private static void checkTag(ExecutableMemberDoc executableMemberDoc) {
        String[] stringArray;
        int n;
        MethodDoc methodDoc;
        Tag[] tagArray;
        Type type;
        String string;
        Type type2 = executableMemberDoc.containingClass().superclassType();
        String string2 = string = type2 == null ? "" : type2.qualifiedTypeName();
        if ("java.lang.Enum".equals(string)) {
            return;
        }
        SourcePosition sourcePosition = executableMemberDoc.position();
        if (executableMemberDoc instanceof MethodDoc) {
            int n2;
            type = ((MethodDoc)executableMemberDoc).returnType();
            tagArray = type.typeName();
            StringBuilder stringBuilder = new StringBuilder(200).append(sourcePosition).append("\t").append(executableMemberDoc.modifiers()).append(' ').append((String)tagArray);
            if (type.dimension() != null) {
                stringBuilder.append(type.dimension());
            }
            String string3 = stringBuilder.toString();
            Tag[] tagArray2 = executableMemberDoc.tags(DOC_RETURN);
            if (tagArray2.length > 0) {
                methodDoc = tagArray2[0].text().trim();
                string3 = string3 + "\t" + (String)methodDoc;
                if (debugLevel >= 1 && "void".equals(tagArray)) {
                    System.err.println("\u8b66\u544a1:RTN\u30b3\u30e1\u30f3\u30c8\u4e0d\u8981=\t" + string3);
                }
                if (debugLevel >= 2 && PTN.matcher((CharSequence)methodDoc).matches()) {
                    System.err.println("\u8b66\u544a2:RTN\u672a\u89e3\u8aac=\t" + string3);
                }
                if (debugLevel >= 2 && methodDoc.equals(tagArray)) {
                    System.err.println("\u8b66\u544a2:RTN\u4e00\u81f4=\t" + string3);
                }
                if (debugLevel >= 2 && (methodDoc.indexOf("[]") >= 0 || methodDoc.indexOf(62) - methodDoc.indexOf(60) > 3)) {
                    System.err.println("\u8b66\u544a2:RTN\u914d\u5217=\t" + string3);
                }
                if (debugLevel >= 3 && (methodDoc.indexOf((String)tagArray + " ") >= 0 || methodDoc.indexOf((String)tagArray + "\t") >= 0)) {
                    System.err.println("\u8b66\u544a3:RTN\u30bf\u30a4\u30d7=\t" + string3);
                }
                int n3 = methodDoc.indexOf(32);
                if (debugLevel >= 3 && n3 > 0) {
                    n2 = 1;
                    for (n = 0; n < n3; ++n) {
                        char c = methodDoc.charAt(n);
                        if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '[' || c == ']') continue;
                        n2 = 0;
                        break;
                    }
                    if (n2 != 0) {
                        System.err.println("\u8b66\u544a3:RTN\u5024=\t" + string3);
                    }
                }
            } else if (debugLevel >= 1 && !"void".equals(tagArray)) {
                System.err.println("\u8b66\u544a1:RTN\uff7a\uff92\uff9d\uff84\u306a\u3057=\t" + string3);
            }
            methodDoc = ((MethodDoc)executableMemberDoc).overriddenMethod();
            if (debugLevel >= 3 && methodDoc != null) {
                AnnotationDesc[] annotationDescArray = executableMemberDoc.annotations();
                if (annotationDescArray.length == 0) {
                    System.err.println("\u8b66\u544a3:@Override\u306a\u3057=\t" + string3);
                }
                for (n2 = 0; n2 < annotationDescArray.length; ++n2) {
                    String string4;
                    AnnotationTypeDoc annotationTypeDoc = annotationDescArray[n2].annotationType();
                    if (!"Deprecated".equalsIgnoreCase(annotationTypeDoc.name()) || (string4 = executableMemberDoc.commentText()) == null || string4.indexOf("\u3010\u5ec3\u6b62\u3011") >= 0) continue;
                    System.err.println("\u8b66\u544a3:\u3010\u5ec3\u6b62\u3011=\t" + sourcePosition + "\t" + executableMemberDoc.name());
                }
            }
        }
        type = executableMemberDoc.parameters();
        tagArray = executableMemberDoc.tags(DOC_PARAM);
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < tagArray.length; ++i) {
            if (((Type)type).length > n4) {
                methodDoc = type[n4].type().typeName();
                String string5 = type[n4].name();
                String string6 = tagArray[i].text().trim();
                String[] stringArray2 = string6.split("[\\s]+");
                if (stringArray2[0].length() == 3 && stringArray2[0].charAt(0) == '<' && stringArray2[0].charAt(2) == '>') continue;
                ++n5;
                String string7 = string6.replaceAll(string5, "").trim();
                stringArray = string7.replaceAll((String)methodDoc, "").replaceAll("\\[\\]", "").trim();
                String string8 = sourcePosition + "\t" + string6;
                if (debugLevel >= 1 && string6.indexOf(string5) < 0) {
                    System.err.println("\u8b66\u544a1:PRM\u5f15\u6570\u540d=\t" + string8);
                }
                if (debugLevel >= 2 && string5.length() == 1) {
                    System.err.println("\u8b66\u544a2:PRM\u77ed\u3044=\t" + string8);
                }
                if (debugLevel >= 2 && (PTN.matcher(string7).matches() || stringArray.isEmpty())) {
                    System.err.println("\u8b66\u544a2:PRM\u672a\u89e3\u8aac=\t" + string8);
                }
                if (debugLevel >= 2 && (string6.indexOf("[]") >= 0 || string6.indexOf(60) >= 0)) {
                    System.err.println("\u8b66\u544a2:PRM\u914d\u5217=\t" + string8);
                }
                if (debugLevel >= 3 && string8.contains("taglib")) {
                    if (string7.indexOf(91) > 0 && string7.indexOf(" [") < 0 && !methodDoc.startsWith("boolean")) {
                        System.err.println("\u8b66\u544a3:\uff97\uff8d\uff9e\uff99 [\uff7a\uff70\uff84\uff9e]=\t" + string8);
                    }
                    if (string7.indexOf(91) < 0 && !string5.startsWith("user") && !string5.startsWith("usemap") && !string5.startsWith("ismap") && methodDoc.startsWith("boolean")) {
                        System.err.println("\u8b66\u544a3:bool[]\u7121=\t" + string8);
                    }
                    String string9 = type[n4].type().dimension();
                    if (executableMemberDoc.isVarArgs() && string9.endsWith("[]") && !string7.contains("\u53ef\u5909\u9577\u5f15\u6570") || !string9.endsWith("[]") && string7.contains("\u53ef\u5909\u9577\u5f15\u6570")) {
                        System.err.println("\u8b66\u544a3:\u53ef\u5909\u9577\u5f15\u6570=\t" + string8);
                    }
                }
            }
            ++n4;
        }
        if (debugLevel >= 1 && n5 != ((Type)type).length) {
            System.err.println("\u8b66\u544a1:PRM\u500b\u6570\u9055\u3044=\t" + sourcePosition);
        }
        Tag[] tagArray3 = executableMemberDoc.firstSentenceTags();
        methodDoc = executableMemberDoc.inlineTags();
        if (executableMemberDoc instanceof MethodDoc && !executableMemberDoc.isSynthetic() && !executableMemberDoc.isNative() && debugLevel >= 2) {
            String string10;
            String string11 = sourcePosition + "\t" + executableMemberDoc.name();
            StringBuilder stringBuilder = new StringBuilder(200);
            for (n = 0; n < tagArray3.length; ++n) {
                stringBuilder.append(tagArray3[n].text().trim());
            }
            if (((MethodDoc)methodDoc).length == 0 || tagArray3.length == 0) {
                System.err.println("\u8b66\u544a2:\u30b3\u30e1\u30f3\u30c8M=\t" + string11);
            } else if (tagArray3.length > 0 && ((n = stringBuilder.indexOf("\u3002")) < 0 || n != stringBuilder.length() - 1)) {
                System.err.println("\u8b66\u544a2:\u6982\u8981(\u3002)=\t" + string11);
                System.err.println("\u300c" + stringBuilder + "\u300d");
            }
            Tag[] tagArray4 = executableMemberDoc.tags(OG_TAG_NAME);
            if (debugLevel >= 3 && stringBuilder.indexOf("\u3010\u5ec3\u6b62\u3011") < 0 && !(tagArray4.length > 0 ^ stringBuilder.indexOf("\u3010") < 0)) {
                System.err.println("\u8b66\u544a3:ogTag=\t" + string11);
            }
            if (debugLevel >= 5 && tagArray.length > 0 && tagArray4.length > 0 && (stringArray = (string10 = tagArray[0].text().trim()).split("[\\s]+")).length > 1 && stringArray[1].length() > 10) {
                System.err.println("\u8b66\u544a5:PRM\u629c\u51fa=\t" + string11 + " " + stringArray[1]);
            }
        }
    }

    private static void checkTag2(ClassDoc classDoc) {
        FieldDoc fieldDoc = DocletSpecific.findFieldDoc(classDoc, "VERSION");
        if (fieldDoc != null && debugLevel >= 4) {
            FieldDoc fieldDoc2;
            String string = fieldDoc.constantValueExpression();
            if (string == null) {
                string = "0.0.0.0 (0000/00/00)";
            } else if (string.length() > 1 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
                string = string.substring(1, string.length() - 1);
            }
            String string2 = string;
            int n = string2.length();
            boolean bl = false;
            Doc[][] docArrayArray = new Doc[][]{{classDoc}, classDoc.constructors(false), classDoc.fields(false), classDoc.methods(false)};
            for (int i = 0; i < docArrayArray.length; ++i) {
                for (int j = 0; j < docArrayArray[i].length; ++j) {
                    Doc doc = docArrayArray[i][j];
                    Tag[] tagArray = doc.tags(OG_REV);
                    for (int k = 0; k < tagArray.length; ++k) {
                        String string3 = tagArray[k].text();
                        if (string3.length() < n) {
                            System.err.println("\u8b66\u544a4:og.rev\u304c\u77ed\u3044=\t" + string3 + "\t" + doc.position());
                            continue;
                        }
                        if (string2.compareTo(string3 = string3.substring(0, n)) >= 0) continue;
                        string2 = string3;
                        bl = true;
                    }
                }
            }
            if (bl) {
                System.err.println("\u8b66\u544a4:VERSION\u304c\u53e4\u3044=\t" + string + " \u21d2 " + string2 + "\t" + fieldDoc.position());
            }
            if ((fieldDoc2 = DocletSpecific.findFieldDoc(classDoc, "serialVersionUID")) != null) {
                StringBuilder stringBuilder = new StringBuilder(200);
                for (int i = 0; i < string2.length(); ++i) {
                    char c = string2.charAt(i);
                    if (c < '0' || c > '9') continue;
                    stringBuilder.append(c);
                }
                stringBuilder.append('L');
                String string4 = stringBuilder.toString();
                String string5 = fieldDoc2.constantValueExpression();
                if (!string4.equals(string5)) {
                    System.err.println("\u8b66\u544a4:serialVersionUID\u304c\u53e4\u3044=\t" + string5 + " \u21d2 " + string4 + "\t" + fieldDoc2.position());
                }
            }
        }
    }

    private static void checkPMD(ClassDoc classDoc) {
        Object object;
        if (!(!classDoc.isStatic() || classDoc.isEnum() || classDoc.isEnumConstant() || classDoc.isFinal() || (object = classDoc.commentText()) != null && ((String)object).contains("\u7d99\u627f\u3055\u308c\u308b") || "Enum".equalsIgnoreCase(classDoc.superclass().name()))) {
            String string = classDoc.modifiers() + " " + classDoc.name() + "\t" + classDoc.position();
            System.err.println("\u8b66\u544a5:private static final=\t" + string);
        }
        if (!(classDoc.isPrivate() && classDoc.isStatic() && classDoc.isFinal())) {
            for (FieldDoc fieldDoc : classDoc.fields(false)) {
                String string;
                String string2 = fieldDoc.commentText();
                if (string2 != null && (string2.contains("Concurrent") || string2.contains("synchronized")) || !"Map".equals(string = fieldDoc.type().simpleTypeName())) continue;
                String string3 = fieldDoc.modifiers() + " " + string + " " + fieldDoc.name() + "\t" + fieldDoc.position();
                System.err.println("\u8b66\u544a5:ConcurrentHashMap=\t" + string3);
            }
        }
    }

    private static void menberTag(ExecutableMemberDoc executableMemberDoc, String string, DocletTagWriter docletTagWriter, int n) {
        Tag[] tagArray;
        Tag[] tagArray2;
        String string2;
        StringBuilder stringBuilder;
        Object object;
        if (executableMemberDoc instanceof MethodDoc) {
            object = ((MethodDoc)executableMemberDoc).returnType();
            stringBuilder = new StringBuilder(200).append(executableMemberDoc.modifiers()).append(' ').append(object.typeName());
            if (object.dimension() != null) {
                stringBuilder.append(object.dimension());
            }
            string2 = stringBuilder.toString();
        } else {
            string2 = executableMemberDoc.modifiers();
        }
        object = executableMemberDoc.name();
        stringBuilder = new StringBuilder(200).append((String)object).append('(');
        Parameter[] parameterArray = executableMemberDoc.parameters();
        for (int i = 0; i < parameterArray.length; ++i) {
            tagArray2 = parameterArray[i].type();
            tagArray = parameterArray[i].name();
            stringBuilder.append(tagArray2.typeName()).append(tagArray2.dimension()).append(' ').append((String)tagArray).append(',');
        }
        if (parameterArray.length > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append(')');
        String string3 = stringBuilder.toString();
        tagArray2 = executableMemberDoc.firstSentenceTags();
        tagArray = executableMemberDoc.inlineTags();
        Tag[] tagArray3 = executableMemberDoc.tags();
        Tag[] tagArray4 = executableMemberDoc.tags(OG_REV);
        String string4 = String.valueOf(n);
        String string5 = n == 0 ? "" : executableMemberDoc.containingClass().qualifiedName();
        String string6 = String.valueOf(executableMemberDoc.position().line());
        docletTagWriter.printTag("  <menber>");
        docletTagWriter.printTag("    <type>", string, "</type>");
        docletTagWriter.printTag(new String[]{"    <name>", object, "</name>"});
        docletTagWriter.printTag("    <modifiers>", string2, "</modifiers>");
        docletTagWriter.printTag("    <signature>", string3, "</signature>");
        docletTagWriter.printTag("    <position>", string6, "</position>");
        docletTagWriter.printTag("    <extendClass>", string5, "</extendClass>");
        docletTagWriter.printTag("    <extendFlag>", string4, "</extendFlag>");
        docletTagWriter.printTag("    <description>", tagArray2, "</description>");
        docletTagWriter.printTag("    <contents>", tagArray, "</contents>");
        docletTagWriter.printTag("    <tagText>");
        docletTagWriter.printTagsInfo(tagArray3);
        docletTagWriter.printTag("    </tagText>");
        docletTagWriter.printTag("    <history>", tagArray4, "</history>");
        docletTagWriter.printTag("  </menber>");
    }

    private static FieldDoc findFieldDoc(ClassDoc classDoc, String string) {
        FieldDoc fieldDoc = null;
        FieldDoc[] fieldDocArray = classDoc.fields(false);
        for (int i = 0; i < fieldDocArray.length; ++i) {
            if (!string.equalsIgnoreCase(fieldDocArray[i].name())) continue;
            fieldDoc = fieldDocArray[i];
            break;
        }
        return fieldDoc;
    }

    public static int optionLength(String string) {
        if ("-version".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("-outfile".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("-debugLevel".equalsIgnoreCase(string)) {
            return 2;
        }
        return 0;
    }

    static {
        PTN = Pattern.compile("[\\w\\s]+");
    }
}

